/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robocraft999.creategoggles.registry.CGRecipeTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CreateGogglesRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @javax.annotation.Nullable
    private String group;

    public CreateGogglesRecipeBuilder(ItemLike result, int count) {
        this.result = result.m_5456_();
        this.count = count;
    }

    public static CreateGogglesRecipeBuilder shaped(ItemLike result) {
        return CreateGogglesRecipeBuilder.shaped(result, 1);
    }

    public static CreateGogglesRecipeBuilder shaped(ItemLike result, int count) {
        return new CreateGogglesRecipeBuilder(result, count);
    }

    public CreateGogglesRecipeBuilder define(Character tag, TagKey<Item> item) {
        return this.define(tag, Ingredient.m_204132_(item));
    }

    public CreateGogglesRecipeBuilder define(Character tag, ItemLike item) {
        return this.define(tag, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public CreateGogglesRecipeBuilder define(Character tag, Ingredient item) {
        if (this.key.containsKey(tag)) {
            throw new IllegalArgumentException("Symbol '" + tag + "' is already defined!");
        }
        if (tag.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(tag, item);
        return this;
    }

    public CreateGogglesRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public CreateGogglesRecipeBuilder unlockedBy(String name, CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return this;
    }

    public CreateGogglesRecipeBuilder group(@javax.annotation.Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> writer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        writer.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + id.m_135815_())));
    }

    private void ensureValid(ResourceLocation p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation resourceLocation, Item item, int i, String string, List<String> list, Map<Character, Ingredient> map, Advancement.Builder builder, ResourceLocation resourceLocation2) {
            this.id = resourceLocation;
            this.result = item;
            this.count = i;
            this.group = string;
            this.pattern = list;
            this.key = map;
            this.advancement = builder;
            this.advancementId = resourceLocation2;
        }

        public void m_7917_(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : this.pattern) {
                jsonArray.add(string);
            }
            jsonObject.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject2 = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonObject2.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            jsonObject.add("key", (JsonElement)jsonObject2);
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject3.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject3);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)CGRecipeTypes.CRAFTING_NBT.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

