/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedflywheels.wheel;

import com.rabbitminers.extendedflywheels.wheel.IVisualRotationWheel;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class WheelTileEntity
extends KineticTileEntity
implements IVisualRotationWheel {
    boolean hasForcedSpeed = false;
    float forcedSpeed = 0.0f;
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;

    public WheelTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public float getSpeed() {
        return this.hasForcedSpeed ? this.forcedSpeed : super.getSpeed();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.015625, LerpedFloat.Chaser.EXP);
        }
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            return;
        }
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
    }

    @Override
    public void setForcedSpeed(float speed) {
        this.hasForcedSpeed = true;
        this.forcedSpeed = speed;
        this.visualSpeed.updateChaseTarget(speed);
        this.visualSpeed.tickChaser();
    }

    @Override
    public void unsetForcedSpeed() {
        this.hasForcedSpeed = false;
    }

    @Override
    public void setAngle(float angle) {
        this.angle = angle;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public float getWheelRadius() {
        return 1.40625f;
    }
}

