/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedflywheels.wheel;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.rabbitminers.extendedflywheels.wheel.IVisualRotationWheel;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class CarriageVisualRotationMovementBehaviour
implements MovementBehaviour {
    public boolean isActive(MovementContext context) {
        return context.contraption instanceof CarriageContraption;
    }

    public boolean renderAsNormalTileEntity() {
        return true;
    }

    private IVisualRotationWheel getTE(MovementContext context) {
        Map tes = context.contraption.presentTileEntities;
        Object v = tes.get(context.localPos);
        if (!(v instanceof IVisualRotationWheel)) {
            return null;
        }
        IVisualRotationWheel speedForcibleTE = (IVisualRotationWheel)v;
        return speedForcibleTE;
    }

    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
        if (abstractContraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
            if (!context.world.f_46443_) {
                return;
            }
            Map tes = context.contraption.presentTileEntities;
            Object v = tes.get(context.localPos);
            if (!(v instanceof IVisualRotationWheel)) {
                return;
            }
            IVisualRotationWheel speedForcible = (IVisualRotationWheel)v;
            Contraption contraption = context.contraption;
            if (!(contraption instanceof CarriageContraption)) {
                return;
            }
            CarriageContraption carriageContraption = (CarriageContraption)contraption;
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            Direction direction = carriageContraption.getAssemblyDirection();
            double distanceTo = 0.0;
            if (!cce.firstPositionUpdate) {
                Vec3 diff = context.motion;
                Vec3 relativeDiff = VecHelper.rotate((Vec3)diff, (double)cce.yaw, (Direction.Axis)Direction.Axis.Y);
                double signum = Math.signum(-relativeDiff.f_82479_);
                distanceTo = diff.m_82553_() * signum / 3.0;
            }
            double wheelRadius = speedForcible.getWheelRadius();
            double angleDiff = 360.0 * distanceTo / (Math.PI * 2 * wheelRadius);
            float speed = (float)(angleDiff * 10.0 / 3.0);
            switch (direction) {
                case NORTH: 
                case EAST: {
                    speedForcible.setAngle((float)(((double)speedForcible.getAngle() + angleDiff * 3.0 / 10.0) % 360.0));
                    break;
                }
                case SOUTH: 
                case WEST: {
                    speedForcible.setAngle((float)(((double)speedForcible.getAngle() - angleDiff * 3.0 / 10.0) % 360.0));
                }
            }
        }
    }

    public void stopMoving(MovementContext context) {
        if (!context.world.f_46443_ || !this.isActive(context)) {
            return;
        }
        IVisualRotationWheel speedForcible = this.getTE(context);
        if (speedForcible != null) {
            speedForcible.unsetForcedSpeed();
        }
    }
}

