/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris;

import com.google.common.base.Throwables;
import com.mojang.blaze3d.platform.GlDebug;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import net.coderbot.iris.IrisLogging;
import net.coderbot.iris.config.IrisConfig;
import net.coderbot.iris.gl.GLDebug;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.PipelineManager;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.discovery.ShaderpackDirectoryManager;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.Profile;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.option.values.OptionValues;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

@Mod(value="oculus")
public class Iris {
    public static final String MODID = "oculus";
    public static final String MODNAME = "Oculus";
    public static final IrisLogging logger = new IrisLogging("Oculus");
    private static Path shaderpacksDirectory;
    private static ShaderpackDirectoryManager shaderpacksDirectoryManager;
    private static ShaderPack currentPack;
    private static String currentPackName;
    private static boolean sodiumInstalled;
    private static boolean initialized;
    private static PipelineManager pipelineManager;
    private static IrisConfig irisConfig;
    private static FileSystem zipFileSystem;
    private static KeyMapping reloadKeybind;
    private static KeyMapping toggleShadersKeybind;
    private static KeyMapping shaderpackScreenKeybind;
    private static final Map<String, String> shaderPackOptionQueue;
    private static boolean resetShaderPackOptions;
    private static String IRIS_VERSION;
    public static DimensionId lastDimension;

    public Iris() {
        try {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onInitializeClient);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onKeyRegister);
            ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onEarlyInitialize() {
        try {
            if (!Files.exists(Iris.getShaderpacksDirectory(), new LinkOption[0])) {
                Files.createDirectories(Iris.getShaderpacksDirectory(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to create the shaderpacks directory!");
            logger.warn("", e);
        }
        irisConfig = new IrisConfig(FMLPaths.CONFIGDIR.get().resolve("oculus.properties"));
        try {
            irisConfig.initialize();
        }
        catch (IOException e) {
            logger.error("Failed to initialize Oculus configuration, default values will be used instead");
            logger.error("", e);
        }
        reloadKeybind = new KeyMapping("iris.keybind.reload", InputConstants.Type.KEYSYM, 82, "iris.keybinds");
        toggleShadersKeybind = new KeyMapping("iris.keybind.toggleShaders", InputConstants.Type.KEYSYM, 75, "iris.keybinds");
        shaderpackScreenKeybind = new KeyMapping("iris.keybind.shaderPackSelection", InputConstants.Type.KEYSYM, 79, "iris.keybinds");
        this.setupCommands(Minecraft.m_91087_());
        initialized = true;
    }

    public void onInitializeClient(FMLClientSetupEvent event) {
        IRIS_VERSION = ((ModContainer)ModList.get().getModContainerById(MODID).get()).getModInfo().getVersion().toString();
    }

    public void onKeyRegister(RegisterKeyMappingsEvent event) {
        event.register(reloadKeybind);
        event.register(toggleShadersKeybind);
        event.register(shaderpackScreenKeybind);
    }

    private void setupCommands(Minecraft instance) {
    }

    public static void onRenderSystemInit() {
        if (!initialized) {
            logger.warn("Iris::onRenderSystemInit was called, but Iris::onEarlyInitialize was not called. Trying to avoid a crash but this is an odd state.");
            return;
        }
        Iris.setDebug(irisConfig.areDebugOptionsEnabled());
        Iris.loadShaderpack();
    }

    public static void onLoadingComplete() {
        if (!initialized) {
            logger.warn("Iris::onLoadingComplete was called, but Iris::onEarlyInitialize was not called. Trying to avoid a crash but this is an odd state.");
            return;
        }
        lastDimension = DimensionId.OVERWORLD;
        Iris.getPipelineManager().preparePipeline(DimensionId.OVERWORLD);
    }

    public static void handleKeybinds(Minecraft minecraft) {
        block11: {
            if (reloadKeybind.m_90859_()) {
                try {
                    Iris.reload();
                    if (minecraft.f_91074_ != null) {
                        minecraft.f_91074_.m_5661_((Component)Component.m_237115_((String)"iris.shaders.reloaded"), false);
                    }
                    break block11;
                }
                catch (Exception e) {
                    logger.error("Error while reloading Shaders for Iris!", e);
                    if (minecraft.f_91074_ != null) {
                        minecraft.f_91074_.m_5661_((Component)Component.m_237110_((String)"iris.shaders.reloaded.failure", (Object[])new Object[]{Throwables.getRootCause((Throwable)e).getMessage()}).m_130940_(ChatFormatting.RED), false);
                    }
                    break block11;
                }
            }
            if (toggleShadersKeybind.m_90859_()) {
                try {
                    Iris.toggleShaders(minecraft, !irisConfig.areShadersEnabled());
                }
                catch (Exception e) {
                    logger.error("Error while toggling shaders!", e);
                    if (minecraft.f_91074_ != null) {
                        minecraft.f_91074_.m_5661_((Component)Component.m_237110_((String)"iris.shaders.toggled.failure", (Object[])new Object[]{Throwables.getRootCause((Throwable)e).getMessage()}).m_130940_(ChatFormatting.RED), false);
                    }
                    Iris.setShadersDisabled();
                    currentPackName = "(off) [fallback, check your logs for errors]";
                }
            } else if (shaderpackScreenKeybind.m_90859_()) {
                minecraft.m_91152_((Screen)new ShaderPackScreen(null));
            }
        }
    }

    public static void toggleShaders(Minecraft minecraft, boolean enabled) throws IOException {
        irisConfig.setShadersEnabled(enabled);
        irisConfig.save();
        Iris.reload();
        if (minecraft.f_91074_ != null) {
            minecraft.f_91074_.m_5661_((Component)(enabled ? Component.m_237110_((String)"iris.shaders.toggled", (Object[])new Object[]{currentPackName}) : Component.m_237115_((String)"iris.shaders.disabled")), false);
        }
    }

    public static void loadShaderpack() {
        if (irisConfig == null) {
            if (!initialized) {
                throw new IllegalStateException("Iris::loadShaderpack was called, but Iris::onInitializeClient wasn't called yet. How did this happen?");
            }
            throw new NullPointerException("Iris.irisConfig was null unexpectedly");
        }
        if (!irisConfig.areShadersEnabled()) {
            logger.info("Shaders are disabled because enableShaders is set to false in iris.properties");
            Iris.setShadersDisabled();
            return;
        }
        Optional<String> externalName = irisConfig.getShaderPackName();
        if (!externalName.isPresent()) {
            logger.info("Shaders are disabled because no valid shaderpack is selected");
            Iris.setShadersDisabled();
            return;
        }
        if (!Iris.loadExternalShaderpack(externalName.get())) {
            logger.warn("Falling back to normal rendering without shaders because the shaderpack could not be loaded");
            Iris.setShadersDisabled();
            currentPackName = "(off) [fallback, check your logs for errors]";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadExternalShaderpack(String name) {
        Path shaderPackPath;
        Path shaderPackConfigTxt;
        Path shaderPackRoot;
        try {
            shaderPackRoot = Iris.getShaderpacksDirectory().resolve(name);
            shaderPackConfigTxt = Iris.getShaderpacksDirectory().resolve(name + ".txt");
        }
        catch (InvalidPathException e) {
            logger.error("Failed to load the shaderpack \"{}\" because it contains invalid characters in its path", name);
            return false;
        }
        if (shaderPackRoot.toString().endsWith(".zip")) {
            Optional<Path> optionalPath;
            try {
                optionalPath = Iris.loadExternalZipShaderpack(shaderPackRoot);
            }
            catch (FileSystemNotFoundException | NoSuchFileException e) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist in your shaderpacks folder!", name);
                return false;
            }
            catch (ZipException e) {
                logger.error("The shaderpack \"{}\" appears to be corrupted, please try downloading it again!", name);
                return false;
            }
            catch (IOException e) {
                logger.error("Failed to load the shaderpack \"{}\"!", name);
                logger.error("", e);
                return false;
            }
            if (!optionalPath.isPresent()) {
                logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", name);
                return false;
            }
            shaderPackPath = optionalPath.get();
        } else {
            if (!Files.exists(shaderPackRoot, new LinkOption[0])) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist!", name);
                return false;
            }
            shaderPackPath = shaderPackRoot.resolve("shaders");
        }
        if (!Files.exists(shaderPackPath, new LinkOption[0])) {
            logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", name);
            return false;
        }
        Map changedConfigs = Iris.tryReadConfigProperties(shaderPackConfigTxt).map(properties -> properties).orElse(new HashMap());
        changedConfigs.putAll(shaderPackOptionQueue);
        Iris.clearShaderPackOptionQueue();
        if (resetShaderPackOptions) {
            changedConfigs.clear();
        }
        resetShaderPackOptions = false;
        try {
            currentPack = new ShaderPack(shaderPackPath, changedConfigs, StandardMacros.createStandardEnvironmentDefines());
            MutableOptionValues changedConfigsValues = currentPack.getShaderPackOptions().getOptionValues().mutableCopy();
            Properties configsToSave = new Properties();
            changedConfigsValues.getBooleanValues().forEach((k, v) -> configsToSave.setProperty((String)k, Boolean.toString(v)));
            changedConfigsValues.getStringValues().forEach(configsToSave::setProperty);
            Iris.tryUpdateConfigPropertiesFile(shaderPackConfigTxt, configsToSave);
        }
        catch (Exception e) {
            logger.error("Failed to load the shaderpack \"{}\"!", name);
            logger.error("", e);
            return false;
        }
        currentPackName = name;
        logger.info("Using shaderpack: " + name);
        return true;
    }

    private static Optional<Path> loadExternalZipShaderpack(Path shaderpackPath) throws IOException {
        FileSystem zipSystem;
        zipFileSystem = zipSystem = FileSystems.newFileSystem(shaderpackPath, Iris.class.getClassLoader());
        Path root = zipSystem.getRootDirectories().iterator().next();
        Path potentialShaderDir = zipSystem.getPath("shaders", new String[0]);
        if (Files.exists(potentialShaderDir, new LinkOption[0])) {
            return Optional.of(potentialShaderDir);
        }
        return Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.endsWith("shaders")).findFirst();
    }

    private static void setShadersDisabled() {
        currentPack = null;
        currentPackName = "(off)";
        logger.info("Shaders are disabled");
    }

    private static void setDebug(boolean enable) {
        int success;
        if (enable) {
            success = GLDebug.setupDebugMessageCallback();
        } else {
            GlDebug.m_84049_((int)Minecraft.m_91087_().f_91066_.f_92035_, (boolean)false);
            success = 1;
        }
        logger.info("Debug functionality is " + (enable ? "enabled, logging will be more verbose!" : "disabled."));
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)(success != 0 ? (enable ? "iris.shaders.debug.enabled" : "iris.shaders.debug.disabled") : "iris.shaders.debug.failure")), false);
            if (success == 2) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"iris.shaders.debug.restart"), false);
            }
        }
        try {
            irisConfig.setDebugEnabled(enable);
            irisConfig.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Optional<Properties> tryReadConfigProperties(Path path) {
        Properties properties = new Properties();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                properties.load(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.of(properties);
    }

    private static void tryUpdateConfigPropertiesFile(Path path, Properties properties) {
        try {
            if (properties.isEmpty()) {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
                return;
            }
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                properties.store(out, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isValidShaderpack(Path pack) {
        block15: {
            if (Files.isDirectory(pack, new LinkOption[0])) {
                if (pack.equals(Iris.getShaderpacksDirectory())) {
                    return false;
                }
                try {
                    return Files.walk(pack, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.equals(pack)).anyMatch(path -> path.endsWith("shaders"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (pack.toString().endsWith(".zip")) {
                boolean bl;
                block14: {
                    FileSystem zipSystem = FileSystems.newFileSystem(pack, Iris.class.getClassLoader());
                    try {
                        Path root = zipSystem.getRootDirectories().iterator().next();
                        bl = Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).anyMatch(path -> path.endsWith("shaders"));
                        if (zipSystem == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (zipSystem != null) {
                                try {
                                    zipSystem.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ZipError zipError) {
                            logger.warn("The ZIP at " + pack + " is corrupt");
                            break block15;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    zipSystem.close();
                }
                return bl;
            }
        }
        return false;
    }

    public static Map<String, String> getShaderPackOptionQueue() {
        return shaderPackOptionQueue;
    }

    public static void queueShaderPackOptionsFromProfile(Profile profile) {
        Iris.getShaderPackOptionQueue().putAll(profile.optionValues);
    }

    public static void queueShaderPackOptionsFromProperties(Properties properties) {
        Iris.queueDefaultShaderPackOptionValues();
        properties.stringPropertyNames().forEach(key -> Iris.getShaderPackOptionQueue().put((String)key, properties.getProperty((String)key)));
    }

    public static void queueDefaultShaderPackOptionValues() {
        Iris.clearShaderPackOptionQueue();
        Iris.getCurrentPack().ifPresent(pack -> {
            OptionSet options = pack.getShaderPackOptions().getOptionSet();
            OptionValues values = pack.getShaderPackOptions().getOptionValues();
            options.getStringOptions().forEach((key, mOpt) -> {
                if (values.getStringValue((String)key).isPresent()) {
                    Iris.getShaderPackOptionQueue().put((String)key, mOpt.getOption().getDefaultValue());
                }
            });
            options.getBooleanOptions().forEach((key, mOpt) -> {
                if (values.getBooleanValue((String)key) != OptionalBoolean.DEFAULT) {
                    Iris.getShaderPackOptionQueue().put((String)key, Boolean.toString(mOpt.getOption().getDefaultValue()));
                }
            });
        });
    }

    public static void clearShaderPackOptionQueue() {
        Iris.getShaderPackOptionQueue().clear();
    }

    public static void resetShaderPackOptionsOnNextReload() {
        resetShaderPackOptions = true;
    }

    public static boolean shouldResetShaderPackOptionsOnNextReload() {
        return resetShaderPackOptions;
    }

    public static void reload() throws IOException {
        irisConfig.initialize();
        Iris.destroyEverything();
        Iris.loadShaderpack();
        if (Minecraft.m_91087_().f_91073_ != null) {
            Iris.getPipelineManager().preparePipeline(Iris.getCurrentDimension());
        }
    }

    private static void destroyEverything() {
        currentPack = null;
        Iris.getPipelineManager().destroyPipeline();
        if (zipFileSystem != null) {
            try {
                zipFileSystem.close();
            }
            catch (NoSuchFileException e) {
                logger.warn("Failed to close the shaderpack zip when reloading because it was deleted, proceeding anyways.");
            }
            catch (IOException e) {
                logger.error("Failed to close zip file system?", e);
            }
        }
    }

    public static DimensionId getCurrentDimension() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            if (level.m_6042_().f_63837_().equals((Object)BuiltinDimensionTypes.f_223544_) || level.m_46472_().equals((Object)Level.f_46430_)) {
                return DimensionId.END;
            }
            if (level.m_6042_().f_63837_().equals((Object)BuiltinDimensionTypes.f_223543_) || level.m_46472_().equals((Object)Level.f_46429_)) {
                return DimensionId.NETHER;
            }
            return DimensionId.OVERWORLD;
        }
        return lastDimension;
    }

    private static WorldRenderingPipeline createPipeline(DimensionId dimensionId) {
        if (currentPack == null) {
            return new FixedFunctionWorldRenderingPipeline();
        }
        ProgramSet programs = currentPack.getProgramSet(dimensionId);
        try {
            return new NewWorldRenderingPipeline(programs);
        }
        catch (Exception e) {
            logger.error("Failed to create shader rendering pipeline, disabling shaders!", e);
            currentPackName = "(off) [fallback, check your logs for details]";
            return new FixedFunctionWorldRenderingPipeline();
        }
    }

    @NotNull
    public static PipelineManager getPipelineManager() {
        if (pipelineManager == null) {
            pipelineManager = new PipelineManager(Iris::createPipeline);
        }
        return pipelineManager;
    }

    @NotNull
    public static Optional<ShaderPack> getCurrentPack() {
        return Optional.ofNullable(currentPack);
    }

    public static String getCurrentPackName() {
        return currentPackName;
    }

    public static IrisConfig getIrisConfig() {
        return irisConfig;
    }

    public static String getVersion() {
        if (IRIS_VERSION == null) {
            return "Version info unknown!";
        }
        return IRIS_VERSION;
    }

    public static String getFormattedVersion() {
        ChatFormatting color;
        String version = Iris.getVersion();
        if (version.endsWith("-development-environment")) {
            color = ChatFormatting.GOLD;
            version = version.replace("-development-environment", " (Development Environment)");
        } else {
            color = version.endsWith("-dirty") || version.contains("unknown") || version.endsWith("-nogit") ? ChatFormatting.RED : (version.contains("+rev.") ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GREEN);
        }
        return color + version;
    }

    public static boolean isSodiumInstalled() {
        return sodiumInstalled;
    }

    public static Path getShaderpacksDirectory() {
        if (shaderpacksDirectory == null) {
            shaderpacksDirectory = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
        }
        return shaderpacksDirectory;
    }

    public static ShaderpackDirectoryManager getShaderpacksDirectoryManager() {
        if (shaderpacksDirectoryManager == null) {
            shaderpacksDirectoryManager = new ShaderpackDirectoryManager(Iris.getShaderpacksDirectory());
        }
        return shaderpacksDirectoryManager;
    }

    static {
        sodiumInstalled = FMLLoader.getLoadingModList().getModFileById("rubidium") != null;
        shaderPackOptionQueue = new HashMap<String, String>();
        resetShaderPackOptions = false;
        lastDimension = null;
    }
}

