/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLanguage.class}, priority=990)
public class MixinClientLanguage {
    private static final String LOAD = "Lnet/minecraft/client/resources/language/ClientLanguage;loadFrom(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;)Lnet/minecraft/client/resources/language/ClientLanguage;";
    @Unique
    private static final List<String> languageCodes = new ArrayList<String>();
    @Shadow
    @Final
    private Map<String, String> f_118910_;

    @Inject(method={"getOrDefault"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$addLanguageEntries(String key, CallbackInfoReturnable<String> cir) {
        String override = this.iris$lookupOverriddenEntry(key);
        if (override != null) {
            cir.setReturnValue((Object)override);
        }
    }

    @Inject(method={"has"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$addLanguageEntriesToTranslationChecks(String key, CallbackInfoReturnable<Boolean> cir) {
        String override = this.iris$lookupOverriddenEntry(key);
        if (override != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private String iris$lookupOverriddenEntry(String key) {
        ShaderPack pack = Iris.getCurrentPack().orElse(null);
        if (pack == null) {
            return null;
        }
        LanguageMap languageMap = pack.getLanguageMap();
        if (this.f_118910_.containsKey(key)) {
            return null;
        }
        for (String code : languageCodes) {
            String translation;
            Map<String, String> translations = languageMap.getTranslations(code);
            if (translations == null || (translation = translations.get(key)) == null) continue;
            return translation;
        }
        return null;
    }

    @Inject(method={"Lnet/minecraft/client/resources/language/ClientLanguage;loadFrom(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;)Lnet/minecraft/client/resources/language/ClientLanguage;"}, at={@At(value="HEAD")})
    private static void check(ResourceManager resourceManager, List<LanguageInfo> definitions, CallbackInfoReturnable<ClientLanguage> cir) {
        languageCodes.clear();
        new LinkedList<LanguageInfo>(definitions).descendingIterator().forEachRemaining(languageDefinition -> languageCodes.add(languageDefinition.getCode()));
    }
}

