/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.GameType;

public class IrisExclusiveUniforms {
    public static void addIrisExclusiveUniforms(UniformHolder uniforms) {
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "thunderStrength", IrisExclusiveUniforms::getThunderStrength);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHealth", IrisExclusiveUniforms::getCurrentHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHealth", IrisExclusiveUniforms::getMaxHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHunger", IrisExclusiveUniforms::getCurrentHunger);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHunger", () -> 20);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerAir", IrisExclusiveUniforms::getCurrentAir);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerAir", IrisExclusiveUniforms::getMaxAir);
        uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "firstPersonCamera", IrisExclusiveUniforms::isFirstPersonCamera);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "isSpectator", IrisExclusiveUniforms::isSpectator);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "eyePosition", IrisExclusiveUniforms::getEyePosition);
    }

    private static float getThunderStrength() {
        return Math.clamp(0.0f, 1.0f, Minecraft.m_91087_().f_91073_.m_46661_(CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    private static float getCurrentHealth() {
        if (Minecraft.m_91087_().f_91074_ == null || !Minecraft.m_91087_().f_91072_.m_105295_().m_46409_()) {
            return -1.0f;
        }
        return Minecraft.m_91087_().f_91074_.m_21223_() / Minecraft.m_91087_().f_91074_.m_21233_();
    }

    private static float getCurrentHunger() {
        if (Minecraft.m_91087_().f_91074_ == null || !Minecraft.m_91087_().f_91072_.m_105295_().m_46409_()) {
            return -1.0f;
        }
        return (float)Minecraft.m_91087_().f_91074_.m_36324_().m_38702_() / 20.0f;
    }

    private static float getCurrentAir() {
        if (Minecraft.m_91087_().f_91074_ == null || !Minecraft.m_91087_().f_91072_.m_105295_().m_46409_()) {
            return -1.0f;
        }
        return (float)Minecraft.m_91087_().f_91074_.m_20146_() / (float)Minecraft.m_91087_().f_91074_.m_6062_();
    }

    private static float getMaxAir() {
        if (Minecraft.m_91087_().f_91074_ == null || !Minecraft.m_91087_().f_91072_.m_105295_().m_46409_()) {
            return -1.0f;
        }
        return Minecraft.m_91087_().f_91074_.m_6062_();
    }

    private static float getMaxHealth() {
        if (Minecraft.m_91087_().f_91074_ == null || !Minecraft.m_91087_().f_91072_.m_105295_().m_46409_()) {
            return -1.0f;
        }
        return Minecraft.m_91087_().f_91074_.m_21233_();
    }

    private static boolean isFirstPersonCamera() {
        switch (Minecraft.m_91087_().f_91066_.m_92176_()) {
            case THIRD_PERSON_BACK: 
            case THIRD_PERSON_FRONT: {
                return false;
            }
        }
        return true;
    }

    private static boolean isSpectator() {
        return Minecraft.m_91087_().f_91072_.m_105295_() == GameType.SPECTATOR;
    }

    private static Vector3d getEyePosition() {
        return new Vector3d(Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20188_(), Minecraft.m_91087_().f_91074_.m_20189_());
    }
}

