/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallCandleSkullBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedSkullBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SkullWithWaxTileRenderer<T extends EnhancedSkullBlockTile>
implements BlockEntityRenderer<T> {
    private final BlockEntityRenderDispatcher dispatcher;
    protected final BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
    protected final SkullModelBase overlay;

    protected SkullWithWaxTileRenderer(BlockEntityRendererProvider.Context context) {
        this.overlay = new SkullModel(context.m_173582_(ClientRegistry.SKULL_CANDLE_OVERLAY));
        this.dispatcher = context.m_173581_();
    }

    public void render(T tile, float pPartialTicks, PoseStack poseStack, MultiBufferSource buffer, int pCombinedLight, int pCombinedOverlay) {
        BlockEntity inner = ((EnhancedSkullBlockTile)((Object)tile)).getSkullTile();
        if (inner != null) {
            float yaw;
            boolean wall = false;
            BlockState state = tile.m_58900_();
            if (state.m_61138_((Property)WallCandleSkullBlock.FACING)) {
                yaw = ((Direction)state.m_61143_((Property)WallCandleSkullBlock.FACING)).m_122435_();
                wall = true;
            } else {
                yaw = -22.5f * (float)((Integer)state.m_61143_((Property)SkullBlock.f_56314_) - (Integer)inner.m_58900_().m_61143_((Property)SkullBlock.f_56314_));
            }
            if (!wall) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
                poseStack.m_85837_(-0.5, -0.5, -0.5);
            } else {
                poseStack.m_85837_(0.0, -0.25, 0.0);
            }
            this.renderInner(inner, pPartialTicks, poseStack, buffer, pCombinedLight, pCombinedOverlay);
            if (wall) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
                poseStack.m_85837_(-0.5, -0.25, -0.25);
            }
        }
    }

    public <B extends BlockEntity> void renderInner(B tile, float pPartialTicks, PoseStack poseStack, MultiBufferSource buffer, int pCombinedLight, int pCombinedOverlay) {
        BlockEntityRenderer renderer = this.dispatcher.m_112265_(tile);
        if (renderer != null) {
            renderer.m_6922_(tile, pPartialTicks, poseStack, buffer, pCombinedLight, pCombinedOverlay);
        }
    }

    public void renderWax(PoseStack poseStack, MultiBufferSource buffer, int pCombinedLight, @Nullable ResourceLocation texture, float yaw) {
        if (texture == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.25, 0.5);
        float s = 1.077f;
        poseStack.m_85841_(-s, -s, s);
        poseStack.m_85837_(0.0, 0.25, 0.0);
        RenderType overlayTexture = RenderType.m_110464_((ResourceLocation)texture);
        VertexConsumer vertexconsumer = buffer.m_6299_(overlayTexture);
        this.overlay.m_6251_(0.0f, -yaw, 0.0f);
        this.overlay.m_7695_(poseStack, vertexconsumer, pCombinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

