/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholdsCommon;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterstrongholds.world.ItemFrameChances;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ItemFrameProcessor
extends StructureProcessor {
    public static final ItemFrameProcessor INSTANCE = new ItemFrameProcessor();
    public static final Codec<StructureProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.f_74685_.m_128461_("id").equals("minecraft:item_frame")) {
            String randomItemString;
            String item;
            RandomSource random = structurePlaceSettings.m_230326_(globalEntityInfo.f_74684_);
            try {
                item = globalEntityInfo.f_74685_.m_128469_("Item").m_128423_("id").toString();
            }
            catch (Exception e) {
                BetterStrongholdsCommon.LOGGER.info("Unable to randomize item frame at {}", (Object)globalEntityInfo.f_74684_);
                return globalEntityInfo;
            }
            CompoundTag newNBT = globalEntityInfo.f_74685_.m_6426_();
            if (item.equals("\"minecraft:iron_sword\"")) {
                randomItemString = Registry.f_122827_.m_7981_((Object)ItemFrameChances.get().getArmouryItem(random)).toString();
                if (!randomItemString.equals("minecraft:air")) {
                    newNBT.m_128469_("Item").m_128359_("id", randomItemString);
                }
            } else if (item.equals("\"minecraft:bread\"") && !(randomItemString = Registry.f_122827_.m_7981_((Object)ItemFrameChances.get().getStorageItem(random)).toString()).equals("minecraft:air")) {
                newNBT.m_128469_("Item").m_128359_("id", randomItemString);
            }
            newNBT.m_128405_("TileX", globalEntityInfo.f_74684_.m_123341_());
            newNBT.m_128405_("TileY", globalEntityInfo.f_74684_.m_123342_());
            newNBT.m_128405_("TileZ", globalEntityInfo.f_74684_.m_123343_());
            int randomRotation = random.m_188503_(8);
            newNBT.m_128344_("ItemRotation", (byte)randomRotation);
            globalEntityInfo = new StructureTemplate.StructureEntityInfo(globalEntityInfo.f_74683_, globalEntityInfo.f_74684_, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.ITEMFRAME_PROCESSOR;
    }
}

