/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.ConnectorBlock;
import com.mrh0.createaddition.blocks.connector.ConnectorMode;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class ConnectorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IObserveTileEntity,
IHaveGoggleInformation,
IDebugDrawer {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes = new LocalNode[this.getNodeCount()];
    private final IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    private EnergyNetwork network;
    private int demand = 0;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public static Vec3 OFFSET_DOWN = new Vec3(0.0, -0.1875, 0.0);
    public static Vec3 OFFSET_UP = new Vec3(0.0, 0.1875, 0.0);
    public static Vec3 OFFSET_NORTH = new Vec3(0.0, 0.0, -0.1875);
    public static Vec3 OFFSET_WEST = new Vec3(-0.1875, 0.0, 0.0);
    public static Vec3 OFFSET_SOUTH = new Vec3(0.0, 0.0, 0.1875);
    public static Vec3 OFFSET_EAST = new Vec3(0.1875, 0.0, 0.0);
    public static final int NODE_COUNT = 4;
    public static final int CAPACITY = (Integer)Config.CONNECTOR_CAPACITY.get();
    public static final int MAX_IN = (Integer)Config.CONNECTOR_MAX_INPUT.get();
    public static final int MAX_OUT = (Integer)Config.CONNECTOR_MAX_OUTPUT.get();

    public ConnectorTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, MAX_OUT);
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.f_58857_);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, BlockPos pos, WireType type) {
        this.localNodes[index] = new LocalNode((BlockEntity)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.nodeCache[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public int getNodeCount() {
        return 4;
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        return switch ((Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> OFFSET_DOWN;
            case Direction.UP -> OFFSET_UP;
            case Direction.NORTH -> OFFSET_NORTH;
            case Direction.WEST -> OFFSET_WEST;
            case Direction.SOUTH -> OFFSET_SOUTH;
            case Direction.EAST -> OFFSET_EAST;
        };
    }

    @Override
    public BlockPos getPos() {
        return this.m_58899_();
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return this.m_58900_().m_61143_((Property)ConnectorBlock.FACING) == side;
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return this.m_58900_().m_61143_((Property)ConnectorBlock.FACING) == side;
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.m_128441_("node0")) {
            this.convertOldNbt(nbt);
            this.m_6596_();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        ListTag nodes = nbt.m_128437_("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((BlockEntity)this, (CompoundTag)tag);
        });
        if (nbt.m_128441_("contraption") && !clientPacket) {
            this.wasContraption = nbt.m_128471_("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.m_58900_().m_61143_(NodeRotation.ROTATION));
            if (rotation != NodeRotation.NONE) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        ListTag nodes = new ListTag();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            CompoundTag tag = new CompoundTag();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.m_128365_("nodes", (Tag)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.network != null) {
                this.network.invalidate();
            }
        }
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            if (this.wasContraption && !this.f_58857_.m_5776_()) {
                this.wasContraption = false;
                this.validateNodes();
            }
        }
        if (!this.wireCache.isEmpty() && !this.m_58901_()) {
            this.handleWireCache(this.f_58857_, this.wireCache);
        }
        if (this.getMode() == ConnectorMode.None) {
            return;
        }
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.awakeNetwork(this.f_58857_)) {
            this.causeBlockUpdate();
        }
        this.networkTick(this.network);
    }

    private void networkTick(EnergyNetwork network) {
        ConnectorMode mode = this.getMode();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        Direction d = (Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING);
        IEnergyStorage ies = (IEnergyStorage)this.getCachedEnergy(d).orElse(null);
        if (ies == null) {
            return;
        }
        if (mode == ConnectorMode.Push || mode == ConnectorMode.Passive) {
            int pull = network.pull(this.demand);
            ies.receiveEnergy(pull, false);
            int testInsert = ies.receiveEnergy(MAX_OUT, true);
            this.demand = network.demand(testInsert);
        }
        if (mode == ConnectorMode.Pull) {
            int extracted = ies.extractEnergy(this.localEnergy.getSpace(), false);
            this.localEnergy.internalProduceEnergy(extracted);
        }
        if (mode == ConnectorMode.Pull || mode == ConnectorMode.Passive) {
            int testExtract = this.localEnergy.extractEnergy(Integer.MAX_VALUE, true);
            int push = network.push(testExtract);
            this.localEnergy.internalConsumeEnergy(push);
        }
    }

    @Override
    public void remove() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public ConnectorMode getMode() {
        return (ConnectorMode)((Object)this.m_58900_().m_61143_(ConnectorBlock.MODE));
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.f_58858_, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.connector.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.mode").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)((ConnectorMode)((Object)this.m_58900_().m_61143_(ConnectorBlock.MODE))).getTooltip().m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_130946_(" ").m_130946_(Util.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe/t").m_130940_(ChatFormatting.AQUA));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Override
    public boolean ignoreCapSide() {
        return ((ConnectorMode)((Object)this.m_58900_().m_61143_(ConnectorBlock.MODE))).isActive();
    }

    @Override
    public void drawDebug() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            BlockPos pos = localNode.getPos();
            BlockState state = this.f_58857_.m_8055_(pos);
            VoxelShape shape = state.m_60816_((BlockGetter)this.f_58857_, pos);
            int color = i == 0 ? 0xFF0000 : (i == 1 ? 65280 : (i == 2 ? 255 : 0xFFFFFF));
            if (!(this.f_58857_.m_7702_(pos) instanceof IWireNode)) {
                shape = Shapes.m_83144_();
                color = 0xFF00FF;
            }
            CreateClient.OUTLINER.chaseAABB((Object)("ca_nodes_" + i), shape.m_83215_().m_82338_(pos)).lineWidth(0.0625f).colored(color);
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING)));
        if (te == null) {
            return;
        }
        LazyOptional cap = te.getCapability(CapabilityEnergy.ENERGY, ((Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING)).m_122424_());
        if (this.ignoreCapSide() && !cap.isPresent()) {
            cap = te.getCapability(CapabilityEnergy.ENERGY);
        }
        if (!cap.isPresent()) {
            return;
        }
        VoxelShape shape = this.f_58857_.m_8055_(te.m_58899_()).m_60816_((BlockGetter)this.f_58857_, te.m_58899_());
        CreateClient.OUTLINER.chaseAABB((Object)"ca_output", shape.m_83215_().m_82338_(te.m_58899_())).lineWidth(0.0625f).colored(0x5B5BFF);
    }
}

