/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.digital_adapter;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.digital_adapter.ISpeedControllerAdapter;
import com.mrh0.createaddition.compat.computercraft.DigitalAdapterPeripheral;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.content.contraptions.fluids.actors.HosePulleyTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerTileEntity;
import com.simibubi.create.content.contraptions.relays.gauge.SpeedGaugeTileEntity;
import com.simibubi.create.content.contraptions.relays.gauge.StressGaugeTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class DigitalAdapterTileEntity
extends BlockEntity {
    public final List<MutableComponent> textLines = new ArrayList<MutableComponent>();
    public static final int MAX_LINES = 16;
    public static final MutableComponent EMPTY_LINE = Component.m_237113_((String)"");
    protected LazyOptional<DigitalAdapterPeripheral> peripheral;
    private int line = 1;

    public DigitalAdapterTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        for (int i = 0; i < 16; ++i) {
            this.textLines.add(EMPTY_LINE);
        }
        if (CreateAddition.CC_ACTIVE) {
            this.peripheral = LazyOptional.of(() -> Peripherals.createDigitalAdapterPeripheral(this));
        }
    }

    public void incrementLine() {
        this.line = Math.min(this.line + 1, 16);
    }

    public void setTextLine(int ln, MutableComponent text) {
        if (ln < 1 || ln > 16) {
            return;
        }
        this.textLines.set(ln - 1, text);
    }

    public MutableComponent getTextLine(int ln) {
        if (ln < 1 || ln > 16) {
            return EMPTY_LINE;
        }
        return this.textLines.get(ln - 1);
    }

    public void clearLine(int ln) {
        this.setTextLine(ln, EMPTY_LINE);
    }

    public void clearAll() {
        for (int i = 1; i < 17; ++i) {
            this.clearLine(i);
        }
    }

    public void append(int ln, MutableComponent text) {
        this.setTextLine(ln, this.getTextLine(ln).m_7220_((Component)text));
    }

    public int getLine() {
        return this.line;
    }

    public int setLine(int ln) {
        this.line = ln < 1 || ln > 16 ? this.line : ln;
        return this.line;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (CreateAddition.CC_ACTIVE && Peripherals.isPeripheral(cap)) {
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public SpeedControllerTileEntity getSpeedController(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof SpeedControllerTileEntity) {
            SpeedControllerTileEntity scte = (SpeedControllerTileEntity)be;
            return scte;
        }
        return null;
    }

    public PulleyTileEntity getRopePulley(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof PulleyTileEntity) {
            PulleyTileEntity pte = (PulleyTileEntity)be;
            return pte;
        }
        return null;
    }

    public HosePulleyTileEntity getHosePulley(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof HosePulleyTileEntity) {
            HosePulleyTileEntity pte = (HosePulleyTileEntity)be;
            return pte;
        }
        return null;
    }

    public MechanicalPistonTileEntity getMechanicalPiston(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof MechanicalPistonTileEntity) {
            MechanicalPistonTileEntity mpte = (MechanicalPistonTileEntity)be;
            return mpte;
        }
        return null;
    }

    public MechanicalBearingTileEntity getMechanicalBearing(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof MechanicalBearingTileEntity) {
            MechanicalBearingTileEntity mpte = (MechanicalBearingTileEntity)be;
            return mpte;
        }
        return null;
    }

    public StressGaugeTileEntity getStressGauge(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof StressGaugeTileEntity) {
            StressGaugeTileEntity sgte = (StressGaugeTileEntity)be;
            return sgte;
        }
        return null;
    }

    public SpeedGaugeTileEntity getSpeedGauge(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof SpeedGaugeTileEntity) {
            SpeedGaugeTileEntity sgte = (SpeedGaugeTileEntity)be;
            return sgte;
        }
        return null;
    }

    public void setTargetSpeed(Direction dir, int speed) {
        SpeedControllerTileEntity scte = this.getSpeedController(dir);
        if (scte == null) {
            return;
        }
        ISpeedControllerAdapter sts = (ISpeedControllerAdapter)scte;
        sts.setTargetSpeed(speed);
    }

    public int getTargetSpeed(Direction dir) {
        SpeedControllerTileEntity scte = this.getSpeedController(dir);
        if (scte == null) {
            return 0;
        }
        ISpeedControllerAdapter sts = (ISpeedControllerAdapter)scte;
        return sts.getTargetSpeed();
    }
}

