/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CuttingBoardBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public CuttingBoardBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static void spawnCuttingParticles(Level level, BlockPos pos, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)level.f_46441_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)level.f_46441_.m_188501_() - 0.5) * 0.1);
            if (level instanceof ServerLevel) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.1f), (double)((float)pos.m_123343_() + 0.5f), 1, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.1f), (double)((float)pos.m_123343_() + 0.5f), vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CuttingBoardBlockEntity) {
            CuttingBoardBlockEntity cuttingBoardEntity = (CuttingBoardBlockEntity)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack offhandStack = player.m_21206_();
            if (cuttingBoardEntity.isEmpty()) {
                if (!offhandStack.m_41619_()) {
                    if (hand.equals((Object)InteractionHand.MAIN_HAND) && !offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT) && !(heldStack.m_41720_() instanceof BlockItem)) {
                        return InteractionResult.PASS;
                    }
                    if (hand.equals((Object)InteractionHand.OFF_HAND) && offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT)) {
                        return InteractionResult.PASS;
                    }
                }
                if (heldStack.m_41619_()) {
                    return InteractionResult.PASS;
                }
                if (cuttingBoardEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!heldStack.m_41619_()) {
                    ItemStack boardStack = cuttingBoardEntity.getStoredItem().m_41777_();
                    if (cuttingBoardEntity.processStoredItemUsingTool(heldStack, player)) {
                        CuttingBoardBlock.spawnCuttingParticles(level, pos, boardStack, 5);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.CONSUME;
                }
                if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                    if (!player.m_7500_()) {
                        if (!player.m_150109_().m_36054_(cuttingBoardEntity.removeItem())) {
                            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)cuttingBoardEntity.removeItem());
                        }
                    } else {
                        cuttingBoardEntity.removeItem();
                    }
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 0.25f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof CuttingBoardBlockEntity) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((CuttingBoardBlockEntity)tileEntity).getStoredItem());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public boolean m_5568_() {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos floorPos = pos.m_7495_();
        return CuttingBoardBlock.m_49936_((BlockGetter)level, (BlockPos)floorPos) || CuttingBoardBlock.m_49863_((LevelReader)level, (BlockPos)floorPos, (Direction)Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CuttingBoardBlockEntity) {
            return !((CuttingBoardBlockEntity)tileEntity).isEmpty() ? 15 : 0;
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.CUTTING_BOARD.get()).m_155264_(pos, state);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ToolCarvingEvent {
        @SubscribeEvent
        public static void onSneakPlaceTool(PlayerInteractEvent.RightClickBlock event) {
            boolean success;
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            ItemStack heldStack = player.m_21205_();
            BlockEntity tileEntity = level.m_7702_(event.getPos());
            if (player.m_36341_() && !heldStack.m_41619_() && tileEntity instanceof CuttingBoardBlockEntity && (heldStack.m_41720_() instanceof TieredItem || heldStack.m_41720_() instanceof TridentItem || heldStack.m_41720_() instanceof ShearsItem) && (success = ((CuttingBoardBlockEntity)tileEntity).carveToolOnBoard(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack))) {
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

