/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import tcb.spiderstpo.common.entity.movement.DirectionalPathPoint;
import tcb.spiderstpo.common.entity.movement.IAdvancedPathFindingEntity;

public class AdvancedWalkNodeProcessor
extends WalkNodeEvaluator {
    protected static final BlockPathTypes[] PATH_NODE_TYPES = BlockPathTypes.values();
    protected static final Direction[] DIRECTIONS = Direction.values();
    protected static final Vec3i PX = new Vec3i(1, 0, 0);
    protected static final Vec3i NX = new Vec3i(-1, 0, 0);
    protected static final Vec3i PY = new Vec3i(0, 1, 0);
    protected static final Vec3i NY = new Vec3i(0, -1, 0);
    protected static final Vec3i PZ = new Vec3i(0, 0, 1);
    protected static final Vec3i NZ = new Vec3i(0, 0, -1);
    protected static final Vec3i PXPY = new Vec3i(1, 1, 0);
    protected static final Vec3i NXPY = new Vec3i(-1, 1, 0);
    protected static final Vec3i PXNY = new Vec3i(1, -1, 0);
    protected static final Vec3i NXNY = new Vec3i(-1, -1, 0);
    protected static final Vec3i PXPZ = new Vec3i(1, 0, 1);
    protected static final Vec3i NXPZ = new Vec3i(-1, 0, 1);
    protected static final Vec3i PXNZ = new Vec3i(1, 0, -1);
    protected static final Vec3i NXNZ = new Vec3i(-1, 0, -1);
    protected static final Vec3i PYPZ = new Vec3i(0, 1, 1);
    protected static final Vec3i NYPZ = new Vec3i(0, -1, 1);
    protected static final Vec3i PYNZ = new Vec3i(0, 1, -1);
    protected static final Vec3i NYNZ = new Vec3i(0, -1, -1);
    protected IAdvancedPathFindingEntity advancedPathFindingEntity;
    protected boolean startFromGround = true;
    protected boolean checkObstructions;
    protected int pathingSizeOffsetX;
    protected int pathingSizeOffsetY;
    protected int pathingSizeOffsetZ;
    protected EnumSet<Direction> pathableFacings = EnumSet.of(Direction.DOWN);
    protected Direction[] pathableFacingsArray;
    private final Long2LongMap pathNodeTypeCache = new Long2LongOpenHashMap();
    private final Long2ObjectMap<BlockPathTypes> rawPathNodeTypeCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> aabbCollisionCache = new Object2BooleanOpenHashMap();
    protected boolean alwaysAllowDiagonals = true;

    public void setStartPathOnGround(boolean startFromGround) {
        this.startFromGround = startFromGround;
    }

    public void setCheckObstructions(boolean checkObstructions) {
        this.checkObstructions = checkObstructions;
    }

    public void setCanPathWalls(boolean canPathWalls) {
        if (canPathWalls) {
            this.pathableFacings.add(Direction.NORTH);
            this.pathableFacings.add(Direction.EAST);
            this.pathableFacings.add(Direction.SOUTH);
            this.pathableFacings.add(Direction.WEST);
        } else {
            this.pathableFacings.remove(Direction.NORTH);
            this.pathableFacings.remove(Direction.EAST);
            this.pathableFacings.remove(Direction.SOUTH);
            this.pathableFacings.remove(Direction.WEST);
        }
    }

    public void setCanPathCeiling(boolean canPathCeiling) {
        if (canPathCeiling) {
            this.pathableFacings.add(Direction.UP);
        } else {
            this.pathableFacings.remove(Direction.UP);
        }
    }

    public void m_6028_(PathNavigationRegion sourceIn, Mob mob) {
        super.m_6028_(sourceIn, mob);
        if (!(mob instanceof IAdvancedPathFindingEntity)) {
            throw new IllegalArgumentException("Only mobs that extend " + IAdvancedPathFindingEntity.class.getSimpleName() + " are supported. Received: " + mob.getClass().getName());
        }
        this.advancedPathFindingEntity = (IAdvancedPathFindingEntity)mob;
        this.pathingSizeOffsetX = Math.max(1, Mth.m_14143_((float)(this.f_77313_.m_20205_() / 2.0f + 1.0f)));
        this.pathingSizeOffsetY = Math.max(1, Mth.m_14143_((float)(this.f_77313_.m_20206_() + 1.0f)));
        this.pathingSizeOffsetZ = Math.max(1, Mth.m_14143_((float)(this.f_77313_.m_20205_() / 2.0f + 1.0f)));
        this.pathableFacingsArray = this.pathableFacings.toArray(new Direction[0]);
    }

    public void m_6802_() {
        super.m_6802_();
        this.pathNodeTypeCache.clear();
        this.rawPathNodeTypeCache.clear();
        this.aabbCollisionCache.clear();
        this.advancedPathFindingEntity.pathFinderCleanup();
    }

    private boolean checkAabbCollision(AABB aabb) {
        return this.aabbCollisionCache.computeIfAbsent((Object)aabb, p_237237_2_ -> !this.f_77312_.m_45756_((Entity)this.f_77313_, aabb));
    }

    public Node m_7171_() {
        BlockPos initialStartPos;
        int by;
        BlockPos.MutableBlockPos checkPos;
        double z;
        double x;
        block12: {
            x = this.f_77313_.m_20185_();
            double y = this.f_77313_.m_20186_();
            z = this.f_77313_.m_20189_();
            checkPos = new BlockPos.MutableBlockPos();
            by = Mth.m_14107_((double)y);
            BlockState state = this.f_77312_.m_8055_((BlockPos)checkPos.m_122169_(x, (double)by, z));
            if (!this.f_77313_.m_203441_(state.m_60819_())) {
                if (this.m_77361_() && this.f_77313_.m_20069_()) {
                    while (true) {
                        if (state.m_60734_() != Blocks.f_49990_ && state.m_60819_() != Fluids.f_76193_.m_76068_(false)) {
                            --by;
                            break block12;
                        }
                        state = this.f_77312_.m_8055_((BlockPos)checkPos.m_122169_(x, (double)(++by), z));
                    }
                }
                if (this.f_77313_.m_20096_() || !this.startFromGround) {
                    by = Mth.m_14107_((double)(y + Math.min(0.5, Math.max((double)(this.f_77313_.m_20206_() - 0.1f), 0.0))));
                } else {
                    BlockPos blockpos = this.f_77313_.m_20183_();
                    while ((this.f_77312_.m_8055_(blockpos).m_60795_() || this.f_77312_.m_8055_(blockpos).m_60647_((BlockGetter)this.f_77312_, blockpos, PathComputationType.LAND)) && blockpos.m_123342_() > 0) {
                        blockpos = blockpos.m_7495_();
                    }
                    by = blockpos.m_7494_().m_123342_();
                }
            } else {
                while (this.f_77313_.m_203441_(state.m_60819_())) {
                    state = this.f_77312_.m_8055_((BlockPos)checkPos.m_122169_(x, (double)(++by), z));
                }
                --by;
            }
        }
        BlockPos startPos = initialStartPos = new BlockPos(x, (double)by, z);
        long packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.f_77313_, startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_()));
        DirectionalPathPoint startPathPoint = this.openPoint(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_(), packed, false);
        startPathPoint.f_77282_ = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        startPathPoint.f_77281_ = this.f_77313_.m_21439_(startPathPoint.f_77282_);
        startPos = this.findSuitableStartingPosition(startPos, startPathPoint);
        if (!initialStartPos.equals((Object)startPos)) {
            packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.f_77313_, startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_()));
            startPathPoint = this.openPoint(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_(), packed, false);
            startPathPoint.f_77282_ = AdvancedWalkNodeProcessor.unpackNodeType(packed);
            startPathPoint.f_77281_ = this.f_77313_.m_21439_(startPathPoint.f_77282_);
        }
        if (this.f_77313_.m_21439_(startPathPoint.f_77282_) < 0.0f) {
            AABB aabb = this.f_77313_.m_20191_();
            if (this.isSafeStartingPosition((BlockPos)checkPos.m_122169_(aabb.f_82288_, (double)by, aabb.f_82290_)) || this.isSafeStartingPosition((BlockPos)checkPos.m_122169_(aabb.f_82288_, (double)by, aabb.f_82293_)) || this.isSafeStartingPosition((BlockPos)checkPos.m_122169_(aabb.f_82291_, (double)by, aabb.f_82290_)) || this.isSafeStartingPosition((BlockPos)checkPos.m_122169_(aabb.f_82291_, (double)by, aabb.f_82293_))) {
                packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.f_77313_, checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_()));
                startPathPoint = this.openPoint(checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_(), packed, false);
                startPathPoint.f_77282_ = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                startPathPoint.f_77281_ = this.f_77313_.m_21439_(startPathPoint.f_77282_);
            }
        }
        return startPathPoint;
    }

    private long removeNonStartingSides(long packed) {
        long newPacked = packed & 0xFFFFFFFF00000000L;
        for (Direction side : DIRECTIONS) {
            if (!AdvancedWalkNodeProcessor.unpackDirection(side, packed) || !this.isValidStartingSide(side)) continue;
            newPacked = AdvancedWalkNodeProcessor.packDirection(side, newPacked);
        }
        return newPacked;
    }

    protected boolean isValidStartingSide(Direction side) {
        Direction groundSide = this.advancedPathFindingEntity.getGroundSide();
        return side == groundSide || side.m_122434_() != groundSide.m_122434_();
    }

    protected BlockPos findSuitableStartingPosition(BlockPos pos, DirectionalPathPoint startPathPoint) {
        if (startPathPoint.getPathableSides().length == 0) {
            Direction avoidedOffset = this.advancedPathFindingEntity.getGroundSide().m_122424_();
            for (int xo = -1; xo <= 1; ++xo) {
                for (int yo = -1; yo <= 1; ++yo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        BlockPos offsetPos;
                        long packed;
                        BlockPathTypes nodeType;
                        if (xo == avoidedOffset.m_122429_() || yo == avoidedOffset.m_122430_() || zo == avoidedOffset.m_122431_() || (nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed = this.getDirectionalPathNodeTypeCached(this.f_77313_, (offsetPos = pos.m_7918_(xo, yo, zo)).m_123341_(), offsetPos.m_123342_(), offsetPos.m_123343_()))) != BlockPathTypes.WALKABLE || !AdvancedWalkNodeProcessor.unpackDirection(packed)) continue;
                        return offsetPos;
                    }
                }
            }
        }
        return pos;
    }

    private boolean isSafeStartingPosition(BlockPos pos) {
        BlockPathTypes pathnodetype = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.f_77313_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        return this.f_77313_.m_21439_(pathnodetype) >= 0.0f;
    }

    private boolean allowDiagonalPathOptions(Node[] options) {
        return this.alwaysAllowDiagonals || options == null || options.length == 0 || (options[0] == null || options[0].f_77282_ == BlockPathTypes.OPEN || options[0].f_77281_ != 0.0f) && (options.length <= 1 || options[1] == null || options[1].f_77282_ == BlockPathTypes.OPEN || options[1].f_77281_ != 0.0f);
    }

    public int m_6065_(Node[] pathOptions, Node currentPointIn) {
        int k;
        int k2;
        boolean foundDiagonal;
        boolean is3DPathing;
        int k3;
        DirectionalPathPoint currentPoint = currentPointIn instanceof DirectionalPathPoint ? (DirectionalPathPoint)currentPointIn : new DirectionalPathPoint(currentPointIn);
        int openedNodeCount = 0;
        int stepHeight = 0;
        BlockPathTypes nodeTypeAbove = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.f_77313_, currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_));
        if (this.f_77313_.m_21439_(nodeTypeAbove) >= 0.0f) {
            stepHeight = Mth.m_14143_((float)Math.max(1.0f, this.f_77313_.f_19793_));
        }
        double height = (double)currentPoint.f_77272_ - AdvancedWalkNodeProcessor.m_77611_((BlockGetter)this.f_77312_, (BlockPos)new BlockPos(currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_));
        Node[] pathsPZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, stepHeight, height, PZ, this.checkObstructions);
        Node[] pathsNX = this.getSafePoints(currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_, stepHeight, height, NX, this.checkObstructions);
        Node[] pathsPX = this.getSafePoints(currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_, stepHeight, height, PX, this.checkObstructions);
        Node[] pathsNZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, stepHeight, height, NZ, this.checkObstructions);
        for (k3 = 0; k3 < pathsPZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsPZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPZ[k3];
        }
        for (k3 = 0; k3 < pathsNX.length; ++k3) {
            if (!this.isSuitablePoint(pathsNX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNX[k3];
        }
        for (k3 = 0; k3 < pathsPX.length; ++k3) {
            if (!this.isSuitablePoint(pathsPX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPX[k3];
        }
        for (k3 = 0; k3 < pathsNZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsNZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNZ[k3];
        }
        Node[] pathsNY = null;
        if (this.checkObstructions || this.pathableFacings.size() > 1) {
            pathsNY = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, stepHeight, height, NY, this.checkObstructions);
            for (int k4 = 0; k4 < pathsNY.length; ++k4) {
                if (!this.isSuitablePoint(pathsNY[k4], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsNY[k4];
            }
        }
        Node[] pathsPY = null;
        if (this.pathableFacings.size() > 1) {
            pathsPY = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, stepHeight, height, PY, this.checkObstructions);
            for (int k5 = 0; k5 < pathsPY.length; ++k5) {
                if (!this.isSuitablePoint(pathsPY[k5], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsPY[k5];
            }
        }
        boolean allowDiagonalNZ = this.allowDiagonalPathOptions(pathsNZ);
        boolean allowDiagonalPZ = this.allowDiagonalPathOptions(pathsPZ);
        boolean allowDiagonalPX = this.allowDiagonalPathOptions(pathsPX);
        boolean allowDiagonalNX = this.allowDiagonalPathOptions(pathsNX);
        boolean fitsThroughPoles = this.f_77313_.m_20205_() < 0.5f;
        boolean bl = is3DPathing = this.pathableFacings.size() >= 3;
        if (allowDiagonalNZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXNZ = this.getSafePoints(currentPoint.f_77271_ - this.f_77315_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, stepHeight, height, NXNZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.f_77315_ == 1 && this.f_77317_ == 1)) {
                pathsNXNZ = this.getSafePoints(currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_ - this.f_77317_, stepHeight, height, NXNZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                }
            }
        }
        if (allowDiagonalNZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXNZ = this.getSafePoints(currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_ - 1, stepHeight, height, PXNZ, this.checkObstructions);
            for (k = 0; k < pathsPXNZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, pathsPXNZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXNZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXPZ = this.getSafePoints(currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_ + 1, stepHeight, height, NXPZ, this.checkObstructions);
            for (k = 0; k < pathsNXPZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, pathsNXPZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXPZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXPZ = this.getSafePoints(currentPoint.f_77271_ + this.f_77315_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, stepHeight, height, PXPZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.f_77315_ == 1 && this.f_77317_ == 1)) {
                pathsPXPZ = this.getSafePoints(currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_ + this.f_77317_, stepHeight, height, PXPZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                }
            }
        }
        if (this.pathableFacings.size() > 1) {
            int k6;
            int k7;
            boolean foundDiagonal2;
            boolean allowDiagonalPY = this.allowDiagonalPathOptions(pathsPY);
            boolean allowDiagonalNY = this.allowDiagonalPathOptions(pathsNY);
            if (allowDiagonalNY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsNYNX = this.getSafePoints(currentPoint.f_77271_ - this.f_77315_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, stepHeight, height, NXNY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNX, currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.f_77315_ == 1 && this.f_77316_ == 1)) {
                    pathsNYNX = this.getSafePoints(currentPoint.f_77271_ - 1, currentPoint.f_77272_ - this.f_77316_, currentPoint.f_77273_, stepHeight, height, NXNY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNX, currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsNYPX = this.getSafePoints(currentPoint.f_77271_ + 1, currentPoint.f_77272_ - 1, currentPoint.f_77273_, stepHeight, height, PXNY, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPX, currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_, pathsNYPX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPX[k6];
                }
            }
            if (allowDiagonalNY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsNYNZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ - this.f_77316_, currentPoint.f_77273_ - 1, stepHeight, height, NYNZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.f_77316_ == 1 && this.f_77317_ == 1)) {
                    pathsNYNZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_ - this.f_77317_, stepHeight, height, NYNZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsNYPZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_ + 1, stepHeight, height, NYPZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.f_77271_, currentPoint.f_77272_ - 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, pathsNYPZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsPYNX = this.getSafePoints(currentPoint.f_77271_ - 1, currentPoint.f_77272_ + 1, currentPoint.f_77273_, stepHeight, height, NXPY, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNZ, currentPoint.f_77271_ - 1, currentPoint.f_77272_, currentPoint.f_77273_, pathsPYNX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNX[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsPYPX = this.getSafePoints(currentPoint.f_77271_ + this.f_77315_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, stepHeight, height, PXPY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPX, currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.f_77315_ == 1 && this.f_77316_ == 1)) {
                    pathsPYPX = this.getSafePoints(currentPoint.f_77271_ + 1, currentPoint.f_77272_ + this.f_77316_, currentPoint.f_77273_, stepHeight, height, PXPY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPX, currentPoint.f_77271_ + 1, currentPoint.f_77272_, currentPoint.f_77273_, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    }
                }
            }
            if (allowDiagonalPY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsPYNZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_ - 1, stepHeight, height, PYNZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsNZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ - 1, pathsPYNZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsPYPZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ + this.f_77316_, currentPoint.f_77273_ + 1, stepHeight, height, PYPZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.f_77316_ == 1 && this.f_77317_ == 1)) {
                    pathsPYPZ = this.getSafePoints(currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_ + this.f_77317_, stepHeight, height, PYPZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.f_77271_, currentPoint.f_77272_ + 1, currentPoint.f_77273_, (DirectionalPathPoint[])pathsPZ, currentPoint.f_77271_, currentPoint.f_77272_, currentPoint.f_77273_ + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    }
                }
            }
        }
        return openedNodeCount;
    }

    protected boolean isTraversible(DirectionalPathPoint from, DirectionalPathPoint to) {
        if (this.m_77361_() && (from.f_77282_ == BlockPathTypes.WATER || from.f_77282_ == BlockPathTypes.WATER_BORDER || from.f_77282_ == BlockPathTypes.LAVA || to.f_77282_ == BlockPathTypes.WATER || to.f_77282_ == BlockPathTypes.WATER_BORDER || to.f_77282_ == BlockPathTypes.LAVA)) {
            return true;
        }
        boolean dx = to.f_77271_ - from.f_77271_ != 0;
        boolean dy = to.f_77272_ - from.f_77272_ != 0;
        boolean dz = to.f_77273_ - from.f_77273_ != 0;
        boolean isDiagonal = (dx ? 1 : 0) + (dy ? 1 : 0) + (dz ? 1 : 0) > 1;
        Direction[] fromDirections = from.getPathableSides();
        Direction[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            Direction d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                Direction d2 = toDirections[j];
                if (d1 == d2) {
                    return true;
                }
                if (!isDiagonal) continue;
                Direction.Axis a1 = d1.m_122434_();
                Direction.Axis a2 = d2.m_122434_();
                if (a1 == Direction.Axis.X && a2 == Direction.Axis.Y || a1 == Direction.Axis.Y && a2 == Direction.Axis.X) {
                    return !dz;
                }
                if (a1 == Direction.Axis.X && a2 == Direction.Axis.Z || a1 == Direction.Axis.Z && a2 == Direction.Axis.X) {
                    return !dy;
                }
                if ((a1 != Direction.Axis.Z || a2 != Direction.Axis.Y) && (a1 != Direction.Axis.Y || a2 != Direction.Axis.Z)) continue;
                return !dx;
            }
        }
        return false;
    }

    protected static boolean isSharingDirection(DirectionalPathPoint from, DirectionalPathPoint to) {
        Direction[] fromDirections = from.getPathableSides();
        Direction[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            Direction d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                Direction d2 = toDirections[j];
                if (d1 != d2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint newPoint, DirectionalPathPoint currentPoint, boolean allowObstructions) {
        return newPoint != null && !newPoint.f_77279_ && (allowObstructions || newPoint.f_77281_ >= 0.0f || currentPoint.f_77281_ < 0.0f) && this.isTraversible(currentPoint, newPoint);
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint[] newPoints1, int np1x, int np1y, int np1z, @Nullable DirectionalPathPoint[] newPoints2, int np2x, int np2y, int np2z, @Nullable DirectionalPathPoint newPointDiagonal, DirectionalPathPoint currentPoint, boolean allowObstructions, boolean fitsThroughPoles, boolean is3DPathing) {
        if (!is3DPathing) {
            if (!(newPointDiagonal == null || newPointDiagonal.f_77279_ || newPoints2 == null || newPoints2.length <= 0 || newPoints2[0] == null && (newPoints2.length <= 1 || newPoints2[1] == null) || newPoints1 == null || newPoints1.length <= 0 || newPoints1[0] == null && (newPoints1.length <= 1 || newPoints1[1] == null) || newPoints1[0] != null && newPoints1[0].f_77282_ == BlockPathTypes.WALKABLE_DOOR || newPoints2[0] != null && newPoints2[0].f_77282_ == BlockPathTypes.WALKABLE_DOOR || newPointDiagonal.f_77282_ == BlockPathTypes.WALKABLE_DOOR)) {
                boolean canPassPoleDiagonally = newPoints2[0] != null && newPoints2[0].f_77282_ == BlockPathTypes.FENCE && newPoints1[0] != null && newPoints1[0].f_77282_ == BlockPathTypes.FENCE && fitsThroughPoles;
                return (allowObstructions || newPointDiagonal.f_77281_ >= 0.0f) && (canPassPoleDiagonally || (newPoints2[0] != null && (allowObstructions || newPoints2[0].f_77281_ >= 0.0f) || newPoints2.length > 1 && newPoints2[1] != null && (allowObstructions || newPoints2[1].f_77281_ >= 0.0f)) && (newPoints1[0] != null && (allowObstructions || newPoints1[0].f_77281_ >= 0.0f) || newPoints1.length > 1 && newPoints1[1] != null && (allowObstructions || newPoints1[1].f_77281_ >= 0.0f)));
            }
        } else if (newPointDiagonal != null && !newPointDiagonal.f_77279_ && this.isTraversible(currentPoint, newPointDiagonal)) {
            long packed2 = this.getDirectionalPathNodeTypeCached(this.f_77313_, np2x, np2y, np2z);
            BlockPathTypes pathNodeType2 = AdvancedWalkNodeProcessor.unpackNodeType(packed2);
            boolean open2 = pathNodeType2 == BlockPathTypes.OPEN || pathNodeType2 == BlockPathTypes.WALKABLE;
            long packed1 = this.getDirectionalPathNodeTypeCached(this.f_77313_, np1x, np1y, np1z);
            BlockPathTypes pathNodeType1 = AdvancedWalkNodeProcessor.unpackNodeType(packed1);
            boolean open1 = pathNodeType1 == BlockPathTypes.OPEN || pathNodeType1 == BlockPathTypes.WALKABLE;
            return open1 != open2 || open1 && open2 && AdvancedWalkNodeProcessor.isSharingDirection(newPointDiagonal, currentPoint);
        }
        return false;
    }

    protected DirectionalPathPoint openPoint(int x, int y, int z, long packed, boolean isDrop) {
        int hash = Node.m_77295_((int)x, (int)y, (int)z);
        Node point = (Node)this.f_77314_.computeIfAbsent(hash, key -> new DirectionalPathPoint(x, y, z, packed, isDrop));
        if (!(point instanceof DirectionalPathPoint)) {
            point = new DirectionalPathPoint(point);
            this.f_77314_.put(hash, (Object)point);
        }
        return (DirectionalPathPoint)point;
    }

    @Nullable
    private DirectionalPathPoint[] getSafePoints(int x, int y, int z, int stepHeight, double height, Vec3i direction, boolean allowBlocked) {
        long initialPacked;
        DirectionalPathPoint directPathPoint = null;
        BlockPos pos = new BlockPos(x, y, z);
        double blockHeight = (double)y - AdvancedWalkNodeProcessor.m_77611_((BlockGetter)this.f_77312_, (BlockPos)new BlockPos(x, y, z));
        if (blockHeight - height > 1.125) {
            return new DirectionalPathPoint[0];
        }
        long packed = initialPacked = this.getDirectionalPathNodeTypeCached(this.f_77313_, x, y, z);
        BlockPathTypes nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        float malus = this.advancedPathFindingEntity.getPathingMalus((BlockGetter)this.f_77312_, this.f_77313_, nodeType, pos, direction, dir -> AdvancedWalkNodeProcessor.unpackDirection(dir, initialPacked));
        double halfWidth = (double)this.f_77313_.m_20205_() / 2.0;
        DirectionalPathPoint[] result = new DirectionalPathPoint[1];
        if (malus >= 0.0f && (allowBlocked || nodeType != BlockPathTypes.BLOCKED)) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.f_77282_ = nodeType;
            directPathPoint.f_77281_ = Math.max(directPathPoint.f_77281_, malus);
            if (directPathPoint.f_77282_ == BlockPathTypes.BLOCKED) {
                result = new DirectionalPathPoint[2];
                result[1] = directPathPoint;
                directPathPoint = null;
            }
        }
        if (nodeType == BlockPathTypes.WALKABLE) {
            result[0] = directPathPoint;
            return result;
        }
        if (directPathPoint == null && stepHeight > 0 && nodeType != BlockPathTypes.FENCE && nodeType != BlockPathTypes.UNPASSABLE_RAIL && nodeType != BlockPathTypes.TRAPDOOR && direction.m_123342_() == 0 && Math.abs(direction.m_123341_()) + Math.abs(direction.m_123342_()) + Math.abs(direction.m_123343_()) == 1) {
            double offsetZ;
            double offsetX;
            AABB enclosingAabb;
            DirectionalPathPoint[] pointsAbove = this.getSafePoints(x, y + 1, z, stepHeight - 1, height, direction, false);
            DirectionalPathPoint directionalPathPoint = directPathPoint = pointsAbove.length > 0 ? pointsAbove[0] : null;
            if (directPathPoint != null && (directPathPoint.f_77282_ == BlockPathTypes.OPEN || directPathPoint.f_77282_ == BlockPathTypes.WALKABLE) && this.f_77313_.m_20205_() < 1.0f && this.checkAabbCollision(enclosingAabb = new AABB((offsetX = (double)(x - direction.m_123341_()) + 0.5) - halfWidth, AdvancedWalkNodeProcessor.m_77611_((BlockGetter)this.f_77312_, (BlockPos)new BlockPos(offsetX, (double)(y + 1), offsetZ = (double)(z - direction.m_123342_()) + 0.5)) + 0.001, offsetZ - halfWidth, offsetX + halfWidth, (double)this.f_77313_.m_20206_() + AdvancedWalkNodeProcessor.m_77611_((BlockGetter)this.f_77312_, (BlockPos)new BlockPos(directPathPoint.f_77271_, directPathPoint.f_77272_, directPathPoint.f_77273_)) - 0.002, offsetZ + halfWidth))) {
                directPathPoint = null;
            }
        }
        if (nodeType == BlockPathTypes.OPEN) {
            float bridingMalus;
            directPathPoint = null;
            AABB checkAabb = new AABB((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.f_77313_.m_20206_()), (double)z + halfWidth + 0.5);
            if (this.checkAabbCollision(checkAabb)) {
                result[0] = null;
                return result;
            }
            if (this.f_77313_.m_20205_() >= 1.0f) {
                for (int i = 0; i < this.pathableFacingsArray.length; ++i) {
                    Direction pathableFacing = this.pathableFacingsArray[i];
                    long packedAtFacing = this.getDirectionalPathNodeTypeCached(this.f_77313_, x + pathableFacing.m_122429_() * this.pathingSizeOffsetX, y + (pathableFacing == Direction.DOWN ? -1 : (pathableFacing == Direction.UP ? this.pathingSizeOffsetY : 0)), z + pathableFacing.m_122431_() * this.pathingSizeOffsetZ);
                    BlockPathTypes nodeTypeAtFacing = AdvancedWalkNodeProcessor.unpackNodeType(packedAtFacing);
                    if (nodeTypeAtFacing != BlockPathTypes.BLOCKED) continue;
                    directPathPoint = this.openPoint(x, y, z, packedAtFacing, false);
                    directPathPoint.f_77282_ = BlockPathTypes.WALKABLE;
                    directPathPoint.f_77281_ = Math.max(directPathPoint.f_77281_, malus);
                    result[0] = directPathPoint;
                    return result;
                }
            }
            boolean cancelFallDown = false;
            DirectionalPathPoint fallPathPoint = null;
            int fallDistance = 0;
            int preFallY = y;
            while (y > this.f_77312_.m_141937_() && nodeType == BlockPathTypes.OPEN) {
                if (fallDistance++ >= Math.max(1, this.f_77313_.m_6056_()) || --y == 0) {
                    cancelFallDown = true;
                    break;
                }
                packed = this.getDirectionalPathNodeTypeCached(this.f_77313_, x, y, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.f_77313_.m_21439_(nodeType);
                if ((this.f_77313_.m_6056_() > 0 && nodeType != BlockPathTypes.OPEN || nodeType == BlockPathTypes.WATER || nodeType == BlockPathTypes.LAVA) && malus >= 0.0f) {
                    fallPathPoint = this.openPoint(x, y, z, packed, true);
                    fallPathPoint.f_77282_ = nodeType;
                    fallPathPoint.f_77281_ = Math.max(fallPathPoint.f_77281_, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                cancelFallDown = true;
            }
            boolean hasPathUp = false;
            if (this.pathableFacings.size() > 1) {
                packed = this.getDirectionalPathNodeTypeCached(this.f_77313_, x, preFallY, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.f_77313_.m_21439_(nodeType);
                if (nodeType != BlockPathTypes.OPEN && malus >= 0.0f) {
                    if (fallPathPoint != null) {
                        result = new DirectionalPathPoint[2];
                        result[1] = fallPathPoint;
                    }
                    result[0] = directPathPoint = this.openPoint(x, preFallY, z, packed, false);
                    directPathPoint.f_77282_ = nodeType;
                    directPathPoint.f_77281_ = Math.max(directPathPoint.f_77281_, malus);
                    hasPathUp = true;
                }
            }
            if (fallPathPoint != null) {
                if (!hasPathUp) {
                    result[0] = directPathPoint = fallPathPoint;
                } else {
                    result = new DirectionalPathPoint[]{directPathPoint, fallPathPoint};
                }
            }
            if (fallPathPoint != null && (bridingMalus = this.advancedPathFindingEntity.getBridgePathingMalus(this.f_77313_, new BlockPos(x, preFallY, z), fallPathPoint)) >= 0.0f) {
                result = new DirectionalPathPoint[2];
                result[0] = directPathPoint;
                DirectionalPathPoint bridgePathPoint = this.openPoint(x, preFallY, z, packed, false);
                bridgePathPoint.f_77282_ = BlockPathTypes.WALKABLE;
                bridgePathPoint.f_77281_ = Math.max(bridgePathPoint.f_77281_, bridingMalus);
                result[1] = bridgePathPoint;
            }
            if (cancelFallDown && !hasPathUp) {
                result[0] = null;
                if (result.length == 2) {
                    result[1] = null;
                }
                return result;
            }
        }
        if (nodeType == BlockPathTypes.FENCE) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.f_77279_ = true;
            directPathPoint.f_77282_ = nodeType;
            directPathPoint.f_77281_ = nodeType.m_77124_();
        }
        result[0] = directPathPoint;
        return result;
    }

    protected long getDirectionalPathNodeTypeCached(Mob entitylivingIn, int x, int y, int z) {
        return this.pathNodeTypeCache.computeIfAbsent(BlockPos.m_121882_((int)x, (int)y, (int)z), key -> this.getDirectionalPathNodeType((BlockGetter)this.f_77312_, x, y, z, entitylivingIn, this.f_77315_, this.f_77316_, this.f_77317_, this.m_77360_(), this.m_77357_()));
    }

    static long packDirection(Direction facing, long packed) {
        return packed | 1L << facing.ordinal();
    }

    static long packDirection(long packed1, long packed2) {
        return packed1 & 0xFFFFFFFF00000000L | packed1 & 0xFFFFFFFFL | packed2 & 0xFFFFFFFFL;
    }

    static boolean unpackDirection(Direction facing, long packed) {
        return (packed & 1L << facing.ordinal()) != 0L;
    }

    static boolean unpackDirection(long packed) {
        return (packed & 0xFFFFFFFFL) != 0L;
    }

    static long packNodeType(BlockPathTypes type, long packed) {
        return (long)type.ordinal() << 32 | packed & 0xFFFFFFFFL;
    }

    static BlockPathTypes unpackNodeType(long packed) {
        return PATH_NODE_TYPES[(int)(packed >> 32)];
    }

    public BlockPathTypes m_7209_(BlockGetter blockaccessIn, int x, int y, int z, Mob entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        return AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeType(blockaccessIn, x, y, z, entity, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn));
    }

    protected long getDirectionalPathNodeType(BlockGetter blockaccessIn, int x, int y, int z, Mob entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        BlockPos pos = new BlockPos(entity.m_20182_());
        EnumSet<BlockPathTypes> applicablePathNodeTypes = EnumSet.noneOf(BlockPathTypes.class);
        long centerPacked = this.getDirectionalPathNodeType(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, applicablePathNodeTypes, BlockPathTypes.BLOCKED, pos);
        BlockPathTypes centerPathNodeType = AdvancedWalkNodeProcessor.unpackNodeType(centerPacked);
        if (applicablePathNodeTypes.contains(BlockPathTypes.FENCE)) {
            return AdvancedWalkNodeProcessor.packNodeType(BlockPathTypes.FENCE, centerPacked);
        }
        if (applicablePathNodeTypes.contains(BlockPathTypes.UNPASSABLE_RAIL)) {
            return AdvancedWalkNodeProcessor.packNodeType(BlockPathTypes.UNPASSABLE_RAIL, centerPacked);
        }
        BlockPathTypes selectedPathNodeType = BlockPathTypes.BLOCKED;
        for (BlockPathTypes applicablePathNodeType : applicablePathNodeTypes) {
            float p2;
            if (entity.m_21439_(applicablePathNodeType) < 0.0f) {
                return AdvancedWalkNodeProcessor.packNodeType(applicablePathNodeType, centerPacked);
            }
            float p1 = entity.m_21439_(applicablePathNodeType);
            if (!(p1 > (p2 = entity.m_21439_(selectedPathNodeType))) && (p1 != p2 || selectedPathNodeType == BlockPathTypes.WALKABLE && applicablePathNodeType == BlockPathTypes.OPEN) && (p1 != p2 || selectedPathNodeType != BlockPathTypes.OPEN || applicablePathNodeType != BlockPathTypes.WALKABLE)) continue;
            selectedPathNodeType = applicablePathNodeType;
        }
        if (centerPathNodeType == BlockPathTypes.OPEN && entity.m_21439_(selectedPathNodeType) == 0.0f) {
            return AdvancedWalkNodeProcessor.packNodeType(BlockPathTypes.OPEN, 0L);
        }
        return AdvancedWalkNodeProcessor.packNodeType(selectedPathNodeType, centerPacked);
    }

    protected long getDirectionalPathNodeType(BlockGetter blockaccessIn, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<BlockPathTypes> nodeTypeEnum, BlockPathTypes nodeType, BlockPos pos) {
        long packed = 0L;
        for (int ox = 0; ox < xSize; ++ox) {
            for (int oy = 0; oy < ySize; ++oy) {
                for (int oz = 0; oz < zSize; ++oz) {
                    int bx = ox + x;
                    int by = oy + y;
                    int bz = oz + z;
                    long packedAdjusted = this.getDirectionalPathNodeType(blockaccessIn, bx, by, bz);
                    BlockPathTypes adjustedNodeType = AdvancedWalkNodeProcessor.unpackNodeType(packedAdjusted);
                    adjustedNodeType = this.m_6603_(blockaccessIn, canOpenDoorsIn, canEnterDoorsIn, pos, adjustedNodeType);
                    if (ox == 0 && oy == 0 && oz == 0) {
                        packed = AdvancedWalkNodeProcessor.packNodeType(adjustedNodeType, packedAdjusted);
                    }
                    nodeTypeEnum.add(adjustedNodeType);
                }
            }
        }
        return packed;
    }

    public BlockPathTypes m_8086_(BlockGetter blockaccessIn, int x, int y, int z) {
        return AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeType(blockaccessIn, x, y, z));
    }

    protected long getDirectionalPathNodeType(BlockGetter blockaccessIn, int x, int y, int z) {
        return AdvancedWalkNodeProcessor.getDirectionalPathNodeType(this.rawPathNodeTypeCache, blockaccessIn, x, y, z, this.pathingSizeOffsetX, this.pathingSizeOffsetY, this.pathingSizeOffsetZ, this.pathableFacingsArray);
    }

    protected static BlockPathTypes getRawPathNodeTypeCached(Long2ObjectMap<BlockPathTypes> cache, BlockGetter blockaccessIn, BlockPos.MutableBlockPos pos) {
        return (BlockPathTypes)cache.computeIfAbsent(BlockPos.m_121882_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_()), key -> AdvancedWalkNodeProcessor.m_77643_((BlockGetter)blockaccessIn, (BlockPos)pos));
    }

    protected static long getDirectionalPathNodeType(Long2ObjectMap<BlockPathTypes> rawPathNodeTypeCache, BlockGetter blockaccessIn, int x, int y, int z, int pathingSizeOffsetX, int pathingSizeOffsetY, int pathingSizeOffsetZ, Direction[] pathableFacings) {
        long packed = 0L;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPathTypes nodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos.m_122178_(x, y, z));
        boolean isWalkable = false;
        if (nodeType == BlockPathTypes.OPEN && y >= blockaccessIn.m_141937_() + 1) {
            for (int i = 0; i < pathableFacings.length; ++i) {
                Direction pathableFacing = pathableFacings[i];
                int checkHeight = pathableFacing.m_122434_() != Direction.Axis.Y ? Math.min(4, pathingSizeOffsetY - 1) : 0;
                int cx = x + pathableFacing.m_122429_() * pathingSizeOffsetX;
                int cy = y + (pathableFacing == Direction.DOWN ? -1 : (pathableFacing == Direction.UP ? pathingSizeOffsetY : 0));
                int cz = z + pathableFacing.m_122431_() * pathingSizeOffsetZ;
                for (int yo = 0; yo <= checkHeight; ++yo) {
                    pos.m_122178_(cx, cy + yo, cz);
                    BlockPathTypes offsetNodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos);
                    BlockPathTypes blockPathTypes = nodeType = offsetNodeType != BlockPathTypes.WALKABLE && offsetNodeType != BlockPathTypes.OPEN && offsetNodeType != BlockPathTypes.WATER && offsetNodeType != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
                    if (offsetNodeType == BlockPathTypes.DAMAGE_FIRE) {
                        nodeType = BlockPathTypes.DAMAGE_FIRE;
                    }
                    if (offsetNodeType == BlockPathTypes.DAMAGE_CACTUS) {
                        nodeType = BlockPathTypes.DAMAGE_CACTUS;
                    }
                    if (offsetNodeType == BlockPathTypes.DAMAGE_OTHER) {
                        nodeType = BlockPathTypes.DAMAGE_OTHER;
                    }
                    if (offsetNodeType == BlockPathTypes.STICKY_HONEY) {
                        nodeType = BlockPathTypes.STICKY_HONEY;
                    }
                    if (nodeType != BlockPathTypes.WALKABLE) continue;
                    if (AdvancedWalkNodeProcessor.isColliderNodeType(offsetNodeType)) {
                        packed = AdvancedWalkNodeProcessor.packDirection(pathableFacing, packed);
                    }
                    isWalkable = true;
                }
            }
        }
        if (isWalkable) {
            nodeType = AdvancedWalkNodeProcessor.m_77607_((BlockGetter)blockaccessIn, (BlockPos.MutableBlockPos)pos.m_122178_(x, y, z), (BlockPathTypes)BlockPathTypes.WALKABLE);
        }
        return AdvancedWalkNodeProcessor.packNodeType(nodeType, packed);
    }

    protected static boolean isColliderNodeType(BlockPathTypes type) {
        return type == BlockPathTypes.BLOCKED || type == BlockPathTypes.TRAPDOOR || type == BlockPathTypes.FENCE || type == BlockPathTypes.DOOR_WOOD_CLOSED || type == BlockPathTypes.DOOR_IRON_CLOSED || type == BlockPathTypes.LEAVES || type == BlockPathTypes.STICKY_HONEY || type == BlockPathTypes.COCOA;
    }
}

