/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.EntityBackpackAdditionHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.AnotherPlayerBackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class CommonEventHandler {
    private static final int BACKPACK_CHECK_COOLDOWN = 40;
    private final Map<ResourceLocation, Long> nextBackpackCheckTime = new HashMap<ResourceLocation, Long>();

    public void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.registerHandlers(modBus);
        ModBlocks.registerHandlers(modBus);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onItemPickup);
        eventBus.addListener(this::onLivingSpecialSpawn);
        eventBus.addListener(this::onLivingDrops);
        eventBus.addListener(this::onEntityMobGriefing);
        eventBus.addListener(this::onEntityLeaveWorld);
        eventBus.addListener(ServerStorageSoundHandler::tick);
        eventBus.addListener(this::onBlockClick);
        eventBus.addListener(this::onAttackEntity);
        eventBus.addListener(EntityBackpackAdditionHandler::onLivingUpdate);
        eventBus.addListener(this::onPlayerLoggedIn);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onPlayerRespawn);
        eventBus.addListener(this::onWorldTick);
        eventBus.addListener(this::interactWithEntity);
    }

    private void interactWithEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        boolean isPointingAtBack;
        Player targetPlayer;
        block6: {
            block5: {
                Entity entity = event.getTarget();
                if (!(entity instanceof Player)) break block5;
                targetPlayer = (Player)entity;
                if (!Boolean.FALSE.equals(Config.SERVER.allowOpeningOtherPlayerBackpacks.get())) break block6;
            }
            return;
        }
        Player sourcePlayer = event.getEntity();
        Vec3 targetPlayerViewVector = Vec3.m_82503_((Vec2)new Vec2(targetPlayer.m_146909_(), targetPlayer.f_20883_));
        Vec3 hitVector = event.getLocalPos();
        Vec3 vec31 = sourcePlayer.m_20182_().m_82505_(targetPlayer.m_20182_()).m_82541_();
        vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
        boolean isPointingAtBody = hitVector.f_82480_ >= 0.9 && hitVector.f_82480_ < 1.6;
        boolean bl = isPointingAtBack = vec31.m_82526_(targetPlayerViewVector) > 0.0;
        if (!isPointingAtBody || !isPointingAtBack) {
            return;
        }
        if (targetPlayer.f_19853_.f_46443_) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            SBPPacketHandler.INSTANCE.sendToServer(new AnotherPlayerBackpackOpenMessage(targetPlayer.m_19879_()));
        }
    }

    private void onWorldTick(TickEvent.LevelTickEvent event) {
        ResourceLocation dimensionKey = event.level.m_46472_().m_135782_();
        boolean runSlownessLogic = Boolean.TRUE.equals(Config.SERVER.nerfsConfig.tooManyBackpacksSlowness.get());
        boolean runDedupeLogic = Boolean.FALSE.equals(Config.SERVER.tickDedupeLogicDisabled.get());
        if (event.phase != TickEvent.Phase.END || !runSlownessLogic && !runDedupeLogic || this.nextBackpackCheckTime.getOrDefault(dimensionKey, 0L) > event.level.m_46467_()) {
            return;
        }
        this.nextBackpackCheckTime.put(dimensionKey, event.level.m_46467_() + 40L);
        HashSet backpackIds = new HashSet();
        event.level.m_6907_().forEach(player -> {
            AtomicInteger numberOfBackpacks = new AtomicInteger(0);
            PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, handlerName, identifier, slot) -> {
                if (runSlownessLogic) {
                    numberOfBackpacks.incrementAndGet();
                }
                if (runDedupeLogic) {
                    backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> CommonEventHandler.addBackpackIdIfUniqueOrDedupe(backpackIds, backpackWrapper));
                }
                return false;
            });
            if (runSlownessLogic) {
                int maxNumberOfBackpacks = (Integer)Config.SERVER.nerfsConfig.maxNumberOfBackpacks.get();
                if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                    int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)Config.SERVER.nerfsConfig.slownessLevelsPerAdditionalBackpack.get()));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, numberOfSlownessLevels - 1, false, false));
                }
            }
        });
    }

    private static void addBackpackIdIfUniqueOrDedupe(Set<UUID> backpackIds, IBackpackWrapper backpackWrapper) {
        backpackWrapper.getContentsUuid().ifPresent(backpackId -> {
            if (backpackIds.contains(backpackId)) {
                backpackWrapper.removeContentsUUIDTag();
                backpackWrapper.onContentsNbtUpdated();
            } else {
                backpackIds.add((UUID)backpackId);
            }
        });
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        this.sendPlayerSettingsToClient(player);
    }

    private void sendPlayerSettingsToClient(Player player) {
        String playerTagName = "sophisticatedBackpackSettings";
        PacketHandler.INSTANCE.sendToClient((ServerPlayer)player, (Object)new SyncPlayerSettingsMessage(playerTagName, SettingsManager.getPlayerSettingsTag((Player)player, (String)playerTagName)));
    }

    private void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IBlockClickResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IBlockClickResponseUpgrade.class)) {
                if (!upgrade.onBlockClick(player, pos)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.f_19853_.f_46443_) {
            return;
        }
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IAttackEntityResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IAttackEntityResponseUpgrade.class)) {
                if (!upgrade.onAttackEntity(player)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Monster monster;
        Mob entity = event.getEntity();
        if (entity instanceof Monster && (monster = (Monster)entity).m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            EntityBackpackAdditionHandler.addBackpack(monster);
        }
    }

    private void onLivingDrops(LivingDropsEvent event) {
        EntityBackpackAdditionHandler.handleBackpackDrop(event);
    }

    private void onEntityMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            EntityBackpackAdditionHandler.removeBeneficialEffects(creeper);
        }
    }

    private void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        EntityBackpackAdditionHandler.removeBackpackUuid((Monster)event.getEntity());
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        ItemEntity itemEntity = event.getItem();
        if (itemEntity.m_32055_().m_41619_()) {
            return;
        }
        AtomicReference<ItemStack> remainingStackSimulated = new AtomicReference<ItemStack>(itemEntity.m_32055_().m_41777_());
        Player player = event.getEntity();
        Level world = player.m_20193_();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            remainingStackSimulated.set(InventoryHelper.runPickupOnPickupResponseUpgrades((Level)world, (UpgradeHandler)wrapper.getUpgradeHandler(), (ItemStack)((ItemStack)remainingStackSimulated.get()), (boolean)true));
            return ((ItemStack)remainingStackSimulated.get()).m_41619_();
        }).orElse(false), (Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get());
        if (remainingStackSimulated.get().m_41613_() != itemEntity.m_32055_().m_41613_()) {
            AtomicReference<ItemStack> remainingStack = new AtomicReference<ItemStack>(itemEntity.m_32055_().m_41777_());
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
                remainingStack.set(InventoryHelper.runPickupOnPickupResponseUpgrades((Level)world, (Player)player, (UpgradeHandler)wrapper.getUpgradeHandler(), (ItemStack)((ItemStack)remainingStack.get()), (boolean)false));
                return ((ItemStack)remainingStack.get()).m_41619_();
            }).orElse(false), (Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get());
            itemEntity.m_32045_(remainingStack.get());
            event.setCanceled(true);
        }
    }
}

