/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.entities;

import com.ibarnstormer.gbd.registry.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class TurretBeamLaserEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_TICK = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> CHARGE_SPEED = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_CACHED_TARGET_ID = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID targetUUID;
    @Nullable
    private Entity cachedTarget;
    private int clientSideAttackTime;
    private int beamTick;

    public TurretBeamLaserEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public TurretBeamLaserEntity(Level level, LivingEntity target, float chargeSpeed) {
        super((EntityType)ModEntities.TURRET_BEAM_LASER_ENTITY.get(), level);
        this.f_19804_.m_135381_(DATA_CACHED_TARGET_ID, (Object)target.m_19879_());
        this.f_19804_.m_135381_(CHARGE_SPEED, (Object)Float.valueOf(chargeSpeed));
        this.cachedTarget = target;
        this.targetUUID = target.m_20148_();
        this.beamTick = 0;
    }

    public void m_8119_() {
        Entity target;
        super.m_8119_();
        this.f_19811_ = true;
        if ((float)((Integer)this.f_19804_.m_135370_(DATA_TICK)).intValue() < this.getChargeSpeed() + 5.0f) {
            this.f_19804_.m_135381_(DATA_TICK, (Object)((Integer)this.f_19804_.m_135370_(DATA_TICK) + 1));
        }
        ++this.beamTick;
        if (this.f_19853_.f_46443_ && (float)this.clientSideAttackTime < this.getChargeSpeed() + 1.0f) {
            ++this.clientSideAttackTime;
        }
        if ((target = this.getTarget()) != null) {
            if (target.f_19853_ == this.f_19853_) {
                Vec3 vec32;
                Vec3 vec3 = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_());
                Vec3 vec31 = this.m_20182_();
                Vec3 vec33 = vec31.m_82546_((vec32 = vec31.m_82546_(vec3)).m_82541_().m_82490_(1.125));
                BlockHitResult cast = this.f_19853_.m_45547_(new ClipContext(vec33, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (cast.m_6662_() == HitResult.Type.BLOCK) {
                    this.m_146870_();
                }
                if (this.m_20280_(target) > 1000.0) {
                    this.m_146870_();
                }
            } else {
                this.m_146870_();
            }
        }
        if (target == null && (float)((Integer)this.f_19804_.m_135370_(DATA_TICK)).intValue() >= this.getChargeSpeed() + 5.0f) {
            this.m_146870_();
        }
    }

    @Nullable
    public Entity getCachedTarget() {
        if (this.f_19853_.f_46443_) {
            Entity target = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(DATA_CACHED_TARGET_ID)).intValue());
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                return livingTarget;
            }
            return null;
        }
        return this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(DATA_CACHED_TARGET_ID)).intValue());
    }

    @Nullable
    public Entity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && this.f_19853_ instanceof ServerLevel) {
            this.cachedTarget = ((ServerLevel)this.f_19853_).m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TICK, (Object)0);
        this.f_19804_.m_135372_(CHARGE_SPEED, (Object)Float.valueOf(120.0f));
        this.f_19804_.m_135372_(DATA_CACHED_TARGET_ID, (Object)0);
    }

    public float getAttackAnimationScale(float p_32813_) {
        return ((float)this.clientSideAttackTime + p_32813_) / this.getChargeSpeed();
    }

    public int getClientSideAttackTime() {
        return this.clientSideAttackTime;
    }

    public float getChargeSpeed() {
        return ((Float)this.f_19804_.m_135370_(CHARGE_SPEED)).floatValue();
    }

    public int getTick() {
        return (Integer)this.f_19804_.m_135370_(DATA_TICK);
    }

    public int getBeamTick() {
        return this.beamTick;
    }

    protected void m_7378_(CompoundTag p_20052_) {
        if (p_20052_.m_128403_("Target")) {
            this.targetUUID = p_20052_.m_128342_("Target");
        }
    }

    protected void m_7380_(CompoundTag p_20139_) {
        if (this.targetUUID != null) {
            p_20139_.m_128362_("Owner", this.targetUUID);
        }
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

