/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.event;

import com.ibarnstormer.gbd.capability.BeamReactorCapability;
import com.ibarnstormer.gbd.capability.ModCapabilityProvider;
import com.ibarnstormer.gbd.entities.BeamReactorLaserEntity;
import com.ibarnstormer.gbd.items.BeamReactorHelmet;
import com.ibarnstormer.gbd.network.BeamReactorRayTracePacket;
import com.ibarnstormer.gbd.network.BroadcastBeamReactorSoundPacket;
import com.ibarnstormer.gbd.network.UpdatePlayerCapabilitiesPacket;
import com.ibarnstormer.gbd.registry.ModNetwork;
import com.ibarnstormer.gbd.utils.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="creategbd")
public class ModEvents {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation("creategbd", "persistent_player_data"), (ICapabilityProvider)new ModCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        player.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> {
            BeamReactorLaserEntity beam;
            cap.setToggleability(player.m_150109_().m_36052_(3).m_41720_() instanceof BeamReactorHelmet);
            if (cap.isActive() && cap.canToggle()) {
                if (cap.prevPos() == Vec3.f_82478_) {
                    cap.setPrevPos(player.m_20182_());
                }
                if (event.side.isClient()) {
                    HitResult ray = Utils.rayCast((Entity)player, Minecraft.m_91087_());
                    ModNetwork.sendPacketToServer(new BeamReactorRayTracePacket(ray.m_82450_()));
                }
            } else if (!cap.isActive() && cap.canToggle() && !player.f_19853_.f_46443_) {
                beam = cap.getBeam();
                if (beam != null) {
                    beam.m_146870_();
                }
                cap.setBeam(null);
            }
            if (cap.isActive() && !cap.canToggle() && !player.f_19853_.f_46443_ && cap.getBeam() != null) {
                beam = cap.getBeam();
                beam.m_146870_();
                cap.setBeam(null);
            }
        });
    }

    public static void handleBeam(Player player, Vec3 ray) {
        player.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> {
            if (!player.f_19853_.f_46443_) {
                if (cap.getBeam() == null && player.m_20182_().m_82546_(cap.prevPos()).m_82553_() == 0.0) {
                    BeamReactorLaserEntity beam = new BeamReactorLaserEntity(player.f_19853_, (Entity)player);
                    beam.m_146884_(player.m_20182_());
                    beam.m_20329_((Entity)player);
                    cap.setBeam(beam);
                    player.f_19853_.m_7967_((Entity)beam);
                } else {
                    BeamReactorLaserEntity beam = cap.getBeam();
                    if (beam != null) {
                        if (beam.getTick() >= 40) {
                            Vec3 vec3d = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20206_(), player.m_20189_());
                            HashSet<LivingEntity> damagedEntities = new HashSet<LivingEntity>();
                            AABB box = new AABB(Math.min(player.m_20185_(), ray.f_82479_), Math.min(player.m_20186_() + (double)player.m_20206_(), ray.f_82480_), Math.min(player.m_20189_(), ray.f_82481_), Math.max(player.m_20185_(), ray.f_82479_), Math.max(player.m_20186_() + (double)player.m_20206_(), ray.f_82480_), Math.max(player.m_20189_(), ray.f_82481_)).m_82377_(1.0, 1.0, 1.0);
                            List list = player.f_19853_.m_45976_(LivingEntity.class, box);
                            for (LivingEntity entity : list) {
                                if (entity == player || damagedEntities.contains(entity) || entity.m_20197_().contains(player)) continue;
                                float f = entity.m_6143_() + 0.4f;
                                AABB box1 = entity.m_20191_().m_82377_((double)f, (double)f, (double)f);
                                Optional hit = box1.m_82371_(vec3d, ray);
                                if (!box1.m_82390_(vec3d) && !hit.isPresent()) continue;
                                entity.m_6469_(DamageSource.m_19367_((Entity)player, (Entity)player), 6.0f);
                                damagedEntities.add(entity);
                            }
                            damagedEntities.clear();
                            if (player.f_19797_ % 20 == 0) {
                                ItemStack reactorStack = player.m_150109_().m_36052_(3);
                                reactorStack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)3)));
                            }
                        }
                        if (player.f_19797_ % 10 == 0) {
                            ModNetwork.sendToNearbyPlayers((ServerPlayer)player, new BroadcastBeamReactorSoundPacket(player.m_19879_(), beam.m_19879_()), 32.0, false);
                        }
                    }
                }
                cap.setPrevPos(player.m_20182_());
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getEntity().getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(newPlayer -> event.getOriginal().getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(oldPlayer -> {
            newPlayer.copyFrom((BeamReactorCapability)oldPlayer);
            ModNetwork.sendToPlayer((ServerPlayer)event.getEntity(), new UpdatePlayerCapabilitiesPacket(newPlayer.isActive(), newPlayer.canToggle()));
        }));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.StartTracking event) {
        ModEvents.syncPlayerData(event.getEntity(), false);
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ModEvents.syncPlayerData(event.getEntity(), true);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ModEvents.syncPlayerData(event.getEntity(), true);
    }

    public static void syncPlayerData(Player player, boolean deactivate) {
        player.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> {
            BeamReactorLaserEntity beam;
            cap.setActive(!deactivate && cap.isActive());
            cap.setToggleability(cap.canToggle());
            if (deactivate && (beam = cap.getBeam()) != null) {
                beam.m_146870_();
                cap.setBeam(null);
            }
            ModNetwork.sendToPlayer((ServerPlayer)player, new UpdatePlayerCapabilitiesPacket(cap.isActive(), cap.canToggle()));
        });
    }

    @SubscribeEvent
    public static void onRegisterCapability(RegisterCapabilitiesEvent event) {
        event.register(BeamReactorCapability.class);
    }
}

