/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Config;
import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.base.data.CRTagGen;
import com.railwayteam.railways.base.data.lang.CRLangPartials;
import com.railwayteam.railways.base.data.recipe.RailwaysSequencedAssemblyRecipeGen;
import com.railwayteam.railways.base.data.recipe.RailwaysStandardRecipeGen;
import com.railwayteam.railways.forge.RailwaysImpl;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRCommands;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.track_api.TrackMaterial;
import com.railwayteam.railways.util.RegistrationListening;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.LangMerger;
import com.simibubi.create.foundation.data.LangPartial;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class Railways {
    public static final String MODID = "railways";
    public static final Logger LOGGER = LogManager.getLogger((String)"railways");
    public static final String VERSION = Railways.findVersion();
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"railways").creativeModeTab(() -> CRItems.itemGroup, "Create Railways");

    public static void init() {
        ModSetup.register();
        Railways.finalizeRegistrate();
        Railways.registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        Railways.registerConfig(ModConfig.Type.SERVER, Config.SERVER_CONFIG);
        Path configDir = Utils.configDir();
        Config.loadConfig(Config.CLIENT_CONFIG, configDir.resolve("railways-client.toml"));
        Config.loadConfig(Config.SERVER_CONFIG, configDir.resolve("railways-common.toml"));
        Railways.registerCommands(CRCommands::register);
        CRPackets.PACKETS.registerC2SListener();
        RegistrationListening.whenBothRegistered(Registry.f_122830_, new ResourceLocation("create", "track"), Registry.f_122824_, CRBlocks.MONORAIL_TRACK.getId(), (type, block) -> TrackMaterial.addCustomValidTracks(type));
        if (Utils.isDevEnv()) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
    }

    public static ResourceLocation asResource(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static void gatherData(DataGenerator gen) {
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, CRTagGen::generateBlockTags);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, CRTagGen::generateItemTags);
        gen.m_236039_(true, (DataProvider)RailwaysSequencedAssemblyRecipeGen.create(gen));
        gen.m_236039_(true, (DataProvider)RailwaysStandardRecipeGen.create(gen));
        PonderLocalization.provideRegistrateLang((AbstractRegistrate)REGISTRATE);
        gen.m_236039_(true, (DataProvider)new LangMerger(gen, MODID, "Steam 'n Rails", (LangPartial[])CRLangPartials.values()));
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String findVersion() {
        return RailwaysImpl.findVersion();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void finalizeRegistrate() {
        RailwaysImpl.finalizeRegistrate();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerCommands(BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean> consumer) {
        RailwaysImpl.registerCommands(consumer);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerConfig(ModConfig.Type type, ForgeConfigSpec spec) {
        void var1_1;
        RailwaysImpl.registerConfig(type, (ForgeConfigSpec)var1_1);
    }
}

