/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.journeymap;

import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.Train;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record TrainMarkerData(String name, int carriageCount, UUID owner, String destination, ResourceKey<Level> dimension, BlockPos pos, boolean incomplete) {
    public static final BlockPos ABSENT_POS = new BlockPos(1331, 0, 1331);

    public static TrainMarkerData make(Train train) {
        String name = train.name.getString();
        int carriageCount = train.carriages.size();
        UUID owner = train.owner;
        String destination = Optional.ofNullable(train.navigation.destination).map(s -> s.name).orElse("Unknown/Not Present");
        Carriage primary = (Carriage)train.carriages.get(0);
        CarriageBogey bogey = primary.leadingBogey();
        ResourceKey dimension = Level.f_46430_;
        BlockPos pos = ABSENT_POS;
        if (bogey.leading().node1 != null && bogey.leading().node2 != null) {
            dimension = bogey.leading().node1.getLocation().dimension;
            Vec3 vecPos = bogey.leading().getPosition();
            pos = new BlockPos(vecPos);
            if (pos.equals((Object)ABSENT_POS)) {
                pos = ABSENT_POS.m_7494_();
            }
        }
        return new TrainMarkerData(name, carriageCount, owner, destination, (ResourceKey<Level>)dimension, pos, pos == ABSENT_POS);
    }
}

