/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.content.conductor.toolbox.forge.MountedToolboxDisposeAllPacketImpl;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MountedToolboxDisposeAllPacket
implements C2SPacket {
    private final int toolboxCarrierId;

    public MountedToolboxDisposeAllPacket(ConductorEntity toolboxCarrier) {
        this.toolboxCarrierId = toolboxCarrier.m_19879_();
    }

    public MountedToolboxDisposeAllPacket(FriendlyByteBuf buffer) {
        this.toolboxCarrierId = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.toolboxCarrierId);
    }

    @Override
    public void handle(ServerPlayer player) {
        Level world = player.f_19853_;
        Entity entity = world.m_6815_(this.toolboxCarrierId);
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductorEntity = (ConductorEntity)entity;
            double maxRange = ToolboxHandler.getMaxRange((Player)player);
            if (player.m_20280_((Entity)conductorEntity) > maxRange * maxRange) {
                return;
            }
            MountedToolbox toolbox = conductorEntity.getToolbox();
            if (toolbox == null) {
                return;
            }
            boolean sendData = MountedToolboxDisposeAllPacket.doDisposal(toolbox, player, conductorEntity);
            if (sendData) {
                ToolboxHandler.syncData((Player)player);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean doDisposal(MountedToolbox toolbox, ServerPlayer player, ConductorEntity conductor) {
        void var2_2;
        void var1_1;
        return MountedToolboxDisposeAllPacketImpl.doDisposal(toolbox, (ServerPlayer)var1_1, (ConductorEntity)var2_2);
    }
}

