/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.casing.RuntimeFakePartialModel;
import com.railwayteam.railways.content.custom_tracks.casing.SpriteCopyingBakedModel;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class CasingRenderUtils {
    private static final HashMap<Pair<PartialModel, SlabBlock>, PartialModel> reTexturedModels = new HashMap();

    public static void clearModelCache() {
        reTexturedModels.clear();
    }

    public static PartialModel reTexture(PartialModel model, SlabBlock block) {
        Pair key = Pair.of((Object)model, (Object)block);
        if (!reTexturedModels.containsKey(key)) {
            BakedModel slabModel = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(block.m_49966_());
            SpriteCopyingBakedModel texturedCasing = new SpriteCopyingBakedModel(model.get(), slabModel);
            RuntimeFakePartialModel texturedPartial = RuntimeFakePartialModel.make(Railways.asResource("runtime_casing"), texturedCasing);
            reTexturedModels.put((Pair<PartialModel, SlabBlock>)key, texturedPartial);
            return texturedPartial;
        }
        return reTexturedModels.get(key);
    }

    public static void renderBezierCasings(PoseStack ms, Level level, PartialModel texturedPartial, BlockState state, VertexConsumer vb, BezierConnection bc) {
        double shiftDown;
        int heightDiff = Math.abs(((BlockPos)bc.tePositions.get(false)).m_123342_() - ((BlockPos)bc.tePositions.get(true)).m_123342_());
        double d = shiftDown = ((IHasTrackCasing)bc).isAlternate() && heightDiff > 0 ? -0.25 : 0.0;
        if ((double)heightDiff / bc.getLength() <= 0.13333333333333333) {
            for (Vec3 pos : CasingRenderUtils.casingPositions(bc)) {
                ms.m_85836_();
                BlockPos tePosition = (BlockPos)bc.tePositions.getFirst();
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)new BlockPos(pos).m_121955_((Vec3i)tePosition));
                ((SuperByteBuffer)CachedBufferer.partial((PartialModel)texturedPartial, (BlockState)state).translate(pos.f_82479_, pos.f_82480_, pos.f_82481_).translate(0.0, shiftDown, 0.0).scale(1.001f)).light(light).renderInto(ms, vb);
                ms.m_85849_();
            }
        } else {
            ms.m_85836_();
            BlockPos tePosition = (BlockPos)bc.tePositions.getFirst();
            BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
            TransformStack.cast((PoseStack)ms).nudge((int)tePosition.m_121878_());
            for (int i = 1; i < segments.length; ++i) {
                if (i % 2 == 0) continue;
                BezierConnection.SegmentAngles segment = segments[i];
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)segment.lightPosition.m_121955_((Vec3i)tePosition));
                Matrix4f pose = segment.tieTransform.m_85861_().m_27658_();
                pose.m_27648_(new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                ((SuperByteBuffer)CachedBufferer.partial((PartialModel)texturedPartial, (BlockState)state).mulPose(pose).mulNormal(segment.tieTransform.m_85864_()).translate(0.0, shiftDown, 0.0).scale(1.02f)).light(light).renderInto(ms, vb);
                for (boolean first : Iterate.trueAndFalse) {
                    PoseStack.Pose transform = (PoseStack.Pose)segment.railTransforms.get(first);
                    Matrix4f pose2 = transform.m_85861_().m_27658_();
                    pose2.m_27648_(new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                    CachedBufferer.partial((PartialModel)texturedPartial, (BlockState)state).mulPose(pose2).mulNormal(transform.m_85864_()).translate(-0.5, shiftDown, 0.0).light(light).renderInto(ms, vb);
                }
            }
            ms.m_85849_();
        }
    }

    public static List<Vec3> casingPositions(BezierConnection bc) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        ArrayList<int[]> takenPositions = new ArrayList<int[]>();
        for (BezierConnection.Segment segment : bc) {
            Vec3 pos1 = segment.position.m_82549_(segment.normal.m_82490_(1.3));
            Vec3 pos2 = segment.position.m_82549_(segment.normal.m_82490_(-1.3));
            float steps = 4.0f;
            Vec3 stepVec = pos1.m_82505_(pos2).m_82490_((double)(1.0f / steps));
            Vec3 curPos = pos1;
            int i = 0;
            while ((float)i <= steps) {
                int x = (int)Math.floor(curPos.f_82479_);
                int z = (int)Math.floor(curPos.f_82481_);
                if (takenPositions.stream().noneMatch(pos -> pos[0] == x && pos[1] == z)) {
                    takenPositions.add(new int[]{x, z});
                    positions.add(new Vec3((double)x, curPos.f_82480_ - 0.1875, (double)z));
                }
                curPos = curPos.m_82549_(stepVec);
                ++i;
            }
        }
        return positions.stream().toList();
    }

    public static ModelData makeCasingInstance(PartialModel baseModel, SlabBlock slabBlock, Material<ModelData> mat) {
        PartialModel texturedPartial = CasingRenderUtils.reTexture(baseModel, slabBlock);
        return (ModelData)mat.getModel(texturedPartial, slabBlock.m_49966_()).createInstance();
    }
}

