/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.semaphore;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.content.semaphore.SemaphoreBlockEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeBlock;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SemaphoreRenderer
extends SafeTileEntityRenderer<SemaphoreBlockEntity> {
    public SemaphoreRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(SemaphoreBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.m_85836_();
        BlockState blockState = te.m_58900_();
        float yRot = AngleHelper.horizontalAngle((Direction)((Direction)blockState.m_61143_((Property)NixieTubeBlock.f_54117_))) + 180.0f;
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        ((TransformStack)((TransformStack)msr.centre()).rotateY((double)yRot)).unCentre();
        boolean yellow = te.isDistantSignal;
        float pos = te.armPosition.getValue(partialTicks);
        float target = te.armPosition.getChaseTarget();
        pos = (2.0f * pos - 1.0f) * (target - 0.5f) + 0.5f;
        float fallTime = 0.3f;
        if (pos < fallTime) {
            pos = 1.0f - pos * pos / (fallTime * fallTime);
        } else {
            pos = (pos - fallTime) / (1.0f - fallTime);
            float bounce = (float)(Math.exp((double)(-pos) * 4.0) * Math.sin((double)pos * Math.PI * 3.0));
            float smoothing = 0.1f;
            bounce = (float)Math.sqrt(bounce * bounce + smoothing * smoothing) - smoothing;
            pos = bounce / 3.0f;
        }
        pos = -(2.0f * pos - 1.0f) * (target - 0.5f) + 0.5f;
        float angle = pos * 0.78f;
        boolean top = (double)pos < 0.2;
        boolean bottom = (double)pos > 0.8;
        boolean flipped = (Boolean)blockState.m_61143_((Property)SemaphoreBlock.FLIPPED);
        boolean upside_down = (Boolean)blockState.m_61143_((Property)SemaphoreBlock.UPSIDE_DOWN);
        PartialModel arm = upside_down ? (flipped ? (yellow ? CRBlockPartials.SEMAPHORE_ARM_YELLOW_FLIPPED_UPSIDE_DOWN : CRBlockPartials.SEMAPHORE_ARM_RED_FLIPPED_UPSIDE_DOWN) : (yellow ? CRBlockPartials.SEMAPHORE_ARM_YELLOW_UPSIDE_DOWN : CRBlockPartials.SEMAPHORE_ARM_RED_UPSIDE_DOWN)) : (flipped ? (yellow ? CRBlockPartials.SEMAPHORE_ARM_YELLOW_FLIPPED : CRBlockPartials.SEMAPHORE_ARM_RED_FLIPPED) : (yellow ? CRBlockPartials.SEMAPHORE_ARM_YELLOW : CRBlockPartials.SEMAPHORE_ARM_RED));
        CachedBufferer.partial((PartialModel)arm, (BlockState)blockState).light(light).rotateCentered(Direction.EAST, angle * (float)(upside_down ? -1 : 1)).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        float renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        boolean bl = top = top && (renderTime % 40.0f < 3.0f || te.isValid);
        if (top || bottom) {
            ms.m_85836_();
            if (upside_down) {
                if (bottom) {
                    ms.m_85837_(0.5, 0.5625, 0.9375);
                } else {
                    ms.m_85837_(0.5, 0.25, 0.875);
                }
            } else if (bottom) {
                ms.m_85837_(0.5, 0.4375, 0.9375);
            } else {
                ms.m_85837_(0.5, 0.75, 0.875);
            }
            CachedBufferer.partial((PartialModel)AllBlockPartials.SIGNAL_WHITE_CUBE, (BlockState)blockState).light(0xF000F0).disableDiffuse().scale(1.0f, 1.0f, 1.0f).renderInto(ms, buffer.m_6299_(RenderType.m_110466_()));
            CachedBufferer.partial((PartialModel)(bottom ? AllBlockPartials.SIGNAL_WHITE_GLOW : (yellow ? AllBlockPartials.SIGNAL_YELLOW_GLOW : AllBlockPartials.SIGNAL_RED_GLOW)), (BlockState)blockState).light(0xF000F0).disableDiffuse().scale(1.5f, 2.0f, 2.0f).renderInto(ms, buffer.m_6299_(RenderTypes.getAdditive()));
            ((SuperByteBuffer)CachedBufferer.partial((PartialModel)(bottom ? CRBlockPartials.SEMAPHORE_LAMP_WHITE : (yellow ? CRBlockPartials.SEMAPHORE_LAMP_YELLOW : CRBlockPartials.SEMAPHORE_LAMP_RED)), (BlockState)blockState).light(0xF000F0).disableDiffuse().scale(1.0625f)).renderInto(ms, buffer.m_6299_(RenderTypes.getAdditive()));
            ms.m_85849_();
        }
        ms.m_85849_();
    }
}

