/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.mixin.AccessorTrackPlacement_PlacementInfo;
import com.railwayteam.railways.mixin_interfaces.IHasTrackMaterial;
import com.railwayteam.railways.track_api.TrackMaterial;
import com.railwayteam.railways.util.BlockStateUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrackPlacement.class}, remap=false)
public class MixinTrackPlacement {
    @Unique
    private static final ThreadLocal<ItemStack> railway$heldStack = new ThreadLocal();
    private static final ItemStack DUMMY = new ItemStack((ItemLike)Items.f_41852_);

    @ModifyVariable(method={"tryConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;", remap=true))
    private static TrackPlacement.PlacementInfo railway$storeMaterialInInfo(TrackPlacement.PlacementInfo info, Level level, Player player, BlockPos pos2, BlockState state2, ItemStack stack, boolean girder, boolean maximiseTurn) {
        BlockItem block;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (item = (block = (BlockItem)item).m_40614_()) instanceof IHasTrackMaterial) {
            IHasTrackMaterial materialProvider = (IHasTrackMaterial)item;
            TrackMaterial material = materialProvider.getMaterial();
            ((IHasTrackMaterial)info).setMaterial(material);
        }
        return info;
    }

    @ModifyArg(method={"tryConnect"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/track/TrackPlacement;placeTracks(Lnet/minecraft/world/level/Level;Lcom/simibubi/create/content/logistics/trains/track/TrackPlacement$PlacementInfo;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Z)Lcom/simibubi/create/content/logistics/trains/track/TrackPlacement$PlacementInfo;", remap=true))
    private static TrackPlacement.PlacementInfo railway$storeMaterialInCurve(TrackPlacement.PlacementInfo info) {
        BezierConnection curve = ((AccessorTrackPlacement_PlacementInfo)info).getCurve();
        if (curve != null) {
            TrackMaterial material = ((IHasTrackMaterial)info).getMaterial();
            ((IHasTrackMaterial)curve).setMaterial(material);
        }
        return info;
    }

    @Inject(method={"tryConnect"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getInventory()Lnet/minecraft/world/entity/player/Inventory;", remap=true)})
    private static void railway$grabHeldStack(Level level, Player player, BlockPos pos2, BlockState state2, ItemStack stack, boolean girder, boolean maximiseTurn, CallbackInfoReturnable<TrackPlacement.PlacementInfo> cir) {
        railway$heldStack.set(stack);
    }

    @ModifyArg(method={"tryConnect"}, at=@At(value="INVOKE", target="Lcom/tterrag/registrate/util/entry/BlockEntry;isIn(Lnet/minecraft/world/item/ItemStack;)Z", remap=true))
    private static ItemStack railway$consumeCorrectItem(ItemStack stackInSlot) {
        boolean isTrack = railway$heldStack.get().m_41656_(stackInSlot);
        return isTrack ? AllBlocks.TRACK.asStack() : DUMMY;
    }

    @ModifyVariable(method={"placeTracks"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private static BlockState railway$modifyFirstPlacedTrackBlockMaterial(BlockState original, Level level, TrackPlacement.PlacementInfo info, BlockState state1, BlockState state2, BlockPos targetPos1, BlockPos targetPos2, boolean simulate) {
        return MixinTrackPlacement.railway$doMaterialModification(original, level, targetPos1, info);
    }

    @ModifyVariable(method={"placeTracks"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private static BlockState railway$modifySecondPlacedTrackBlockMaterial(BlockState original, Level level, TrackPlacement.PlacementInfo info, BlockState state1, BlockState state2, BlockPos targetPos1, BlockPos targetPos2, boolean simulate) {
        return MixinTrackPlacement.railway$doMaterialModification(original, level, targetPos2, info);
    }

    @Unique
    private static BlockState railway$doMaterialModification(BlockState original, Level level, BlockPos pos, TrackPlacement.PlacementInfo info) {
        BlockState existing = level.m_8055_(pos);
        if (existing.m_60734_() instanceof ITrackBlock) {
            return original;
        }
        TrackMaterial material = ((IHasTrackMaterial)info).getMaterial();
        if (material != null) {
            TrackBlock customTrack = (TrackBlock)material.getTrackBlock().get();
            return BlockStateUtils.trackWith(customTrack, original);
        }
        return original;
    }
}

