/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.mixin_interfaces.IHasTrackMaterial;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.track_api.TrackMaterial;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TrackBlock.class}, remap=false)
public class MixinTrackBlockClient {
    @Inject(method={"prepareTrackOverlay"}, at={@At(value="INVOKE_ASSIGN", target="Lcom/jozufozu/flywheel/util/transform/TransformStack;translate(DDD)Ljava/lang/Object;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    private void bezierShiftTrackOverlay(BlockGetter world, BlockPos pos, BlockState state, BezierTrackPointLocation bezierPoint, Direction.AxisDirection direction, PoseStack ms, TrackTargetingBehaviour.RenderedTrackOverlayType type, CallbackInfoReturnable<PartialModel> cir, TransformStack msr, Vec3 axis, Vec3 diff, Vec3 normal, Vec3 offset, TrackTileEntity trackTE, BezierConnection bc) {
        IHasTrackCasing casingBc = (IHasTrackCasing)bc;
        if (((IHasTrackMaterial)bc).getMaterial().trackType == TrackMaterial.TrackType.MONORAIL) {
            msr.translate(0.0, 0.875, 0.0);
            return;
        }
        if (casingBc.getTrackCasing() != null) {
            if (((BlockPos)bc.tePositions.getFirst()).m_123342_() == ((BlockPos)bc.tePositions.getSecond()).m_123342_()) {
                msr.translate(0.0, 0.0625, 0.0);
            } else if (!casingBc.isAlternate()) {
                msr.translate(0.0, 0.25, 0.0);
            }
        }
    }

    @Inject(method={"prepareTrackOverlay"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/track/TrackRenderer;getModelAngles(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", remap=true)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    private void blockShiftTrackOverlay(BlockGetter world, BlockPos pos, BlockState state, BezierTrackPointLocation bezierPoint, Direction.AxisDirection direction, PoseStack ms, TrackTargetingBehaviour.RenderedTrackOverlayType type, CallbackInfoReturnable<PartialModel> cir, TransformStack msr) {
        Block block;
        if (bezierPoint == null && (block = state.m_60734_()) instanceof IHasTrackMaterial) {
            IHasTrackMaterial material = (IHasTrackMaterial)block;
            if (material.getMaterial().trackType == TrackMaterial.TrackType.MONORAIL) {
                msr.translate(0.0, 0.875, 0.0);
                return;
            }
        }
        if (bezierPoint == null && (block = world.m_7702_(pos)) instanceof TrackTileEntity) {
            CRBlockPartials.TrackCasingSpec spec;
            TrackTileEntity trackTE = (TrackTileEntity)block;
            IHasTrackCasing casingTE = (IHasTrackCasing)trackTE;
            TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
            if (casingTE.getTrackCasing() != null && (spec = CRBlockPartials.TRACK_CASINGS.get(shape)) != null) {
                msr.translate(spec.getXShift(), (double)((float)(spec.getTopSurfacePixelHeight(casingTE.isAlternate()) - 2) / 16.0f), spec.getZShift());
            }
        }
    }
}

