/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ClientConfig;
import de.maxhenkel.camera.ClientEvents;
import de.maxhenkel.camera.ImageCloningRecipe;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.ServerConfig;
import de.maxhenkel.camera.ServerEvents;
import de.maxhenkel.camera.corelib.ClientRegistry;
import de.maxhenkel.camera.corelib.CommonRegistry;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.entities.ImageRenderer;
import de.maxhenkel.camera.gui.AlbumContainer;
import de.maxhenkel.camera.gui.AlbumInventoryContainer;
import de.maxhenkel.camera.gui.AlbumInventoryScreen;
import de.maxhenkel.camera.gui.LecternAlbumScreen;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.items.ImageFrameItem;
import de.maxhenkel.camera.items.ImageItem;
import de.maxhenkel.camera.net.MessageAlbumPage;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import de.maxhenkel.camera.net.MessagePartialImage;
import de.maxhenkel.camera.net.MessageRequestImage;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageResizeFrame;
import de.maxhenkel.camera.net.MessageSetShader;
import de.maxhenkel.camera.net.MessageTakeBook;
import de.maxhenkel.camera.net.MessageTakeImage;
import de.maxhenkel.camera.net.MessageUploadCustomImage;
import de.maxhenkel.camera.net.PacketManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="camera")
public class Main {
    public static final String MODID = "camera";
    public static final Logger LOGGER = LogManager.getLogger((String)"camera");
    public static SimpleChannel SIMPLE_CHANNEL;
    public static PacketManager PACKET_MANAGER;
    private static final DeferredRegister<Item> ITEM_REGISTER;
    public static final RegistryObject<ImageFrameItem> FRAME_ITEM;
    public static final RegistryObject<CameraItem> CAMERA;
    public static final RegistryObject<ImageItem> IMAGE;
    public static final RegistryObject<AlbumItem> ALBUM;
    private static final DeferredRegister<MenuType<?>> MENU_REGISTER;
    public static final RegistryObject<MenuType<AlbumInventoryContainer>> ALBUM_INVENTORY_CONTAINER;
    public static final RegistryObject<MenuType<AlbumContainer>> ALBUM_CONTAINER;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER;
    public static final RegistryObject<EntityType<ImageEntity>> IMAGE_ENTITY_TYPE;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTER;
    public static final RegistryObject<RecipeSerializer<ImageCloningRecipe>> IMAGE_CLONING_SERIALIZER;
    public static TagKey<Item> IMAGE_PAPER;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyMapping KEY_NEXT;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyMapping KEY_PREVIOUS;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class, true);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerKeyBinds);
        });
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEM_REGISTER.register(eventBus);
        MENU_REGISTER.register(eventBus);
        ENTITY_REGISTER.register(eventBus);
        RECIPE_SERIALIZER_REGISTER.register(eventBus);
        ModSounds.SOUND_REGISTER.register(eventBus);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        PACKET_MANAGER = new PacketManager();
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessagePartialImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessageTakeImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 2, MessageRequestImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 3, MessageImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 4, MessageImageUnavailable.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 5, MessageSetShader.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 6, MessageDisableCameraMode.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 7, MessageResizeFrame.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 8, MessageRequestUploadCustomImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 9, MessageUploadCustomImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 10, MessageAlbumPage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 11, MessageTakeBook.class);
    }

    private static EntityType<ImageEntity> createImageEntityType() {
        return CommonRegistry.registerEntity(MODID, "image_frame", MobCategory.MISC, ImageEntity.class, builder -> builder.setTrackingRange(256).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).m_20699_(1.0f, 1.0f).setCustomClientFactory((spawnEntity, world) -> new ImageEntity((Level)world)));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        ClientRegistry.registerScreen((MenuType)ALBUM_INVENTORY_CONTAINER.get(), AlbumInventoryScreen::new);
        ClientRegistry.registerScreen((MenuType)ALBUM_CONTAINER.get(), LecternAlbumScreen::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)IMAGE_ENTITY_TYPE.get()), ImageRenderer::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerKeyBinds(RegisterKeyMappingsEvent event) {
        KEY_NEXT = new KeyMapping("key.next_image", 264, "key.categories.misc");
        KEY_PREVIOUS = new KeyMapping("key.previous_image", 265, "key.categories.misc");
        event.register(KEY_NEXT);
        event.register(KEY_PREVIOUS);
    }

    static {
        ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        FRAME_ITEM = ITEM_REGISTER.register("image_frame", ImageFrameItem::new);
        CAMERA = ITEM_REGISTER.register(MODID, CameraItem::new);
        IMAGE = ITEM_REGISTER.register("image", ImageItem::new);
        ALBUM = ITEM_REGISTER.register("album", AlbumItem::new);
        MENU_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        ALBUM_INVENTORY_CONTAINER = MENU_REGISTER.register("album_inventory", () -> IForgeMenuType.create((windowId, inv, data) -> new AlbumInventoryContainer(windowId, (Container)inv)));
        ALBUM_CONTAINER = MENU_REGISTER.register("album", () -> IForgeMenuType.create((windowId, inv, data) -> new AlbumContainer(windowId)));
        ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)MODID);
        IMAGE_ENTITY_TYPE = ENTITY_REGISTER.register("image_frame", Main::createImageEntityType);
        RECIPE_SERIALIZER_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        IMAGE_CLONING_SERIALIZER = RECIPE_SERIALIZER_REGISTER.register("image_cloning", ImageCloningRecipe.ImageCloningSerializer::new);
        IMAGE_PAPER = ItemTags.create((ResourceLocation)new ResourceLocation(MODID, "image_paper"));
    }
}

