/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class HalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
            return switch (type) {
                case BlockType.FRAMED_HALF_STAIRS -> HalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> HalfStairsSkipPredicate.testAgainstDividedStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_STAIRS -> HalfStairsSkipPredicate.testAgainstStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> HalfStairsSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalDividedStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> HalfStairsSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> HalfStairsSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> HalfStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> HalfStairsSkipPredicate.testAgainstDividedPanelVert(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> HalfStairsSkipPredicate.testAgainstSlabCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_PANEL -> HalfStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> HalfStairsSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstStackedSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatStackedSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> HalfStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> HalfStairsSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> HalfStairsSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, top, right, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(HalfStairsSkipPredicate.getStairDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstStairs(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedPanelVert(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatStackedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static TriangleDir getStairDir(Direction dir, boolean top, boolean right, Direction side) {
        if (!right && side == dir.m_122428_() || right && side == dir.m_122427_()) {
            return TriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
        }
        return TriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean top, boolean right, Direction side) {
        if (side == dir || !top && side == Direction.DOWN || top && side == Direction.UP) {
            return HalfDir.fromDirections(side, right ? dir.m_122427_() : dir.m_122428_());
        }
        return HalfDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, boolean top, boolean right, Direction side) {
        if (side == dir.m_122424_()) {
            return CornerDir.fromDirections(side, top ? Direction.UP : Direction.DOWN, right ? dir.m_122427_() : dir.m_122428_());
        }
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return CornerDir.fromDirections(side, dir, right ? dir.m_122427_() : dir.m_122428_());
        }
        return CornerDir.NULL;
    }
}

