/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import shadows.placebo.Placebo;
import shadows.placebo.json.DynamicRegistryObject;
import shadows.placebo.json.ListenerCallback;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.SerializerMap;
import shadows.placebo.json.TypeKeyed;
import shadows.placebo.network.PacketDistro;
import shadows.placebo.packets.ReloadListenerPacket;

public abstract class PlaceboJsonReloadListener<V extends TypeKeyed<V>>
extends SimpleJsonResourceReloadListener {
    public static final ResourceLocation DEFAULT = new ResourceLocation("default");
    private static final Map<String, PlaceboJsonReloadListener<?>> SYNC_REGISTRY = new HashMap();
    protected final Logger logger;
    protected final String path;
    protected final boolean synced;
    protected final boolean subtypes;
    protected final SerializerMap<V> serializers;
    protected Map<ResourceLocation, V> registry = ImmutableMap.of();
    private final Map<ResourceLocation, V> staged = new HashMap<ResourceLocation, V>();
    private final Set<ListenerCallback<V>> callbacks = new HashSet<ListenerCallback<V>>();
    private WeakReference<ICondition.IContext> context;

    public PlaceboJsonReloadListener(Logger logger, String path, boolean synced, boolean subtypes) {
        super(new GsonBuilder().setLenient().create(), path);
        this.logger = logger;
        this.path = path;
        this.synced = synced;
        this.subtypes = subtypes;
        this.serializers = new SerializerMap(path);
        this.registerBuiltinSerializers();
        if (this.serializers.isEmpty()) {
            throw new RuntimeException("Attempted to create a json reload listener for " + path + " with no built-in serializers!");
        }
    }

    protected final void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.beginReload();
        objects.forEach((key, ele) -> {
            try {
                if (PlaceboJsonReloadListener.checkAndLogEmpty(ele, key, this.path, this.logger) && PlaceboJsonReloadListener.checkConditions(ele, key, this.path, this.logger, this.getContext())) {
                    JsonObject obj = ele.getAsJsonObject();
                    TypeKeyed deserialized = this.subtypes ? (TypeKeyed)this.serializers.read(obj) : (TypeKeyed)this.serializers.get(DEFAULT).read(obj);
                    deserialized.setId((ResourceLocation)key);
                    Preconditions.checkNotNull((Object)deserialized.getId(), (Object)("A " + this.path + " with id " + key + " failed to set ID."));
                    Preconditions.checkNotNull(deserialized.getSerializer(), (Object)("A " + this.path + " with id " + key + " is not declaring a serializer."));
                    Preconditions.checkNotNull((Object)this.serializers.get(deserialized.getSerializer()), (Object)("A " + this.path + " with id " + key + " is declaring an unregistered serializer."));
                    this.register((ResourceLocation)key, (Object)deserialized);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed parsing {} file {}.", (Object)this.path, key);
                this.logger.error("Underlying Exception: ", (Throwable)e);
            }
        });
        this.onReload();
    }

    protected abstract void registerBuiltinSerializers();

    protected void beginReload() {
        this.registry = new HashMap<ResourceLocation, V>();
        this.callbacks.forEach(l -> l.beginReload(this));
    }

    protected void onReload() {
        this.registry = ImmutableMap.copyOf(this.registry);
        this.logger.info("Registered {} {}.", (Object)this.registry.size(), (Object)this.path);
        this.callbacks.forEach(l -> l.onReload(this));
    }

    public final void registerSerializer(ResourceLocation id, PSerializer<? extends V> serializer) {
        serializer.validate(false, this.synced);
        if (this.subtypes) {
            if (this.serializers.contains(id)) {
                throw new RuntimeException("Attempted to register a " + this.path + " serializer with id " + id + " but one already exists!");
            }
            this.serializers.register(id, serializer);
        } else {
            if (!this.serializers.isEmpty()) {
                throw new RuntimeException("Attempted to register a " + this.path + " serializer with id " + id + " but subtypes are not supported!");
            }
            this.serializers.register(DEFAULT, serializer);
        }
    }

    private final void sync(OnDatapackSyncEvent e) {
        ServerPlayer player = e.getPlayer();
        if (player == null) {
            PacketDistro.sendToAll(Placebo.CHANNEL, new ReloadListenerPacket.Start(this.path));
            this.registry.forEach((k, v) -> PacketDistro.sendToAll(Placebo.CHANNEL, new ReloadListenerPacket.Content<TypeKeyed>(this.path, (ResourceLocation)k, (TypeKeyed)v)));
            PacketDistro.sendToAll(Placebo.CHANNEL, new ReloadListenerPacket.End(this.path));
        } else {
            PacketDistro.sendTo(Placebo.CHANNEL, new ReloadListenerPacket.Start(this.path), (Player)player);
            this.registry.forEach((k, v) -> PacketDistro.sendTo(Placebo.CHANNEL, new ReloadListenerPacket.Content<TypeKeyed>(this.path, (ResourceLocation)k, (TypeKeyed)v), (Player)player));
            PacketDistro.sendTo(Placebo.CHANNEL, new ReloadListenerPacket.End(this.path), (Player)player);
        }
    }

    protected <T extends V> void validateItem(T item) {
        Preconditions.checkNotNull(item);
    }

    protected <T extends V> void register(ResourceLocation key, T item) {
        if (item.getId() == null) {
            item.setId(key);
        }
        if (!item.getId().equals((Object)key)) {
            throw new UnsupportedOperationException("Attempted to register a " + this.path + " with a mismatched registry ID! Expected: " + item.getId() + " Provided: " + key);
        }
        this.validateItem(item);
        this.registry.put(key, item);
    }

    public Set<ResourceLocation> getKeys() {
        return this.registry.keySet();
    }

    public Collection<V> getValues() {
        return this.registry.values();
    }

    @Nullable
    public V getValue(ResourceLocation key) {
        return this.getOrDefault(key, null);
    }

    public V getOrDefault(ResourceLocation key, V defValue) {
        return (V)((TypeKeyed)this.registry.getOrDefault(key, defValue));
    }

    public static boolean checkAndLogEmpty(JsonElement e, ResourceLocation id, String type, Logger logger) {
        String s = e.toString();
        if (s.isEmpty() || s.equals("{}")) {
            logger.error("Ignoring {} item with id {} as it is empty.  Please switch to a condition-false json instead of an empty one.", (Object)type, (Object)id);
            return false;
        }
        return true;
    }

    public static boolean checkConditions(JsonElement e, ResourceLocation id, String type, Logger logger, ICondition.IContext context) {
        if (e.isJsonObject() && !CraftingHelper.processConditions((JsonObject)e.getAsJsonObject(), (String)"conditions", (ICondition.IContext)context)) {
            logger.debug("Skipping loading {} item with id {} as it's conditions were not met", (Object)type, (Object)id);
            return false;
        }
        return true;
    }

    protected final ICondition.IContext getContext() {
        return this.context.get() != null ? (ICondition.IContext)this.context.get() : ICondition.IContext.EMPTY;
    }

    public void registerToBus() {
        if (this.synced) {
            this.registerForSync(this);
        }
        MinecraftForge.EVENT_BUS.addListener(this::addReloader);
    }

    public final <T extends V> DynamicRegistryObject<T> makeObj(ResourceLocation id) {
        DynamicRegistryObject obj = new DynamicRegistryObject(id, this);
        this.registerCallback(obj);
        return obj;
    }

    public final boolean registerCallback(ListenerCallback<V> callback) {
        return this.callbacks.add(callback);
    }

    public final boolean removeCallback(ListenerCallback<V> callback) {
        return this.callbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerForSync(PlaceboJsonReloadListener<?> listener) {
        if (!listener.synced) {
            throw new RuntimeException("Attempted to register the non-synced JSON Reload Listener " + listener.path + " as a synced listener!");
        }
        Map<String, PlaceboJsonReloadListener<?>> map = SYNC_REGISTRY;
        synchronized (map) {
            if (SYNC_REGISTRY.containsKey(listener.path)) {
                throw new RuntimeException("Attempted to register the JSON Reload Listener for syncing " + listener.path + " but one already exists!");
            }
            SYNC_REGISTRY.put(listener.path, listener);
            MinecraftForge.EVENT_BUS.addListener(listener::sync);
        }
    }

    private final void addReloader(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)this);
        this.context = new WeakReference<ICondition.IContext>(e.getConditionContext());
    }

    public static void initSync(String path) {
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            v.staged.clear();
            return v;
        });
    }

    public static <V extends TypeKeyed<V>> void writeItem(String path, V value, FriendlyByteBuf buf) {
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            v.serializers.write(value, buf);
            return v;
        });
    }

    public static <V extends TypeKeyed<V>> V readItem(String path, ResourceLocation key, FriendlyByteBuf buf) {
        PlaceboJsonReloadListener<?> listener = SYNC_REGISTRY.get(path);
        if (listener == null) {
            throw new RuntimeException("Received sync packet for unknown registry!");
        }
        TypeKeyed v = (TypeKeyed)listener.serializers.read(buf);
        v.setId(key);
        return (V)v;
    }

    public static <V extends TypeKeyed<V>> void acceptItem(String path, V value) {
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            v.staged.put(value.getId(), value);
            return v;
        });
    }

    public static void endSync(String path) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return;
        }
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            v.beginReload();
            v.staged.forEach(v::register);
            v.onReload();
            return v;
        });
    }
}

