/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.screen.ChunkGrid;
import com.supermartijn642.chunkloaders.screen.PlayerRenderer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.ChunkPos;

public class ChunkLoaderScreen
extends BaseWidget {
    private final ChunkPos pos;
    private final UUID chunkLoaderOwner;
    private final int mapYLevel;
    private final int mapWidth;
    private final int mapHeight;
    private ChunkGrid grid;

    public ChunkLoaderScreen(ChunkPos centerPos, UUID chunkLoaderOwner, int mapYLevel, int mapWidth, int mapHeight) {
        super(0, 0, 14 + mapWidth * 18, 14 + mapHeight * 18);
        if (mapWidth % 2 == 0 || mapHeight % 2 == 0) {
            throw new IllegalArgumentException("Map width and height must be uneven!");
        }
        this.pos = centerPos;
        this.chunkLoaderOwner = chunkLoaderOwner;
        this.mapYLevel = mapYLevel;
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
    }

    protected void addWidgets() {
        ChunkPos topLeftChunk = new ChunkPos(this.pos.f_45578_ - (this.mapWidth - 1) / 2, this.pos.f_45579_ - (this.mapHeight - 1) / 2);
        this.grid = (ChunkGrid)this.addWidget((Widget)new ChunkGrid(6, 6, this.mapHeight, this.mapWidth, topLeftChunk, this.chunkLoaderOwner, this.mapYLevel));
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"chunkloaders.gui.title").get();
    }

    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY) {
        String username = PlayerRenderer.getPlayerUsername(this.chunkLoaderOwner);
        int usernameWidth = username == null ? 0 : ClientUtils.getFontRenderer().m_92852_((FormattedText)TextComponents.string((String)username).color(ChatFormatting.WHITE).get());
        ScreenUtils.drawScreenBackground((PoseStack)poseStack, (float)(this.width - 10), (float)((float)this.height / 2.0f - 30.0f), (float)Math.max(100, usernameWidth + 39), (float)60.0f);
        ScreenUtils.drawScreenBackground((PoseStack)poseStack, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height);
        super.renderBackground(poseStack, mouseX, mouseY);
    }

    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        super.renderForeground(poseStack, mouseX, mouseY);
        float panelX = this.width;
        float panelY = (float)this.height / 2.0f - 30.0f;
        ScreenUtils.drawString((PoseStack)poseStack, (Component)TextComponents.translation((String)"chunkloaders.gui.owner").get(), (float)(panelX + 5.0f), (float)(panelY + 7.0f));
        PlayerRenderer.renderPlayerHead(this.chunkLoaderOwner, poseStack, (int)panelX + 5, (int)panelY + 18, 12, 12);
        String username = PlayerRenderer.getPlayerUsername(this.chunkLoaderOwner);
        if (username != null) {
            ScreenUtils.drawStringWithShadow((PoseStack)poseStack, (Component)TextComponents.string((String)username).color(ChatFormatting.WHITE).get(), (float)(panelX + 21.0f), (float)(panelY + 20.0f));
        }
        ScreenUtils.drawString((PoseStack)poseStack, (Component)TextComponents.translation((String)"chunkloaders.gui.loaded_chunks").get(), (float)(panelX + 5.0f), (float)(panelY + 33.0f));
        int loadedCount = ChunkLoadingCapability.get(ClientUtils.getWorld()).getChunksLoadedByPlayer(this.chunkLoaderOwner).size();
        int maxLoaded = ChunkLoadersConfig.maxLoadedChunksPerPlayer.get();
        TextComponents.TextComponentBuilder loadedText = maxLoaded > 0 ? TextComponents.translation((String)"chunkloaders.gui.loaded_chunks.count_max", (Object[])new Object[]{loadedCount, maxLoaded}).color(loadedCount < maxLoaded ? ChatFormatting.WHITE : ChatFormatting.RED) : TextComponents.translation((String)"chunkloaders.gui.loaded_chunks.count", (Object[])new Object[]{loadedCount}).color(ChatFormatting.WHITE);
        ScreenUtils.drawStringWithShadow((PoseStack)poseStack, (Component)loadedText.get(), (float)(panelX + 5.0f), (float)(panelY + 44.0f));
    }
}

