/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;
import team.creative.creativecore.common.util.math.geo.Rect;

public abstract class GuiLayer
extends GuiParent {
    @OnlyIn(value=Dist.CLIENT)
    public GuiStyle style;
    public final Rect rect;
    private final GuiSyncHolder.GuiSyncHolderLayer sync = new GuiSyncHolder.GuiSyncHolderLayer(this);
    private HashMap<GuiManager.GuiManagerType, GuiManager> managers;

    public GuiLayer(String name) {
        super(name, GuiFlow.STACK_X);
        this.rect = new Rect(0.0, 0.0, 0.0, 0.0);
        if (CreativeCore.loader().getOverallSide().isClient()) {
            this.style = GuiStyle.getStyle(name);
        }
    }

    public GuiLayer(String name, int width, int height) {
        super(name, (GuiFlow)GuiFlow.STACK_X, width, height);
        this.rect = new Rect(0.0, 0.0, width, height);
        if (CreativeCore.loader().getOverallSide().isClient()) {
            this.style = GuiStyle.getStyle(name);
        }
    }

    protected static void collectInventories(Iterable<GuiChildControl> parent, List<IGuiInventory> inventories) {
        for (GuiChildControl child : parent) {
            if (child.control instanceof IGuiInventory) {
                inventories.add((IGuiInventory)((Object)child.control));
                continue;
            }
            if (!(child.control instanceof GuiParent)) continue;
            GuiLayer.collectInventories((GuiParent)child.control, inventories);
        }
    }

    public Iterable<IGuiInventory> inventoriesToInsert() {
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        GuiLayer.collectInventories(this, inventories);
        return inventories;
    }

    public Iterable<IGuiInventory> inventoriesToExract() {
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        GuiLayer.collectInventories(this, inventories);
        Collections.reverse(inventories);
        return inventories;
    }

    public boolean has(GuiManager.GuiManagerType type) {
        if (this.managers == null) {
            return false;
        }
        return this.managers.containsKey(type);
    }

    public <T extends GuiManager> T getOrCreate(GuiManager.GuiManagerType<T> type) {
        GuiManager manager;
        if (this.managers == null) {
            this.managers = new HashMap();
        }
        if ((manager = this.managers.get(type)) == null) {
            manager = (GuiManager)type.factory().apply(this);
            this.managers.put(type, manager);
        }
        return (T)manager;
    }

    public GuiManagerItem itemManager() {
        return this.getOrCreate(GuiManager.ITEM);
    }

    public Iterable<GuiManager> managers() {
        if (this.managers == null) {
            return Collections.EMPTY_LIST;
        }
        return this.managers.values();
    }

    public GuiSyncHolder.GuiSyncHolderLayer getSyncHolder() {
        return this.sync;
    }

    public int getWidth() {
        return (int)this.rect.getWidth();
    }

    public int getHeight() {
        return (int)this.rect.getHeight();
    }

    @Override
    public void init() {
        this.createSync(this.sync);
        this.create();
        super.init();
        this.reflow();
    }

    public void reinit() {
        super.init();
        this.reflow();
    }

    @Override
    public void reflow() {
        if (CreativeCore.loader().getOverallSide().isServer()) {
            return;
        }
        if (!this.hasPreferredDimensions) {
            int preferredWidth = this.preferredWidth();
            this.rect.maxX = preferredWidth + this.getContentOffset() * 2;
            int width = (int)this.rect.getWidth() - this.getContentOffset() * 2;
            this.flowX(width, preferredWidth);
            this.rect.maxY = this.preferredHeight((int)this.rect.getWidth()) + this.getContentOffset() * 2;
            this.flowY(width, (int)this.rect.getHeight() - this.getContentOffset() * 2, this.preferredHeight(width));
        } else {
            this.flowX((int)this.rect.getWidth() - this.getContentOffset() * 2, this.preferredWidth());
            this.flowY((int)this.rect.getWidth() - this.getContentOffset() * 2, (int)this.rect.getHeight() - this.getContentOffset() * 2, this.preferredHeight((int)this.rect.getWidth()));
        }
    }

    public abstract void create();

    public void createSync(GuiSyncHolder holder) {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.GUI;
    }

    @Override
    public String getNestedName() {
        return "gui." + super.getNestedName();
    }

    @Override
    public GuiLayer getLayer() {
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiStyle getStyle() {
        return this.style;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        for (GuiManager manager : this.managers()) {
            manager.renderOverlay(matrix, control, rect, mouseX - (int)rect.minX, mouseY - (int)rect.minY);
        }
    }

    public boolean closeLayerUsingEscape() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Options getSettings() {
        return Minecraft.m_91087_().f_91066_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasGrayBackground() {
        return true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (!this.rect.inside(x, y)) {
            this.looseFocus();
            for (GuiManager manager : this.managers()) {
                manager.mouseClickedOutside(x, y);
            }
            return false;
        }
        return super.mouseClicked(rect, x, y, button);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        super.mouseReleased(rect, x, y, button);
        for (GuiManager manager : this.managers()) {
            manager.mouseReleased(x, y, button);
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.closeLayerUsingEscape()) {
                this.closeTopLayer();
            }
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.getSettings().f_92092_.m_90832_(keyCode, scanCode)) {
            this.closeTopLayer();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLayer() {
        return true;
    }

    @Override
    public void tick() {
        for (GuiManager manager : this.managers()) {
            manager.tick();
        }
        super.tick();
    }

    @Override
    public void closed() {
        for (GuiManager manager : this.managers()) {
            manager.closed();
        }
        super.closed();
    }

    @Override
    public Rect toLayerRect(GuiControl control, Rect rect) {
        GuiChildControl child = this.find(control);
        if (child == null) {
            return rect;
        }
        rect.move(child.rect.minX + this.getOffsetX(), child.rect.minY + this.getOffsetY());
        return rect;
    }
}

