/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.tree;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.tree.GuiTree;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiTreeItem
extends GuiParent {
    private final GuiTree tree;
    private GuiTreeItem parentItem;
    private List<GuiTreeItem> items = new ArrayList<GuiTreeItem>();
    private int level = 0;
    private boolean open = true;
    private boolean selected = false;
    private GuiLabel label;
    private GuiButton button;
    private ItemClickState state = null;

    public GuiTreeItem(String name, GuiTree tree) {
        super(name);
        this.tree = tree;
        this.label = new GuiLabel("title");
        this.add(this.label);
        this.flow = GuiFlow.STACK_X;
        this.spacing = 5;
    }

    public GuiTreeItem setTranslate(String translate) {
        this.label.setTranslate(translate);
        return this;
    }

    public GuiTreeItem setTitle(Component component) {
        this.label.setTitle(component);
        return this;
    }

    public GuiTreeItem setTitle(List<Component> components) {
        this.label.setTitle(components);
        return this;
    }

    public boolean opened() {
        return this.open;
    }

    public void toggle() {
        if (this.button != null) {
            this.open = !this.open;
            this.button.setTitle((Component)Component.m_237113_((String)(this.open ? "-" : "+")));
            this.tree.updateTree();
        }
    }

    protected void updateControls() {
        if (this.items.isEmpty() && this.button != null) {
            this.clear();
            this.button = null;
            this.add(this.label);
        } else if (!this.items.isEmpty() && this.button == null) {
            this.clear();
            this.button = (GuiButton)new GuiButtonHoldSlim("expand", x -> this.toggle()).setTitle((Component)Component.m_237113_((String)"-"));
            this.add(this.button);
            this.add(this.label);
        }
    }

    public GuiTreeItem getParentItem() {
        return this.parentItem;
    }

    public boolean removeItem(GuiTreeItem item) {
        if (this.items.remove(item)) {
            item.parentItem = null;
            this.updateControls();
            return true;
        }
        return false;
    }

    public void insertItem(int index, GuiTreeItem item) {
        item.parentItem = this;
        item.updateLevel();
        this.items.add(index, item);
        this.updateControls();
    }

    public void addItem(GuiTreeItem item) {
        item.parentItem = this;
        item.updateLevel();
        this.items.add(item);
        this.updateControls();
    }

    protected void updateLevel() {
        this.level = this.parentItem.level + 1;
        for (GuiTreeItem item : this.items) {
            item.updateLevel();
        }
    }

    public int getLevel() {
        return this.level;
    }

    public Iterable<GuiTreeItem> items() {
        return this.items;
    }

    public GuiTreeItem getItem(int index) {
        return this.items.get(index);
    }

    public int indexOf(GuiTreeItem item) {
        return this.items.indexOf(item);
    }

    public int itemsCount() {
        return this.items.size();
    }

    public boolean isChild(GuiTreeItem item) {
        for (GuiTreeItem child : this.items) {
            if (child != item && !child.isChild(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        super.mouseMoved(rect, x, y);
        if (this.state == ItemClickState.CLICKED && !this.tree.isDragged() && !rect.inside(x, y)) {
            this.tree.startDrag(this);
            this.state = ItemClickState.DRAGGED;
        }
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        super.mouseReleased(rect, x, y, button);
        if (this.state == ItemClickState.CLICKED) {
            this.tree.select(this);
            GuiTreeItem.playSound(SoundEvents.f_12490_);
        } else if (this.state == ItemClickState.DRAGGED && this.tree.endDrag()) {
            GuiTreeItem.playSound(SoundEvents.f_12490_, 0.1f, 2.0f);
        }
        this.state = null;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (super.mouseClicked(rect, x, y, button)) {
            return true;
        }
        this.state = ItemClickState.CLICKED;
        return true;
    }

    @Override
    public boolean mouseDoubleClicked(Rect rect, double x, double y, int button) {
        this.toggle();
        this.tree.select(this);
        GuiTreeItem.playSound(SoundEvents.f_12490_);
        return true;
    }

    @Override
    public boolean testForDoubleClick(Rect rect, double x, double y) {
        return true;
    }

    protected void updateColor() {
        if (this.selected) {
            this.label.setDefaultColor(-256);
        } else {
            this.label.setDefaultColor(-1);
        }
    }

    @Override
    public ControlFormatting getControlFormatting() {
        if (this.state == ItemClickState.DRAGGED) {
            return ControlFormatting.OUTLINE;
        }
        return super.getControlFormatting();
    }

    public boolean selected() {
        return this.selected;
    }

    protected void select() {
        this.selected = true;
        this.updateColor();
    }

    protected void deselect() {
        this.selected = false;
        this.updateColor();
    }

    private static enum ItemClickState {
        CLICKED,
        DRAGGED;

    }
}

