/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class NeighborUpdateCollector {
    protected final Level level;
    private final HashSet<BlockPos> blocksToUpdate;

    public NeighborUpdateCollector(Level level, Collection<BlockPos> positions) {
        this.level = level;
        this.blocksToUpdate = new HashSet<BlockPos>(positions);
    }

    public NeighborUpdateCollector(Level level) {
        this.level = level;
        this.blocksToUpdate = new HashSet();
    }

    public void add(BlockPos pos) {
        this.blocksToUpdate.add(pos);
    }

    public void add(BlockEntity be) {
        this.blocksToUpdate.add(be.m_58899_());
    }

    public void add(Collection<BlockPos> positions) {
        this.blocksToUpdate.addAll(positions);
    }

    protected void processPosition(BlockPos pos, HashSet<BlockPos> notifiedBlocks) {
        BlockState origin = this.level.m_8055_(pos);
        for (int i = 0; i < 6; ++i) {
            BlockPos neighbour = pos.m_121945_(Direction.values()[i]);
            if (notifiedBlocks.contains(neighbour) || this.blocksToUpdate.contains(neighbour)) continue;
            this.level.m_8055_(neighbour).m_60690_(this.level, neighbour, origin.m_60734_(), pos, false);
            notifiedBlocks.add(neighbour);
        }
    }

    public void process() {
        HashSet<BlockPos> notifiedBlocks = new HashSet<BlockPos>();
        for (BlockPos pos : this.blocksToUpdate) {
            this.processPosition(pos, notifiedBlocks);
        }
        this.blocksToUpdate.clear();
    }
}

