/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.core.GameStateRegistry;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.core.shader.ProgramSpec;
import com.jozufozu.flywheel.core.source.Resolver;
import com.jozufozu.flywheel.core.source.ShaderSources;
import com.jozufozu.flywheel.event.GatherContextEvent;
import com.jozufozu.flywheel.util.ResourceUtil;
import com.jozufozu.flywheel.util.StringUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public class Loader
implements ResourceManagerReloadListener {
    public static final String PROGRAM_DIR = "flywheel/programs/";
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<ResourceLocation, ProgramSpec> programs = new HashMap<ResourceLocation, ProgramSpec>();
    private boolean firstLoad = true;

    Loader() {
        ResourceManager manager;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && (manager = minecraft.m_91098_()) instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)manager).m_7217_((PreparableReloadListener)this);
        }
    }

    @Nullable
    public ProgramSpec get(ResourceLocation name) {
        return this.programs.get(name);
    }

    public void m_6213_(ResourceManager manager) {
        Backend.refresh();
        GameStateRegistry._clear();
        Resolver.INSTANCE.invalidate();
        ModLoader.get().postEvent((Event)new GatherContextEvent(this.firstLoad));
        ShaderSources sources = new ShaderSources(manager);
        this.loadProgramSpecs(manager);
        Resolver.INSTANCE.run(sources);
        Backend.LOGGER.info("Loaded all shader sources.");
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (Backend.canUseInstancing((Level)world)) {
            InstancedRenderDispatcher.resetInstanceWorld(world);
            CrumblingRenderer.reset();
        }
        this.firstLoad = false;
    }

    private void loadProgramSpecs(ResourceManager manager) {
        this.programs.clear();
        Map programSpecs = manager.m_214159_(PROGRAM_DIR, loc -> loc.m_135815_().endsWith(".json"));
        programSpecs.forEach((location, resource) -> {
            try (InputStream inputStream = resource.m_215507_();){
                String s = StringUtil.readToString(inputStream);
                ResourceLocation specName = ResourceUtil.trim(location, PROGRAM_DIR, ".json");
                DataResult result = ProgramSpec.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(s, JsonElement.class)));
                ProgramSpec spec = (ProgramSpec)((Pair)result.get().orThrow()).getFirst();
                spec.setName(specName);
                if (this.programs.containsKey(specName)) {
                    throw new IllegalStateException("Program spec '" + specName + "' already registered.");
                }
                this.programs.put(specName, spec);
            }
            catch (Exception e) {
                Backend.LOGGER.error("Could not load program " + location, (Throwable)e);
            }
        });
    }
}

