/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.materials.oriented;

import com.jozufozu.flywheel.core.materials.BasicData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class OrientedData
extends BasicData {
    public float posX;
    public float posY;
    public float posZ;
    public float pivotX = 0.5f;
    public float pivotY = 0.5f;
    public float pivotZ = 0.5f;
    public float qX;
    public float qY;
    public float qZ;
    public float qW = 1.0f;

    public OrientedData setPosition(BlockPos pos) {
        return this.setPosition(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public OrientedData setPosition(Vector3f pos) {
        return this.setPosition(pos.m_122239_(), pos.m_122260_(), pos.m_122269_());
    }

    public OrientedData setPosition(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.markDirty();
        return this;
    }

    public OrientedData nudge(float x, float y, float z) {
        this.posX += x;
        this.posY += y;
        this.posZ += z;
        this.markDirty();
        return this;
    }

    public OrientedData setPivot(Vector3f pos) {
        return this.setPosition(pos.m_122239_(), pos.m_122260_(), pos.m_122269_());
    }

    public OrientedData setPivot(Vec3 pos) {
        return this.setPosition((float)pos.m_7096_(), (float)pos.m_7098_(), (float)pos.m_7094_());
    }

    public OrientedData setPivot(float x, float y, float z) {
        this.pivotX = x;
        this.pivotY = y;
        this.pivotZ = z;
        this.markDirty();
        return this;
    }

    public OrientedData setRotation(Quaternion q) {
        return this.setRotation(q.m_80140_(), q.m_80150_(), q.m_80153_(), q.m_80156_());
    }

    public OrientedData setRotation(float x, float y, float z, float w) {
        this.qX = x;
        this.qY = y;
        this.qZ = z;
        this.qW = w;
        this.markDirty();
        return this;
    }

    public OrientedData resetRotation() {
        this.qX = 0.0f;
        this.qY = 0.0f;
        this.qZ = 0.0f;
        this.qW = 1.0f;
        this.markDirty();
        return this;
    }
}

