/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.core.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import eu.midnightdust.core.MidnightLibClient;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MidnightConfigOverviewScreen
extends Screen {
    private final Screen parent;
    private MidnightOverviewListWidget list;

    public MidnightConfigOverviewScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"midnightlib.overview.title"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 28, 200, 20, CommonComponents.f_130655_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)));
        this.list = new MidnightOverviewListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.list.m_93488_(false);
        }
        this.m_7787_((GuiEventListener)this.list);
        ArrayList<String> sortedMods = new ArrayList<String>(MidnightConfig.configClass.keySet());
        Collections.sort(sortedMods);
        sortedMods.forEach(modid -> {
            if (!MidnightLibClient.hiddenMods.contains(modid)) {
                this.list.addButton((AbstractWidget)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 28, 200, 20, (Component)Component.m_237115_((String)(modid + ".midnightconfig.title")), button -> Objects.requireNonNull(this.f_96541_).m_91152_(MidnightConfig.getScreen(this, modid))));
            }
        });
        super.m_7856_();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        MidnightConfigOverviewScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MidnightOverviewListWidget
    extends ContainerObjectSelectionList<OverviewButtonEntry> {
        Font textRenderer;

        public MidnightOverviewListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
            super(minecraftClient, i, j, k, l, m);
            this.f_93394_ = false;
            this.textRenderer = minecraftClient.f_91062_;
        }

        public int m_5756_() {
            return this.f_93388_ - 7;
        }

        public void addButton(AbstractWidget button) {
            this.m_7085_((AbstractSelectionList.Entry)OverviewButtonEntry.create(button));
        }

        public int m_5759_() {
            return 400;
        }
    }

    public static class OverviewButtonEntry
    extends ContainerObjectSelectionList.Entry<OverviewButtonEntry> {
        private final AbstractWidget button;
        private final List<AbstractWidget> buttonList = new ArrayList<AbstractWidget>();

        private OverviewButtonEntry(AbstractWidget button) {
            this.button = button;
            this.buttonList.add(button);
        }

        public static OverviewButtonEntry create(AbstractWidget button) {
            return new OverviewButtonEntry(button);
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.button.f_93621_ = y;
            this.button.m_6305_(matrices, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.buttonList;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.buttonList;
        }
    }
}

