/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.hats.witch;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import eu.midnightdust.hats.web.HatLoader;
import eu.midnightdust.hats.witch.WitchHatModel;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WitchHatFeatureRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final ModelLayerLocation WITCH_HAT_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("midnight-hats", "witch_hat"), "main");
    private static final UUID MOTSCHEN = UUID.fromString("a44c2660-630f-478f-946a-e518669fcf0c");
    private static final ResourceLocation WITCH = new ResourceLocation("textures/entity/witch.png");
    private static final ResourceLocation OVERLAY = new ResourceLocation("midnightlib", "textures/hats/overlay.png");
    private static final Color MOTSCHEN_COLOR = MidnightColorUtil.radialRainbow(1.0f, 1.0f);
    private static final Color ADOPTER_COLOR = MidnightColorUtil.hex2Rgb("ffffff");
    private static final Color MODDER_COLOR = MidnightColorUtil.hex2Rgb("7825b4");
    private static final Color FRIEND_COLOR = MidnightColorUtil.hex2Rgb("ff0234");
    private static final Color DONOR_COLOR = MidnightColorUtil.hex2Rgb("ff6c00");
    private static final Color SOCIAL_COLOR = MidnightColorUtil.hex2Rgb("238a9d");
    private final WitchHatModel<T> witchHat;
    private final Minecraft client = Minecraft.m_91087_();

    public WitchHatFeatureRenderer(RenderLayerParent<T, M> featureRendererContext, EntityModelSet entityModelLoader) {
        super(featureRendererContext);
        this.witchHat = new WitchHatModel(entityModelLoader.m_171103_(WITCH_HAT_MODEL_LAYER));
    }

    public static LayerDefinition getTexturedModelData() {
        return LayerDefinition.m_171565_((MeshDefinition)WitchHatModel.getModelData(), (int)64, (int)128);
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        Color hat_type = this.getHat(livingEntity.m_20148_());
        if (hat_type != null && !livingEntity.m_20177_((Player)this.client.f_91074_)) {
            if (hat_type == MOTSCHEN_COLOR) {
                hat_type = MidnightColorUtil.radialRainbow(1.0f, 1.0f);
            }
            matrixStack.m_85836_();
            ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(matrixStack);
            VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)WITCH));
            this.witchHat.m_7695_(matrixStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            VertexConsumer glow = vertexConsumerProvider.m_6299_(RenderType.m_110460_((ResourceLocation)OVERLAY, (boolean)true));
            matrixStack.m_85837_(0.0, 0.0, (double)-0.001f);
            this.witchHat.m_7695_(matrixStack, glow, 230, OverlayTexture.f_118083_, (float)hat_type.getRed() / 255.0f, (float)hat_type.getGreen() / 255.0f, (float)hat_type.getBlue() / 255.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }

    private Color getHat(UUID uuid) {
        if (uuid.equals(MOTSCHEN)) {
            return MOTSCHEN_COLOR;
        }
        if (HatLoader.PLAYER_HATS != null && HatLoader.PLAYER_HATS.containsKey(uuid)) {
            return switch (HatLoader.PLAYER_HATS.get(uuid).getHatType()) {
                case "adopter" -> ADOPTER_COLOR;
                case "contributer", "modder" -> MODDER_COLOR;
                case "friend" -> FRIEND_COLOR;
                case "donator", "donor" -> DONOR_COLOR;
                case "social" -> SOCIAL_COLOR;
                default -> MidnightColorUtil.hex2Rgb(HatLoader.PLAYER_HATS.get(uuid).getHatType());
            };
        }
        return null;
    }
}

