/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.awt.Color;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, Class<?>> configClass = new HashMap();
    private static Path path;
    private static final Gson gson;

    public static void init(String modid, Class<?> config) {
        path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
        configClass.put(modid, config);
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && PlatformFunctions.isClientEnv()) {
                MidnightConfig.initClient(modid, field, info);
            }
            if (field.isAnnotationPresent(Comment.class)) {
                info.centered = field.getAnnotation(Comment.class).centered();
            }
            if (!field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            MidnightConfig.write(modid);
        }
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void initClient(String modid, Field field, EntryInfo info) {
        Class<?> type = field.getType();
        Entry e = field.getAnnotation(Entry.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.id = modid;
        if (e != null) {
            if (!e.name().equals("")) {
                info.name = Component.m_237115_((String)e.name());
            }
            if (type == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (type == Float.TYPE) {
                MidnightConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (type == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (type == String.class || type == List.class) {
                info.max = e.max() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)e.max();
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (type == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.m_237115_((String)((Boolean)value != false ? "gui.yes" : "gui.no")).m_130940_((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            } else if (type.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> Component.m_237115_((String)(modid + ".midnightconfig.enum." + type.getSimpleName() + "." + info.value.toString()));
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            }
        }
        entries.add(info);
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)t, Component.m_237113_((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))));
            }
            info.tempValue = s;
            t.m_94202_(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.f_93623_ = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = isNumber ? value : s;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).toList().get(0));
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.colorButton.m_93666_((Component)Component.m_237113_((String)"\u2b1b").m_6270_(Style.f_131099_.m_178520_(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static void write(String modid) {
        path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson(configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Screen getScreen(Screen parent, String modid) {
        return new MidnightConfigScreen(parent, modid);
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).setPrettyPrinting().create();
    }

    protected static class EntryInfo {
        Field field;
        Object widget;
        int width;
        int max;
        boolean centered;
        Map.Entry<EditBox, Component> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        String id;
        Component name;
        int index;
        AbstractWidget colorButton;

        protected EntryInfo() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 100;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MidnightConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final Screen parent;
        public final String modid;
        public MidnightConfigListWidget list;
        public boolean reload = false;

        protected MidnightConfigScreen(Screen parent, String modid) {
            super((Component)Component.m_237115_((String)(modid + ".midnightconfig.title")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".midnightconfig.";
        }

        public void m_86600_() {
            super.m_86600_();
            for (EntryInfo info : entries) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.updateResetButtons();
        }

        public void updateResetButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.m_6702_()) {
                    AbstractWidget abstractWidget;
                    if (entry.buttons == null || entry.buttons.size() <= 1 || !((abstractWidget = entry.buttons.get(1)) instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.f_93623_ = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        public void loadValues() {
            try {
                gson.fromJson((Reader)Files.newBufferedReader(path), configClass.get(this.modid));
            }
            catch (Exception e) {
                MidnightConfig.write(this.modid);
            }
            for (EntryInfo info : entries) {
                if (!info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.value.toString();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        public void m_7856_() {
            super.m_7856_();
            if (!this.reload) {
                this.loadValues();
            }
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, button -> {
                this.loadValues();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            Button done = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20, CommonComponents.f_130655_, button -> {
                for (EntryInfo info : entries) {
                    if (!info.id.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                MidnightConfig.write(this.modid);
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            this.list = new MidnightConfigListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                this.list.m_93488_(false);
            }
            this.m_7787_((GuiEventListener)this.list);
            for (EntryInfo info : entries) {
                if (info.id.equals(this.modid)) {
                    Component name = Objects.requireNonNullElseGet(info.name, () -> Component.m_237115_((String)(this.translationPrefix + info.field.getName())));
                    Button resetButton = new Button(this.f_96543_ - 205, 0, 40, 20, (Component)Component.m_237113_((String)"Reset").m_130940_(ChatFormatting.RED), button -> {
                        info.value = info.defaultValue;
                        info.tempValue = info.defaultValue.toString();
                        info.index = 0;
                        double scrollAmount = this.list.m_93517_();
                        this.reload = true;
                        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                        this.list.m_93410_(scrollAmount);
                    });
                    if (info.widget instanceof Map.Entry) {
                        widget = (Map.Entry)info.widget;
                        if (info.field.getType().isEnum()) {
                            widget.setValue(value -> Component.m_237115_((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                        }
                        this.list.addButton(List.of(new Button(this.f_96543_ - 160, 0, 150, 20, (Component)((Function)widget.getValue()).apply(info.value), (Button.OnPress)widget.getKey()), resetButton), name, info);
                    } else if (info.field.getType() == List.class) {
                        if (!this.reload) {
                            info.index = 0;
                        }
                        widget = new EditBox(this.f_96547_, this.f_96543_ - 160, 0, 150, 20, (Component)Component.m_237119_());
                        widget.m_94199_(info.width);
                        if (info.index < ((List)info.value).size()) {
                            widget.m_94144_(String.valueOf(((List)info.value).get(info.index)));
                        }
                        Predicate processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                        widget.m_94153_(processor);
                        resetButton.m_93674_(20);
                        resetButton.m_93666_((Component)Component.m_237113_((String)"R").m_130940_(ChatFormatting.RED));
                        Button cycleButton = new Button(this.f_96543_ - 185, 0, 20, 20, (Component)Component.m_237113_((String)String.valueOf(info.index)).m_130940_(ChatFormatting.GOLD), button -> {
                            ((List)info.value).remove("");
                            double scrollAmount = this.list.m_93517_();
                            this.reload = true;
                            ++info.index;
                            if (info.index > ((List)info.value).size()) {
                                info.index = 0;
                            }
                            Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                            this.list.m_93410_(scrollAmount);
                        });
                        this.list.addButton(List.of(widget, resetButton, cycleButton), name, info);
                    } else if (info.widget != null) {
                        Entry e = info.field.getAnnotation(Entry.class);
                        widget = e.isSlider() ? new MidnightSliderWidget(this.f_96543_ - 160, 0, 150, 20, Component.m_130674_((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.f_96547_, this.f_96543_ - 160, 0, 150, 20, null, Component.m_130674_((String)info.tempValue));
                        if (widget instanceof EditBox) {
                            EditBox textField = (EditBox)widget;
                            textField.m_94199_(info.width);
                            textField.m_94144_(info.tempValue);
                            Predicate processor = (Predicate)((BiFunction)info.widget).apply(textField, done);
                            textField.m_94153_(processor);
                        }
                        if (e.isColor()) {
                            resetButton.m_93674_(20);
                            resetButton.m_93666_((Component)Component.m_237113_((String)"R").m_130940_(ChatFormatting.RED));
                            Button colorButton = new Button(this.f_96543_ - 185, 0, 20, 20, (Component)Component.m_237113_((String)"\u2b1b"), button -> {});
                            try {
                                colorButton.m_93666_((Component)Component.m_237113_((String)"\u2b1b").m_6270_(Style.f_131099_.m_178520_(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.colorButton = colorButton;
                            colorButton.f_93623_ = false;
                            this.list.addButton(List.of(widget, resetButton, colorButton), name, info);
                        } else {
                            this.list.addButton(List.of(widget, resetButton), name, info);
                        }
                    } else {
                        this.list.addButton(List.of(), name, info);
                    }
                }
                this.updateResetButtons();
            }
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            this.m_7333_(matrices);
            this.list.m_6305_(matrices, mouseX, mouseY, delta);
            MidnightConfigScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
            for (EntryInfo info : entries) {
                if (!info.id.equals(this.modid) || !this.list.getHoveredButton(mouseX, mouseY).isPresent()) continue;
                AbstractWidget buttonWidget = this.list.getHoveredButton(mouseX, mouseY).get();
                Component text = ButtonEntry.buttonsWithText.get(buttonWidget);
                MutableComponent name = Component.m_237115_((String)(this.translationPrefix + info.field.getName()));
                String key = this.translationPrefix + info.field.getName() + ".tooltip";
                if (info.error != null && text.equals(name)) {
                    this.m_96602_(matrices, info.error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!I18n.m_118936_((String)key) || !text.equals(name)) continue;
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                for (String str : I18n.m_118938_((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add(Component.m_237113_((String)str));
                }
                this.m_96597_(matrices, list, mouseX, mouseY);
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    private static class MidnightSliderWidget
    extends AbstractSliderButton {
        private final EntryInfo info;
        private final Entry e;

        public MidnightSliderWidget(int x, int y, int width, int height, Component text, double value, EntryInfo info) {
            super(x, y, width, height, text, value);
            this.e = info.field.getAnnotation(Entry.class);
            this.info = info;
        }

        protected void m_5695_() {
            this.m_93666_(Component.m_130674_((String)this.info.tempValue));
        }

        protected void m_5697_() {
            if (this.info.field.getType() == Integer.TYPE) {
                this.info.value = ((Number)(this.e.min() + this.f_93577_ * (this.e.max() - this.e.min()))).intValue();
            } else if (this.info.field.getType() == Double.TYPE) {
                this.info.value = (double)Math.round((this.e.min() + this.f_93577_ * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (double)this.e.precision();
            } else if (this.info.field.getType() == Float.TYPE) {
                this.info.value = Float.valueOf((float)Math.round((this.e.min() + this.f_93577_ * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (float)this.e.precision());
            }
            this.info.tempValue = String.valueOf(this.info.value);
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.m_91087_().f_91062_;
        public final List<AbstractWidget> buttons;
        private final Component text;
        public final EntryInfo info;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        public static final Map<AbstractWidget, Component> buttonsWithText = new HashMap<AbstractWidget, Component>();

        private ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            if (!buttons.isEmpty()) {
                buttonsWithText.put(buttons.get(0), text);
            }
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            this.children.addAll(buttons);
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.f_93621_ = y;
                b.m_6305_(matrices, mouseX, mouseY, tickDelta);
            });
            if (!(this.text == null || this.text.getString().contains("spacer") && this.buttons.isEmpty())) {
                if (this.info.centered) {
                    textRenderer.m_92763_(matrices, this.text, (float)Minecraft.m_91087_().m_91268_().m_85445_() / 2.0f - (float)textRenderer.m_92852_((FormattedText)this.text) / 2.0f, (float)(y + 5), 0xFFFFFF);
                } else {
                    GuiComponent.m_93243_((PoseStack)matrices, (Font)textRenderer, (Component)this.text, (int)12, (int)(y + 5), (int)0xFFFFFF);
                }
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MidnightConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        Font textRenderer;

        public MidnightConfigListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
            super(minecraftClient, i, j, k, l, m);
            this.f_93394_ = false;
            this.textRenderer = minecraftClient.f_91062_;
        }

        public int m_5756_() {
            return this.f_93388_ - 7;
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry(buttons, text, info));
        }

        public int m_5759_() {
            return 10000;
        }

        public Optional<AbstractWidget> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.m_6702_()) {
                if (buttonEntry.buttons.isEmpty() || !buttonEntry.buttons.get(0).m_5953_(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.buttons.get(0));
            }
            return Optional.empty();
        }
    }
}

