/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.hint;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.module.hint.HintObject;

public class HintManager {
    public static void loadHints(List<Field> fields, ConfigFlagManager flagManager, QuarkModule module) {
        for (Field f : fields) {
            f.setAccessible(true);
            Hint hint = f.getDeclaredAnnotation(Hint.class);
            if (hint == null) continue;
            HintObject hintObj = new HintObject(flagManager, module, hint, () -> {
                try {
                    return Optional.ofNullable(f.get(module));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            module.hints.add(hintObj);
        }
    }

    public static void hintItem(BiConsumer<Item, Component> consumer, ItemLike itemLike) {
        Item item = itemLike.m_5456_();
        ResourceLocation res = RegistryHelper.getRegistryName((Object)item, (Registry)Registry.f_122827_);
        Object ns = res.m_135827_();
        String path = res.m_135815_();
        ns = ((String)ns).equals("quark") ? "" : (String)ns + ".";
        HintManager.hintItem(consumer, (ItemLike)item, (String)ns + path);
    }

    public static void hintItem(BiConsumer<Item, Component> consumer, ItemLike itemLike, String key) {
        Item item = itemLike.m_5456_();
        String hint = String.format("quark.jei.hint." + key, new Object[0]);
        consumer.accept(item, (Component)Component.m_237115_((String)hint));
    }
}

