/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.AUTOMATION)
public class DispensersPlaceBlocksModule
extends QuarkModule {
    @Config
    public static List<String> blacklist = Lists.newArrayList((Object[])new String[]{"minecraft:water", "minecraft:lava", "minecraft:fire"});
    @Config(description="Set to false to refrain from registering any behaviors for blocks that have optional dispense behaviors already set.\nAn optional behavior is one that will defer to the generic dispense item behavior if its condition fails.\ne.g. the Shulker Box behavior is optional, because it'll throw out the item if it fails, whereas TNT is not optional.\nIf true, it'll attempt to use the previous behavior before trying to place the block in the world.\nRequires a game restart to re-apply.")
    public static boolean wrapExistingBehaviors = true;

    @Override
    public void setup() {
        if (!this.enabled) {
            return;
        }
        BlockBehavior baseBehavior = new BlockBehavior();
        this.enqueue(() -> {
            Map registry = DispenserBlock.f_52661_;
            for (Block b : ForgeRegistries.BLOCKS) {
                boolean exists;
                Item item;
                ResourceLocation res = Registry.f_122824_.m_7981_((Object)b);
                if (blacklist.contains(Objects.toString(res)) || !((item = b.m_5456_()) instanceof BlockItem)) continue;
                DispenseItemBehavior original = (DispenseItemBehavior)registry.get(item);
                boolean bl = exists = original != null;
                if (exists) {
                    if (!wrapExistingBehaviors || !(original instanceof OptionalDispenseItemBehavior)) continue;
                    OptionalDispenseItemBehavior opt = (OptionalDispenseItemBehavior)original;
                    registry.put(item, new BlockBehavior(opt));
                    continue;
                }
                registry.put(item, baseBehavior);
            }
        });
    }

    public static class BlockBehavior
    extends OptionalDispenseItemBehavior {
        private final OptionalDispenseItemBehavior wrapped;

        public BlockBehavior() {
            this(null);
        }

        public BlockBehavior(OptionalDispenseItemBehavior wrapped) {
            this.wrapped = wrapped;
        }

        @Nonnull
        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction;
            if (this.wrapped != null) {
                ItemStack wrappedResult = this.wrapped.m_6115_(source, stack);
                if (this.wrapped.m_123570_()) {
                    this.m_123573_(true);
                    return wrappedResult;
                }
            }
            this.m_123573_(false);
            Direction against = direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(direction);
            BlockItem item = (BlockItem)stack.m_41720_();
            Block block = item.m_40614_();
            if (block instanceof StairBlock && direction.m_122434_() != Direction.Axis.Y) {
                direction = direction.m_122424_();
            } else if (block instanceof SlabBlock) {
                against = Direction.UP;
            }
            this.m_123573_(item.m_40576_((BlockPlaceContext)new NotStupidDirectionalPlaceContext((Level)source.m_7727_(), pos, direction, stack, against)) == InteractionResult.SUCCESS);
            return stack;
        }
    }

    private static class NotStupidDirectionalPlaceContext
    extends DirectionalPlaceContext {
        protected boolean f_43628_;
        protected Direction f_43648_;

        public NotStupidDirectionalPlaceContext(Level worldIn, BlockPos pos, Direction facing, ItemStack stack, Direction against) {
            super(worldIn, pos, facing, stack, against);
            this.f_43628_ = worldIn.m_8055_(this.m_43718_().m_82425_()).m_60629_((BlockPlaceContext)this);
            this.f_43648_ = facing;
        }

        public boolean m_7059_() {
            return this.f_43628_;
        }

        @Nonnull
        public Direction m_7820_() {
            return this.f_43648_.m_122424_();
        }
    }
}

