/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.EXPERIMENTAL, enabledByDefault=false, description="This feature generates Resource Pack Item Model predicates on the items defined in 'Items to Change'\nfor the Enchantments defined in 'Enchantments to Register'.\n\nExample: if 'minecraft:silk_touch' is added to 'Enchantments to Register', and 'minecraft:netherite_pickaxe'\nis added to 'Items to Change', then a predicate named 'quark_has_enchant_minecraft_silk_touch' will be available\nto the netherite_pickaxe.json item model, whose value will be the enchantment level.")
public class EnchantmentPredicatesModule
extends QuarkModule {
    @Config
    public static List<String> itemsToChange = Lists.newArrayList();
    @Config
    public static List<String> enchantmentsToRegister = Lists.newArrayList();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        if (this.enabled) {
            this.enqueue(() -> {
                List<Item> items = MiscUtil.massRegistryGet(itemsToChange, ForgeRegistries.ITEMS);
                List<Enchantment> enchants = MiscUtil.massRegistryGet(enchantmentsToRegister, ForgeRegistries.ENCHANTMENTS);
                for (Enchantment enchant : enchants) {
                    ResourceLocation enchantRes = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
                    ResourceLocation name = new ResourceLocation("quark_has_enchant_" + enchantRes.m_135827_() + "_" + enchantRes.m_135815_());
                    ItemPropertyFunction fun = (stack, level, entity, i) -> EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)stack);
                    for (Item item : items) {
                        ItemProperties.register((Item)item, (ResourceLocation)name, (ItemPropertyFunction)fun);
                    }
                }
            });
        }
    }
}

