/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.mod.MonsterHunterModifier;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.ForgottenRenderer;
import vazkii.quark.content.mobs.entity.Forgotten;
import vazkii.quark.content.mobs.item.ForgottenHatItem;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class ForgottenModule
extends QuarkModule {
    public static EntityType<Forgotten> forgottenType;
    @Hint
    public static Item forgotten_hat;
    @Config(description="1 in this many Skeletons that spawn under the threshold are replaced with Forgotten.")
    public double forgottenSpawnRate = 0.05;
    @Config
    public int maxHeightForSpawn = 0;

    @Override
    public void register() {
        forgotten_hat = new ForgottenHatItem(this);
        forgottenType = EntityType.Builder.m_20704_(Forgotten::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.7f, 2.4f).m_20702_(8).setCustomClientFactory((spawnEntity, world) -> new Forgotten((EntityType<? extends Forgotten>)forgottenType, (Level)world)).m_20712_("forgotten");
        RegistryHelper.register(forgottenType, (String)"forgotten", (ResourceKey)Registry.f_122903_);
        EntitySpawnHandler.addEgg(forgottenType, 9868423, 0x3A3330, this, () -> true);
        EntityAttributeHandler.put(forgottenType, Forgotten::registerAttributes);
        QuarkAdvancementHandler.addModifier(new MonsterHunterModifier(this, (Set<EntityType<?>>)ImmutableSet.of(forgottenType)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(forgottenType, ForgottenRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSkeletonSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getSpawnReason() == MobSpawnType.SPAWNER) {
            return;
        }
        Mob entity = event.getEntity();
        Event.Result result = event.getResult();
        LevelAccessor world = event.getLevel();
        if (entity.m_6095_() == EntityType.f_20524_ && entity instanceof Mob) {
            Mob mob = entity;
            if (result != Event.Result.DENY && entity.m_20186_() < (double)this.maxHeightForSpawn && world.m_213780_().m_188500_() < this.forgottenSpawnRate && (result == Event.Result.ALLOW || mob.m_5545_(world, event.getSpawnReason()) && mob.m_6914_((LevelReader)world))) {
                Forgotten forgotten = new Forgotten(forgottenType, entity.f_19853_);
                Vec3 epos = entity.m_20182_();
                forgotten.m_19890_(epos.f_82479_, epos.f_82480_, epos.f_82481_, entity.m_146908_(), entity.m_146909_());
                forgotten.prepareEquipment();
                LivingSpawnEvent.CheckSpawn newEvent = new LivingSpawnEvent.CheckSpawn((Mob)forgotten, world, event.getX(), event.getY(), event.getZ(), event.getSpawner(), event.getSpawnReason());
                MinecraftForge.EVENT_BUS.post((Event)newEvent);
                if (newEvent.getResult() != Event.Result.DENY) {
                    world.m_7967_((Entity)forgotten);
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }
}

