/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.util.ClientTicker;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.tools.module.PathfinderMapsModule;

public class PathfindersQuillItem
extends QuarkItem
implements IItemColorProvider {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
    public static final String TAG_BIOME = "targetBiome";
    public static final String TAG_COLOR = "targetBiomeColor";
    public static final String TAG_UNDERGROUND = "targetBiomeUnderground";
    protected static final String TAG_IS_SEARCHING = "isSearchingForBiome";
    protected static final String TAG_SOURCE_X = "searchSourceX";
    protected static final String TAG_SOURCE_Z = "searchSourceZ";
    protected static final String TAG_POS_X = "searchPosX";
    protected static final String TAG_POS_Z = "searchPosZ";
    protected static final String TAG_POS_LEG = "searchPosLeg";
    protected static final String TAG_POS_LEG_INDEX = "searchPosLegIndex";
    private static final Map<Key, InteractionResultHolder<BlockPos>> RESULTS = new ConcurrentHashMap<Key, InteractionResultHolder<BlockPos>>();
    private static final Set<Key> COMPUTING = ConcurrentHashMap.newKeySet();
    protected static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();

    public PathfindersQuillItem(QuarkModule module, Item.Properties properties) {
        super("pathfinders_quill", module, properties);
    }

    public PathfindersQuillItem(QuarkModule module) {
        this(module, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1));
    }

    public static ResourceLocation getTargetBiome(ItemStack stack) {
        String str = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BIOME, (String)"");
        if (str.isEmpty()) {
            return null;
        }
        return new ResourceLocation(str);
    }

    public static int getOverlayColor(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_COLOR, (int)0xFFFFFF);
    }

    public static ItemStack forBiome(String biome, int color) {
        ItemStack stack = new ItemStack((ItemLike)PathfinderMapsModule.pathfinders_quill);
        PathfindersQuillItem.setBiome(stack, biome, color, false);
        return stack;
    }

    public static void setBiome(ItemStack stack, String biome, int color, boolean underground) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_BIOME, (String)biome);
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_COLOR, (int)color);
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_UNDERGROUND, (boolean)underground);
    }

    @Nullable
    public static ItemStack getActiveQuill(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            boolean searching;
            if (!(stack.m_41720_() instanceof PathfindersQuillItem) || !(searching = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_IS_SEARCHING, (boolean)false))) continue;
            return stack;
        }
        return null;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getTarget(stack) == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ItemStack active = PathfindersQuillItem.getActiveQuill(player);
        if (active != null) {
            player.m_5661_((Component)Component.m_237115_((String)"quark.misc.only_one_quill"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        Vec3 pos = player.m_20318_(1.0f);
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11713_, SoundSource.PLAYERS, 0.5f, 1.0f);
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_IS_SEARCHING, (boolean)true);
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SOURCE_X, (int)player.m_146903_());
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SOURCE_Z, (int)player.m_146907_());
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public ResourceLocation getTarget(ItemStack stack) {
        return PathfindersQuillItem.getTargetBiome(stack);
    }

    protected int getIterations() {
        return PathfinderMapsModule.pathfindersQuillSpeed;
    }

    protected boolean isMultiThreaded() {
        return PathfinderMapsModule.multiThreaded;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean held) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ItemStack runningStack;
            Player player;
            ServerLevel sl = (ServerLevel)level;
            if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_IS_SEARCHING, (boolean)false) && entity instanceof Player && PathfindersQuillItem.getActiveQuill(player = (Player)entity) == stack && (runningStack = this.search(stack, sl, player, slot)) != stack) {
                String msg = runningStack.m_41619_() ? this.getFinishedMessage() : this.getFailedMessage();
                player.m_5661_((Component)Component.m_237115_((String)msg), true);
                Vec3 pos = player.m_20318_(1.0f);
                level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12211_, SoundSource.PLAYERS, 0.5f, 1.0f);
                player.m_150109_().m_6836_(slot, runningStack);
            }
        }
    }

    protected String getFinishedMessage() {
        return "quark.misc.quill_finished";
    }

    protected String getFailedMessage() {
        return "quark.misc.quill_failed";
    }

    protected ItemStack search(ItemStack stack, ServerLevel level, Player player, int slot) {
        ResourceLocation searchKey = this.getTarget(stack);
        if (searchKey == null) {
            return ItemStack.f_41583_;
        }
        InteractionResultHolder<BlockPos> result = this.isMultiThreaded() ? this.searchConcurrent(searchKey, stack, level, player) : this.searchIterative(searchKey, stack, level, player, this.getIterations());
        if (result.m_19089_() == InteractionResult.FAIL) {
            return ItemStack.f_41583_;
        }
        if (result.m_19089_() == InteractionResult.PASS) {
            return stack;
        }
        BlockPos found = (BlockPos)result.m_19095_();
        return this.createMap(level, found, searchKey, stack);
    }

    protected InteractionResultHolder<BlockPos> searchConcurrent(ResourceLocation searchKey, ItemStack stack, ServerLevel level, Player player) {
        int sourceX = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SOURCE_X, (int)0);
        int sourceZ = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SOURCE_Z, (int)0);
        BlockPos centerPos = new BlockPos(sourceX, 64, sourceZ);
        Key key = new Key(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)centerPos), searchKey);
        if (COMPUTING.contains(key)) {
            return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
        }
        if (RESULTS.containsKey(key)) {
            InteractionResultHolder<BlockPos> ret = RESULTS.get(key);
            if (ret.m_19089_() == InteractionResult.PASS) {
                return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
            }
            return ret;
        }
        ItemStack dummy = stack.m_41777_();
        EXECUTORS.submit(() -> {
            COMPUTING.add(key);
            RESULTS.put(key, this.searchIterative(searchKey, dummy, level, player, Integer.MAX_VALUE));
            COMPUTING.remove(key);
        });
        return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
    }

    protected InteractionResultHolder<BlockPos> searchIterative(ResourceLocation searchKey, ItemStack stack, ServerLevel level, Player player, int maxIter) {
        int y = player.m_146904_();
        for (int i = 0; i < maxIter; ++i) {
            int height = 64;
            BlockPos nextPos = PathfindersQuillItem.nextPos(stack);
            if (nextPos == null) {
                return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
            }
            int[] searchedHeights = Mth.m_216250_((int)y, (int)(level.m_141937_() + 1), (int)level.m_151558_(), (int)64).toArray();
            int testX = nextPos.m_123341_();
            int testZ = nextPos.m_123343_();
            int quartX = QuartPos.m_175400_((int)testX);
            int quartZ = QuartPos.m_175400_((int)testZ);
            for (int testY : searchedHeights) {
                Climate.Sampler sampler;
                int quartY = QuartPos.m_175400_((int)testY);
                ServerChunkCache cache = level.m_7726_();
                BiomeSource source = cache.m_8481_().m_62218_();
                Holder holder = source.m_203407_(quartX, quartY, quartZ, sampler = cache.m_214994_().m_224579_());
                if (!holder.m_203373_(searchKey)) continue;
                BlockPos mapPos = new BlockPos(testX, testY, testZ);
                return InteractionResultHolder.m_19090_((Object)mapPos);
            }
        }
        return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
    }

    protected static BlockPos nextPos(ItemStack stack) {
        int step = 32;
        int sourceX = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SOURCE_X, (int)0);
        int sourceZ = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SOURCE_Z, (int)0);
        int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
        int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
        int leg = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_LEG, (int)-1);
        int legIndex = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_LEG_INDEX, (int)0);
        BlockPos cursor = new BlockPos(x, 0, z).m_121945_(DIRECTIONS[(leg + 4) % 4]);
        int newX = cursor.m_123341_();
        int newZ = cursor.m_123343_();
        int legSize = leg / 2 + 1;
        int maxLegs = 4 * Math.floorDiv(PathfinderMapsModule.searchRadius, 32);
        if (legIndex >= legSize) {
            if (leg > maxLegs) {
                return null;
            }
            ++leg;
            legIndex = 0;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)newX);
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)newZ);
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_LEG, (int)leg);
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_LEG_INDEX, (int)(++legIndex));
        int retX = sourceX + newX * 32;
        int retZ = sourceZ + newZ * 32;
        return new BlockPos(retX, 0, retZ);
    }

    public ItemStack createMap(ServerLevel level, BlockPos targetPos, ResourceLocation target, ItemStack original) {
        int color = PathfindersQuillItem.getOverlayColor(original);
        MutableComponent biomeComponent = Component.m_237115_((String)("biome." + target.m_135827_() + "." + target.m_135815_()));
        ItemStack stack = MapItem.m_42886_((Level)level, (int)targetPos.m_123341_(), (int)targetPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)level, (ItemStack)stack);
        MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)targetPos, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
        stack.m_41714_((Component)Component.m_237110_((String)"item.quark.biome_map", (Object[])new Object[]{biomeComponent}));
        stack.m_41698_("display").m_128405_("MapColor", color);
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"quark:is_pathfinder", (boolean)true);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent getSearchingComponent() {
        MutableComponent comp = Component.m_237115_((String)"quark.misc.quill_searching");
        int dots = ClientTicker.ticksInGame / 10 % 4;
        for (int i = 0; i < dots; ++i) {
            comp.m_130946_(".");
        }
        return comp;
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.isEnabled() && this.m_220152_(group) || group == CreativeModeTab.f_40754_) {
            for (PathfinderMapsModule.TradeInfo trade : PathfinderMapsModule.tradeList) {
                items.add((Object)PathfindersQuillItem.forBiome(trade.biome.toString(), trade.color));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> comps, TooltipFlag flags) {
        ResourceLocation biome = this.getTarget(stack);
        if (biome != null) {
            if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_IS_SEARCHING, (boolean)false)) {
                comps.add((Component)PathfindersQuillItem.getSearchingComponent().m_130940_(ChatFormatting.BLUE));
            }
            comps.add((Component)Component.m_237115_((String)("biome." + biome.m_135827_() + "." + biome.m_135815_())).m_130940_(ChatFormatting.GRAY));
        } else {
            comps.add((Component)Component.m_237115_((String)"quark.misc.quill_blank").m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, id) -> id == 0 ? 0xFFFFFF : PathfindersQuillItem.getOverlayColor(stack);
    }

    private record Key(GlobalPos pos, ResourceLocation structure) {
    }
}

