/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.IRuneColorProvider;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.UpdateTridentMessage;
import vazkii.quark.content.tools.client.render.GlintRenderTypes;
import vazkii.quark.content.tools.item.RuneItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class ColorRunesModule
extends QuarkModule {
    public static final String TAG_RUNE_ATTACHED = "quark:RuneAttached";
    public static final String TAG_RUNE_COLOR = "quark:RuneColor";
    public static final int RUNE_TYPES = 17;
    private static final ThreadLocal<ItemStack> targetStack = new ThreadLocal();
    @Hint
    public static TagKey<Item> runesTag;
    public static TagKey<Item> runesLootableTag;
    public static List<RuneItem> runes;
    public static Item rainbow_rune;
    public static Item blank_rune;
    @Config
    public static int dungeonWeight;
    @Config
    public static int netherFortressWeight;
    @Config
    public static int jungleTempleWeight;
    @Config
    public static int desertTempleWeight;
    @Config
    public static int itemQuality;
    @Config
    public static int applyCost;
    public static QuarkGenericTrigger applyRuneTrigger;
    public static QuarkGenericTrigger fullRainbowTrigger;
    private static final Map<ThrownTrident, ItemStack> TRIDENT_STACK_REFERENCES;

    public static void setTargetStack(ItemStack stack) {
        targetStack.set(stack);
    }

    public static int changeColor() {
        ItemStack target = targetStack.get();
        return ColorRunesModule.getStackColor(target);
    }

    private static int getStackColor(ItemStack target) {
        int color;
        if (target == null) {
            return -1;
        }
        LazyOptional<IRuneColorProvider> cap = ColorRunesModule.get((ICapabilityProvider)target);
        if (cap.isPresent() && (color = ((IRuneColorProvider)cap.orElse(s -> -1)).getRuneColor(target)) != -1) {
            return color;
        }
        if (!ItemNBTHelper.getBoolean((ItemStack)target, (String)TAG_RUNE_ATTACHED, (boolean)false)) {
            return -1;
        }
        ItemStack proxied = ItemStack.m_41712_((CompoundTag)ItemNBTHelper.getCompound((ItemStack)target, (String)TAG_RUNE_COLOR, (boolean)false));
        LazyOptional<IRuneColorProvider> proxyCap = ColorRunesModule.get((ICapabilityProvider)proxied);
        return ((IRuneColorProvider)proxyCap.orElse(s -> -1)).getRuneColor(target);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.glint, RenderType::m_110490_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlintTranslucent() {
        return ColorRunesModule.renderType(GlintRenderTypes.glintTranslucent, RenderType::m_110487_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getEntityGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.entityGlint, RenderType::m_110496_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getGlintDirect() {
        return ColorRunesModule.renderType(GlintRenderTypes.glintDirect, RenderType::m_110493_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getEntityGlintDirect() {
        return ColorRunesModule.renderType(GlintRenderTypes.entityGlintDirect, RenderType::m_110499_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getArmorGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.armorGlint, RenderType::m_110481_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getArmorEntityGlint() {
        return ColorRunesModule.renderType(GlintRenderTypes.armorEntityGlint, RenderType::m_110484_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RenderType renderType(List<RenderType> list, Supplier<RenderType> vanilla) {
        int color = ColorRunesModule.changeColor();
        return color >= 0 && color <= 17 ? list.get(color) : vanilla.get();
    }

    public static void syncTrident(Consumer<Packet<?>> packetConsumer, ThrownTrident trident, boolean force) {
        ItemStack stack = trident.m_7941_();
        ItemStack prev = TRIDENT_STACK_REFERENCES.get(trident);
        if (force || prev == null || ItemStack.m_150942_((ItemStack)stack, (ItemStack)prev)) {
            packetConsumer.accept(QuarkNetwork.toVanillaPacket(new UpdateTridentMessage(trident.m_19879_(), stack), NetworkDirection.PLAY_TO_CLIENT));
        } else {
            TRIDENT_STACK_REFERENCES.put(trident, stack);
        }
    }

    public static ItemStack withRune(ItemStack stack, ItemStack rune) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_RUNE_ATTACHED, (boolean)true);
        ItemNBTHelper.setCompound((ItemStack)stack, (String)TAG_RUNE_COLOR, (CompoundTag)rune.serializeNBT());
        return stack;
    }

    public static ItemStack withRune(ItemStack stack, DyeColor color) {
        return ColorRunesModule.withRune(stack, new ItemStack((ItemLike)runes.get(color.m_41060_())));
    }

    @Override
    public void register() {
        runes = Arrays.stream(DyeColor.values()).map(color -> new RuneItem(color.m_7912_() + "_rune", this, color.m_41060_(), true)).toList();
        rainbow_rune = new RuneItem("rainbow_rune", this, 16, true);
        blank_rune = new RuneItem("blank_rune", this, 17, false);
        applyRuneTrigger = QuarkAdvancementHandler.registerGenericTrigger("apply_rune");
        fullRainbowTrigger = QuarkAdvancementHandler.registerGenericTrigger("full_rainbow");
    }

    @Override
    public void setup() {
        runesTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "runes"));
        runesLootableTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "runes_lootable"));
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        int weight = 0;
        if (event.getName().equals((Object)BuiltInLootTables.f_78742_)) {
            weight = dungeonWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78760_)) {
            weight = netherFortressWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78686_)) {
            weight = jungleTempleWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78764_)) {
            weight = desertTempleWeight;
        }
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)blank_rune).m_79707_(weight).m_79711_(itemQuality).m_7512_();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack output = event.getOutput();
        if (!left.m_41619_() && !right.m_41619_() && ColorRunesModule.canHaveRune(left) && right.m_204117_(runesTag)) {
            ItemStack out = (output.m_41619_() ? left : output).m_41777_();
            ItemNBTHelper.setBoolean((ItemStack)out, (String)TAG_RUNE_ATTACHED, (boolean)true);
            ItemNBTHelper.setCompound((ItemStack)out, (String)TAG_RUNE_COLOR, (CompoundTag)right.serializeNBT());
            event.setOutput(out);
            String name = event.getName();
            int cost = Math.max(1, applyCost);
            if (!(name == null || name.isEmpty() || out.m_41788_() && out.m_41786_().getString().equals(name))) {
                out.m_41714_((Component)Component.m_237113_((String)name));
                ++cost;
            }
            event.setCost(cost);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public void onAnvilUse(AnvilRepairEvent event) {
        Player player;
        ItemStack right = event.getRight();
        if (right.m_204117_(runesTag) && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            applyRuneTrigger.trigger(sp);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean rainbow;
        String tag = "quark:what_are_you_gay_or_something";
        Player player = event.player;
        boolean wasRainbow = player.getPersistentData().m_128471_("quark:what_are_you_gay_or_something");
        if (wasRainbow != (rainbow = this.isPlayerRainbow(player))) {
            player.getPersistentData().m_128379_("quark:what_are_you_gay_or_something", rainbow);
            if (rainbow && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                fullRainbowTrigger.trigger(sp);
            }
        }
    }

    private boolean isPlayerRainbow(Player player) {
        ImmutableSet checks = ImmutableSet.of((Object)EquipmentSlot.HEAD, (Object)EquipmentSlot.CHEST, (Object)EquipmentSlot.LEGS, (Object)EquipmentSlot.FEET);
        for (EquipmentSlot slot : checks) {
            ItemStack stack = player.m_6844_(slot);
            if (!stack.m_41619_() && ColorRunesModule.getStackColor(stack) == 16) continue;
            return false;
        }
        return true;
    }

    private static boolean canHaveRune(ItemStack stack) {
        return stack.m_41793_() || stack.m_41720_() == Items.f_42522_ && CompassItem.m_40736_((ItemStack)stack);
    }

    private static LazyOptional<IRuneColorProvider> get(ICapabilityProvider provider) {
        return provider.getCapability(QuarkCapabilities.RUNE_COLOR);
    }

    static {
        dungeonWeight = 10;
        netherFortressWeight = 8;
        jungleTempleWeight = 8;
        desertTempleWeight = 8;
        itemQuality = 0;
        applyCost = 5;
        TRIDENT_STACK_REFERENCES = new WeakHashMap<ThrownTrident, ItemStack>();
    }
}

