/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.Tags;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.module.hint.HintManager;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.config.AirStoneClusterConfig;
import vazkii.quark.content.world.config.BigStoneClusterConfig;
import vazkii.quark.content.world.gen.BigStoneClusterGenerator;
import vazkii.quark.content.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.WORLD)
public class BigStoneClustersModule
extends QuarkModule {
    @Config
    public static BigStoneClusterConfig calcite = new BigStoneClusterConfig(BiomeTags.f_207606_);
    @Config
    public static BigStoneClusterConfig limestone = new BigStoneClusterConfig(Tags.Biomes.IS_SWAMP, BiomeTags.f_207603_);
    @Config
    public static BigStoneClusterConfig jasper = new BigStoneClusterConfig(BiomeTags.f_207607_, Tags.Biomes.IS_SANDY);
    @Config
    public static BigStoneClusterConfig shale = new BigStoneClusterConfig(Tags.Biomes.IS_SNOWY);
    @Config
    public static BigStoneClusterConfig myalite = new AirStoneClusterConfig(DimensionConfig.end(false), 20, 6, 100, 58, 62, CompoundBiomeConfig.fromBiomeReslocs(false, "minecraft:end_highlands")).setVertical(40, 10);
    @Config(description="Blocks that stone clusters can replace. If you want to make it so it only replaces in one dimension,\ndo \"block|dimension\", as we do for netherrack and end stone by default.")
    public static List<String> blocksToReplace = Lists.newArrayList((Object[])new String[]{"minecraft:stone", "minecraft:andesite", "minecraft:diorite", "minecraft:granite", "minecraft:netherrack|minecraft:the_nether", "minecraft:end_stone|minecraft:the_end", "quark:marble", "quark:limestone", "quark:jasper", "quark:slate"});
    public static BiPredicate<Level, Block> blockReplacePredicate = (w, b) -> false;

    @Override
    public void setup() {
        BooleanSupplier alwaysTrue = () -> true;
        this.add(calcite, Blocks.f_152497_, alwaysTrue);
        this.add(limestone, NewStoneTypesModule.limestoneBlock, () -> NewStoneTypesModule.enabledWithLimestone);
        this.add(jasper, NewStoneTypesModule.jasperBlock, () -> NewStoneTypesModule.enabledWithJasper);
        this.add(shale, NewStoneTypesModule.shaleBlock, () -> NewStoneTypesModule.enabledWithShale);
        this.add(myalite, NewStoneTypesModule.myaliteBlock, () -> NewStoneTypesModule.enabledWithMyalite);
    }

    @Override
    public void addAdditionalHints(BiConsumer<Item, Component> consumer) {
        if (BigStoneClustersModule.calcite.enabled) {
            HintManager.hintItem(consumer, (ItemLike)Items.f_151047_);
        }
    }

    private void add(BigStoneClusterConfig config, Block block, BooleanSupplier condition) {
        WorldGenHandler.addGenerator(this, new BigStoneClusterGenerator(config, block.m_49966_(), condition), GenerationStep.Decoration.UNDERGROUND_DECORATION, 0);
    }

    @Override
    public void configChanged() {
        blockReplacePredicate = (b, w) -> false;
        Iterator<String> iterator = blocksToReplace.iterator();
        while (iterator.hasNext()) {
            String s;
            String bname = s = iterator.next();
            String dimension = null;
            if (bname.contains("|")) {
                String[] toks = bname.split("\\|");
                bname = toks[0];
                dimension = toks[1];
            }
            String dimFinal = dimension;
            Registry.f_122824_.m_6612_(new ResourceLocation(bname)).ifPresent(blockObj -> {
                if (blockObj != Blocks.f_50016_) {
                    blockReplacePredicate = dimFinal == null ? blockReplacePredicate.or((w, b) -> blockObj == b) : blockReplacePredicate.or((w, b) -> {
                        if (blockObj != b) {
                            return false;
                        }
                        if (w == null) {
                            return false;
                        }
                        return w.m_46472_().m_135782_().toString().equals(dimFinal);
                    });
                }
            });
        }
    }
}

