/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ECConfig {
    public static final CogwheelLimitations COGWHEEL_LIMITATIONS;
    public static final ForgeConfigSpec spec;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CogwheelLimitations::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        COGWHEEL_LIMITATIONS = (CogwheelLimitations)specPair.getLeft();
    }

    public static class CogwheelLimitations {
        public ForgeConfigSpec.IntValue maxBirchRPM;
        public ForgeConfigSpec.IntValue maxOakRPM;
        public ForgeConfigSpec.IntValue maxSpruceRPM;
        public ForgeConfigSpec.IntValue maxDarkOakRPM;
        public ForgeConfigSpec.IntValue maxJungleRPM;
        public ForgeConfigSpec.IntValue maxAcaciaRPM;
        public ForgeConfigSpec.IntValue maxWarpedRPM;
        public ForgeConfigSpec.IntValue maxCrimsonRPM;
        public ForgeConfigSpec.IntValue maxCopperRPM;
        public ForgeConfigSpec.IntValue maxIronRPM;
        public ForgeConfigSpec.IntValue maxSteelRPM;
        public ForgeConfigSpec.IntValue maxBirchSU;
        public ForgeConfigSpec.IntValue maxOakSU;
        public ForgeConfigSpec.IntValue maxSpruceSU;
        public ForgeConfigSpec.IntValue maxDarkOakSU;
        public ForgeConfigSpec.IntValue maxJungleSU;
        public ForgeConfigSpec.IntValue maxAcaciaSU;
        public ForgeConfigSpec.IntValue maxWarpedSU;
        public ForgeConfigSpec.IntValue maxCrimsonSU;
        public ForgeConfigSpec.IntValue maxCopperSU;
        public ForgeConfigSpec.IntValue maxIronSU;
        public ForgeConfigSpec.IntValue maxSteelSU;

        CogwheelLimitations(ForgeConfigSpec.Builder builder) {
            builder.comment("Limit the maximum RPM and or SU of cogwheels, by default these values are both set to maximum, this will not overwrite the max RPM set in the create config").push("Cogwheel Limitations");
            builder.comment("Limit the maximum RPM of cogwheels, this will not overwrite the max RPM set in the create config").push("Cogwheel Rotation Limitations");
            this.maxBirchRPM = builder.comment("Hard limit the ammount of RPM that a birch cogwheel can sustain").translation("todo").defineInRange("maxBirchRPM", 256, 1, Integer.MAX_VALUE);
            this.maxOakRPM = builder.comment("Hard limit the ammount of RPM that a oak cogwheel can sustain").translation("todo").defineInRange("maxOakRPM", 256, 1, Integer.MAX_VALUE);
            this.maxSpruceRPM = builder.comment("Hard limit the ammount of RPM that a spruce cogwheel can sustain").translation("todo").defineInRange("maxSpruceRPM", 256, 1, Integer.MAX_VALUE);
            this.maxDarkOakRPM = builder.comment("Hard limit the ammount of RPM that a Dark Oak cogwheel can sustain").translation("todo").defineInRange("maxDarkOakRPM", 256, 1, Integer.MAX_VALUE);
            this.maxJungleRPM = builder.comment("Hard limit the ammount of RPM that a jungle cogwheel can sustain").translation("todo").defineInRange("maxJungleRPM", 256, 1, Integer.MAX_VALUE);
            this.maxAcaciaRPM = builder.comment("Hard limit the ammount of RPM that a acacia cogwheel can sustain").translation("todo").defineInRange("maxAcaciaRPM", 256, 1, Integer.MAX_VALUE);
            this.maxWarpedRPM = builder.comment("Hard limit the ammount of RPM that a warped cogwheel can sustain").translation("todo").defineInRange("maxWarpedRPM", 256, 1, Integer.MAX_VALUE);
            this.maxCrimsonRPM = builder.comment("Hard limit the ammount of RPM that a crimson cogwheel can sustain").translation("todo").defineInRange("maxCrimsonRPM", 256, 1, Integer.MAX_VALUE);
            this.maxCopperRPM = builder.comment("Hard limit the ammount of RPM that a copper cogwheel can sustain").translation("todo").defineInRange("maxCopperRPM", 256, 1, Integer.MAX_VALUE);
            this.maxIronRPM = builder.comment("Hard limit the ammount of RPM that a iron cogwheel can sustain").translation("todo").defineInRange("maxIronRPM", 256, 1, Integer.MAX_VALUE);
            this.maxSteelRPM = builder.comment("Hard limit the ammount of RPM that a steel cogwheel can sustain").translation("todo").defineInRange("maxSteelRPM", 256, 1, Integer.MAX_VALUE);
            builder.comment("Limit the maximum Stress of cogwheels").push("Cogwheel Stress Limitations");
            this.maxBirchSU = builder.comment("Hard limit the ammount of SU that a birch cogwheel can sustain").translation("todo").defineInRange("maxBirchSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxOakSU = builder.comment("Hard limit the ammount of SU that a oak cogwheel can sustain").translation("todo").defineInRange("maxOakSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxSpruceSU = builder.comment("Hard limit the ammount of SU that a spruce cogwheel can sustain").translation("todo").defineInRange("maxSpruceSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxDarkOakSU = builder.comment("Hard limit the ammount of SU that a Dark Oak cogwheel can sustain").translation("todo").defineInRange("maxDarkOakSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxJungleSU = builder.comment("Hard limit the ammount of SU that a jungle cogwheel can sustain").translation("todo").defineInRange("maxJungleSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxAcaciaSU = builder.comment("Hard limit the ammount of SU that a acacia cogwheel can sustain").translation("todo").defineInRange("maxAcaciaSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxWarpedSU = builder.comment("Hard limit the ammount of SU that a warped cogwheel can sustain").translation("todo").defineInRange("maxWarpedSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxCrimsonSU = builder.comment("Hard limit the ammount of SU that a crimson cogwheel can sustain").translation("todo").defineInRange("maxCrimsonSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxCopperSU = builder.comment("Hard limit the ammount of SU that a copper cogwheel can sustain").translation("todo").defineInRange("maxCopperSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxIronSU = builder.comment("Hard limit the ammount of SU that a iron cogwheel can sustain").translation("todo").defineInRange("maxIronSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.maxSteelSU = builder.comment("Hard limit the ammount of SU that a steel cogwheel can sustain").translation("todo").defineInRange("maxSteelSU", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        }
    }
}

