/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.enums.config;

public enum DistanceGenerationMode {
    NONE(1),
    BIOME_ONLY(2),
    BIOME_ONLY_SIMULATE_HEIGHT(3),
    SURFACE(4),
    FEATURES(5),
    FULL(6);

    public static DistanceGenerationMode RENDERABLE;
    public final byte complexity;

    private DistanceGenerationMode(byte complexity) {
        this.complexity = complexity;
    }

    public static DistanceGenerationMode previous(DistanceGenerationMode mode) {
        switch (mode) {
            case FULL: {
                return FEATURES;
            }
            case FEATURES: {
                return SURFACE;
            }
            case SURFACE: {
                return BIOME_ONLY_SIMULATE_HEIGHT;
            }
            case BIOME_ONLY_SIMULATE_HEIGHT: {
                return BIOME_ONLY;
            }
            case BIOME_ONLY: {
                return NONE;
            }
        }
        return null;
    }

    public static DistanceGenerationMode next(DistanceGenerationMode mode) {
        switch (mode) {
            case FEATURES: {
                return FULL;
            }
            case SURFACE: {
                return FEATURES;
            }
            case BIOME_ONLY_SIMULATE_HEIGHT: {
                return SURFACE;
            }
            case BIOME_ONLY: {
                return BIOME_ONLY_SIMULATE_HEIGHT;
            }
            case NONE: {
                return BIOME_ONLY;
            }
        }
        return null;
    }

    static {
        RENDERABLE = BIOME_ONLY;
    }
}

