/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render;

import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.render.LodFogConfig;
import com.seibel.lod.core.render.objects.Shader;
import com.seibel.lod.core.render.objects.ShaderProgram;
import com.seibel.lod.core.render.objects.VertexAttribute;
import com.seibel.lod.core.render.objects.VertexAttributePostGL43;
import com.seibel.lod.core.render.objects.VertexAttributePreGL43;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.IVersionConstants;
import java.awt.Color;

public class LodRenderProgram
extends ShaderProgram {
    public static final String VERTEX_SHADER_PATH = "shaders/standard.vert";
    public static final String VERTEX_CURVE_SHADER_PATH = "shaders/curve.vert";
    public static final String FRAGMENT_SHADER_PATH = "shaders/flat_shaded.frag";
    private static final IVersionConstants VERSION_CONSTANTS = SingletonHandler.get(IVersionConstants.class);
    public final VertexAttribute vao;
    public final int combinedMatUniform;
    public final int modelOffsetUniform;
    public final int worldYOffsetUniform;
    public final int mircoOffsetUniform;
    public final int earthRadiusUniform;
    public final int lightMapUniform;
    public final int fogColorUniform;
    public final int fogScaleUniform;
    public final int fogVerticalScaleUniform;
    public final int nearFogStartUniform;
    public final int nearFogLengthUniform;
    public final int fullFogModeUniform;
    public final LodFogConfig fogConfig;

    public LodRenderProgram(LodFogConfig fogConfig) {
        super(() -> Shader.loadFile(fogConfig.earthCurveRatio != 0 ? VERTEX_CURVE_SHADER_PATH : VERTEX_SHADER_PATH, false, new StringBuilder()).toString(), () -> fogConfig.loadAndProcessFragShader(FRAGMENT_SHADER_PATH, false).toString(), "fragColor", new String[]{"vPosition", "color"});
        this.fogConfig = fogConfig;
        this.combinedMatUniform = this.getUniformLocation("combinedMatrix");
        this.modelOffsetUniform = this.getUniformLocation("modelOffset");
        this.worldYOffsetUniform = this.tryGetUniformLocation("worldYOffset");
        this.mircoOffsetUniform = this.getUniformLocation("mircoOffset");
        this.earthRadiusUniform = this.tryGetUniformLocation("earthRadius");
        this.lightMapUniform = this.getUniformLocation("lightMap");
        this.fullFogModeUniform = this.getUniformLocation("fullFogMode");
        this.fogColorUniform = this.getUniformLocation("fogColor");
        this.fogScaleUniform = this.tryGetUniformLocation("fogScale");
        this.fogVerticalScaleUniform = this.tryGetUniformLocation("fogVerticalScale");
        this.nearFogStartUniform = this.tryGetUniformLocation("nearFogStart");
        this.nearFogLengthUniform = this.tryGetUniformLocation("nearFogLength");
        int vertexByteCount = LodUtil.LOD_VERTEX_FORMAT.getByteSize();
        this.vao = GLProxy.getInstance().VertexAttributeBufferBindingSupported ? new VertexAttributePostGL43() : new VertexAttributePreGL43();
        this.vao.bind();
        this.vao.setVertexAttribute(0, 0, VertexAttribute.VertexPointer.addUnsignedShortsPointer(4, false, true));
        this.vao.setVertexAttribute(0, 1, VertexAttribute.VertexPointer.addUnsignedBytesPointer(4, true, false));
        try {
            this.vao.completeAndCheck(vertexByteCount);
        }
        catch (RuntimeException e) {
            System.out.println(LodUtil.LOD_VERTEX_FORMAT);
            throw e;
        }
        if (this.earthRadiusUniform != -1) {
            this.setUniform(this.earthRadiusUniform, 6371000.0f / (float)fogConfig.earthCurveRatio);
        }
    }

    public LodFogConfig isShaderUsable() {
        LodFogConfig newConfig = LodFogConfig.generateFogConfig();
        if (this.fogConfig.equals(newConfig)) {
            return null;
        }
        return newConfig;
    }

    @Override
    public void bind() {
        super.bind();
        this.vao.bind();
    }

    @Override
    public void unbind() {
        super.unbind();
        this.vao.unbind();
    }

    @Override
    public void free() {
        this.vao.free();
        super.free();
    }

    public void bindVertexBuffer(int vbo) {
        this.vao.bindBufferToAllBindingPoint(vbo);
    }

    public void unbindVertexBuffer() {
        this.vao.unbindBuffersFromAllBindingPoint();
    }

    public void fillUniformData(Mat4f combinedMatrix, Color fogColor, int lightmapBindPoint, int worldHeight, int worldYOffset, int lodDrawDistance, int vanillaDrawDistance, boolean fullFogMode) {
        super.bind();
        vanillaDrawDistance += 32;
        this.setUniform(this.combinedMatUniform, combinedMatrix);
        this.setUniform(this.mircoOffsetUniform, 0.01f);
        this.setUniform(this.lightMapUniform, lightmapBindPoint);
        if (this.worldYOffsetUniform != -1) {
            this.setUniform(this.worldYOffsetUniform, (float)worldYOffset);
        }
        this.setUniform(this.fullFogModeUniform, fullFogMode ? 1 : 0);
        this.setUniform(this.fogColorUniform, fogColor);
        float nearFogLen = (float)vanillaDrawDistance * 0.2f / (float)lodDrawDistance;
        float nearFogStart = (float)vanillaDrawDistance * (VERSION_CONSTANTS.isVanillaRenderedChunkSquare() ? (float)Math.sqrt(2.0) : 1.0f) / (float)lodDrawDistance;
        if (this.nearFogStartUniform != -1) {
            this.setUniform(this.nearFogStartUniform, nearFogStart);
        }
        if (this.nearFogLengthUniform != -1) {
            this.setUniform(this.nearFogLengthUniform, nearFogLen);
        }
        if (this.fogScaleUniform != -1) {
            this.setUniform(this.fogScaleUniform, 1.0f / (float)lodDrawDistance);
        }
        if (this.fogVerticalScaleUniform != -1) {
            this.setUniform(this.fogVerticalScaleUniform, 1.0f / (float)worldHeight);
        }
    }

    public void setModelPos(Vec3f modelPos) {
        this.setUniform(this.modelOffsetUniform, modelPos);
    }
}

