/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util.gridList;

import com.seibel.lod.core.objects.Pos2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public class MovableGridRingList<T>
extends ArrayList<T>
implements List<T> {
    private AtomicReference<Pos2D> pos = new AtomicReference();
    private final int halfSize;
    private final int size;
    private final ReentrantReadWriteLock moveLock = new ReentrantReadWriteLock();

    public MovableGridRingList(int halfSize, int centerX, int centerY) {
        super((halfSize * 2 + 1) * (halfSize * 2 + 1));
        this.size = halfSize * 2 + 1;
        this.halfSize = halfSize;
        this.pos.set(new Pos2D(centerX - halfSize, centerY - halfSize));
        this.clear();
    }

    @Override
    public void clear() {
        this.clear(null);
    }

    public void clear(Consumer<? super T> d) {
        this.moveLock.writeLock().lock();
        try {
            if (d != null) {
                super.forEach((? super E t) -> {
                    if (t != null) {
                        d.accept(t);
                    }
                });
            }
            super.clear();
            super.ensureCapacity(this.size * this.size);
            for (int i = 0; i < this.size * this.size; ++i) {
                super.add(null);
            }
        }
        finally {
            this.moveLock.writeLock().unlock();
        }
    }

    public Pos2D getCenter() {
        Pos2D bottom = this.pos.get();
        return new Pos2D(bottom.x + this.halfSize, bottom.y + this.halfSize);
    }

    public Pos2D getMinInRange() {
        return this.pos.get();
    }

    public Pos2D getMaxInRange() {
        Pos2D bottom = this.pos.get();
        return new Pos2D(bottom.x + this.size - 1, bottom.y + this.size - 1);
    }

    public int getSize() {
        return this.size;
    }

    public int getHalfSize() {
        return this.halfSize;
    }

    public boolean inRange(int x, int y) {
        Pos2D min = this.pos.get();
        return x >= min.x && x < min.x + this.size && y >= min.y && y < min.y + this.size;
    }

    private boolean _inRangeAquired(int x, int y, Pos2D min) {
        return x >= min.x && x < min.x + this.size && y >= min.y && y < min.y + this.size;
    }

    private T _getUnsafe(int x, int y) {
        return (T)super.get(Math.floorMod(x, this.size) + Math.floorMod(y, this.size) * this.size);
    }

    private void _setUnsafe(int x, int y, T t) {
        super.set(Math.floorMod(x, this.size) + Math.floorMod(y, this.size) * this.size, t);
    }

    private T _swapUnsafe(int x, int y, T t) {
        return super.set(Math.floorMod(x, this.size) + Math.floorMod(y, this.size) * this.size, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int x, int y) {
        Pos2D min = this.pos.get();
        if (!this._inRangeAquired(x, y, min)) {
            return null;
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D newMin = this.pos.get();
            if (min != newMin && !this._inRangeAquired(x, y, newMin)) {
                T t = null;
                return t;
            }
            T t = this._getUnsafe(x, y);
            return t;
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(int x, int y, T t) {
        Pos2D min = this.pos.get();
        if (!this._inRangeAquired(x, y, min)) {
            return false;
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D newMin = this.pos.get();
            if (min != newMin && !this._inRangeAquired(x, y, newMin)) {
                boolean bl = false;
                return bl;
            }
            this._setUnsafe(x, y, t);
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T swap(int x, int y, T t) {
        Pos2D min = this.pos.get();
        if (!this._inRangeAquired(x, y, min)) {
            return t;
        }
        this.moveLock.readLock().lock();
        try {
            Pos2D newMin = this.pos.get();
            if (min != newMin && !this._inRangeAquired(x, y, newMin)) {
                T t2 = t;
                return t2;
            }
            T t3 = this._swapUnsafe(x, y, t);
            return t3;
        }
        finally {
            this.moveLock.readLock().unlock();
        }
    }

    public T setChained(int x, int y, T t) {
        return (T)(this.set(x, y, t) ? t : null);
    }

    public boolean move(int newCenterX, int newCenterY) {
        return this.move(newCenterX, newCenterY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(int newCenterX, int newCenterY, Consumer<? super T> d) {
        Pos2D cPos = this.pos.get();
        int newMinX = newCenterX - this.halfSize;
        int newMinY = newCenterY - this.halfSize;
        if (cPos.x == newMinX && cPos.y == newMinY) {
            return false;
        }
        this.moveLock.writeLock().lock();
        try {
            cPos = this.pos.get();
            int deltaX = newMinX - cPos.x;
            int deltaY = newMinY - cPos.y;
            if (deltaX == 0 && deltaY == 0) {
                boolean bl = false;
                return bl;
            }
            if (Math.abs(deltaX) >= this.size || Math.abs(deltaY) >= this.size) {
                this.clear(d);
            } else {
                for (int x = 0; x < this.size; ++x) {
                    for (int y = 0; y < this.size; ++y) {
                        Object t;
                        if (x - deltaX >= 0 && y - deltaY >= 0 && x - deltaX < this.size && y - deltaY < this.size || (t = this._swapUnsafe(x + cPos.x, y + cPos.y, null)) == null || d == null) continue;
                        d.accept(t);
                    }
                }
            }
            this.pos.set(new Pos2D(newMinX, newMinY));
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveLock.writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        Pos2D p = this.pos.get();
        return "MovabeGridRingList[" + p.x + this.halfSize + "," + p.y + this.halfSize + "] " + this.size + "*" + this.size + "[" + this.size() + "]";
    }

    public String toDetailString() {
        StringBuilder str = new StringBuilder("\n");
        int i = 0;
        str.append(this);
        str.append("\n");
        for (Object t : this) {
            str.append(t != null ? t.toString() : "NULL");
            str.append(", ");
            if (++i % this.size != 0) continue;
            str.append("\n");
        }
        return str.toString();
    }
}

