/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.config;

import com.seibel.lod.core.config.ConfigAnnotations;
import fabric.com.seibel.lod.common.LodCommonMain;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shaded.electronwill.nightconfig.core.file.CommentedFileConfig;

@Deprecated
public abstract class ConfigGui {
    private static final Pattern INTEGER_ONLY_REGEX = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY_REGEX = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, EntryInfo> entryMap = new HashMap<String, EntryInfo>();
    private static final String MOD_NAME = "DistantHorizons";
    private static final String MOD_NAME_READABLE = "Distant Horizons";
    private static final Logger LOGGER = LogManager.getLogger((String)"DistantHorizons");
    private static Path configFilePath;

    public static void init(Class<?> config) {
        class_310 mc = class_310.method_1551();
        configFilePath = mc.field_1697.toPath().resolve("config").resolve("DistantHorizons.toml");
        ConfigGui.initNestedClass(config, "");
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        ConfigGui.loadFromFile();
    }

    private static void initNestedClass(Class<?> config, String category) {
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if (field.isAnnotationPresent(ConfigAnnotations.Entry.class) || field.isAnnotationPresent(ConfigAnnotations.Comment.class) || field.isAnnotationPresent(ConfigAnnotations.ScreenEntry.class)) {
                info.category = category;
                if (!LodCommonMain.serverSided) {
                    ConfigGui.initClient(field, info, category);
                }
            }
            if (field.isAnnotationPresent(ConfigAnnotations.Entry.class)) {
                entryMap.put((String)(!category.isEmpty() ? category + "." : "") + field.getName(), info);
                info.varClass = field.getType();
                try {
                    info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (field.isAnnotationPresent(ConfigAnnotations.ScreenEntry.class)) {
                ConfigGui.initNestedClass(field.getType(), (String)(!category.isEmpty() ? category + "." : "") + field.getName());
            }
            if (field.isAnnotationPresent(ConfigAnnotations.FileComment.class)) {
                entryMap.put((String)(!category.isEmpty() ? category + "." : "") + field.getName(), info);
                info.fileComment = true;
                try {
                    info.value = info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            info.field = field;
        }
    }

    private static void initClient(Field field, EntryInfo info, String category) {
        Class<?> fieldClass = field.getType();
        ConfigAnnotations.Entry entry = field.getAnnotation(ConfigAnnotations.Entry.class);
        ConfigAnnotations.ScreenEntry screenEntry = field.getAnnotation(ConfigAnnotations.ScreenEntry.class);
        if (entry != null) {
            info.width = entry.width();
        } else if (screenEntry != null) {
            info.width = screenEntry.width();
        }
        if (entry != null) {
            if (!entry.name().equals("")) {
                info.name = class_2561.method_43471((String)entry.name());
            }
            if (fieldClass == Integer.TYPE) {
                ConfigGui.textField(info, Integer::parseInt, INTEGER_ONLY_REGEX, entry.minValue(), entry.maxValue(), true);
            } else if (fieldClass == Double.TYPE) {
                ConfigGui.textField(info, Double::parseDouble, DECIMAL_ONLY_REGEX, entry.minValue(), entry.maxValue(), false);
            } else if (fieldClass == String.class || fieldClass == List.class) {
                info.max = entry.maxValue() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)entry.maxValue();
                ConfigGui.textField(info, String::length, null, Math.min(entry.minValue(), 0.0), Math.max(entry.maxValue(), 1.0), true);
            } else if (fieldClass == Boolean.TYPE) {
                Function<Object, class_2561> func = value -> class_2561.method_43471((String)((Boolean)value != false ? "True" : "False")).method_27692((Boolean)value != false ? class_124.field_1060 : class_124.field_1061);
                info.widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            } else if (fieldClass.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, class_2561> func = value -> class_2561.method_43471((String)("DistantHorizons.config.enum." + fieldClass.getSimpleName() + "." + info.value.toString()));
                info.widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            }
        } else if (screenEntry != null) {
            if (!screenEntry.name().equals("")) {
                info.name = class_2561.method_43471((String)screenEntry.name());
            }
            info.screenButton = true;
            info.gotoScreen = (String)(!info.category.isEmpty() ? info.category + "." : "") + field.getName();
        }
        entries.add(info);
    }

    private static void textField(EntryInfo info, Function<String, Number> func, Pattern pattern, double minValue, double maxValue, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (editBox, button) -> stringValue -> {
            if (!(stringValue = stringValue.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)stringValue).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (isNumber && !stringValue.isEmpty() && !stringValue.equals("-") && !stringValue.equals(".")) {
                value = (Number)func.apply((String)stringValue);
                boolean bl = inLimits = value.doubleValue() >= minValue && value.doubleValue() <= maxValue;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<class_342, class_5250>((class_342)editBox, class_2561.method_43471((String)(value.doubleValue() < minValue ? "\u00a7cMinimum length" + (cast ? " is " + (int)minValue : " is " + minValue) : "\u00a7cMaximum length" + (cast ? " is " + (int)maxValue : " is " + maxValue))));
            }
            info.tempValue = stringValue;
            editBox.method_1868(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            button.field_22763 = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = value;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, (String)Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).collect(Collectors.toList()).get(0));
            }
            return true;
        };
    }

    public static void saveToFile() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).build();
        try {
            if (!configFilePath.getParent().toFile().exists()) {
                Files.createDirectory(configFilePath.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(configFilePath, new LinkOption[0])) {
                Files.createFile(configFilePath, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            LOGGER.info("Failed creating config file for Distant Horizons at the path [" + configFilePath.toString() + "].");
            e.printStackTrace();
        }
        ConfigGui.loadFileWithErrorCheck(config);
        config.set("_version", (Object)1);
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            editSingleOption.saveOption(info, config);
            if (editSingleOption.getEntry((String)(info.category.isEmpty() ? "" : info.category + ".") + "_" + info.field.getName()) == null) continue;
            config.setComment((String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), String.valueOf(editSingleOption.getEntry((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_\u0001"}, (String)(info.category.isEmpty() ? "" : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001."}, (String)info.category)), (String)info.field.getName()))).defaultValue));
        }
        config.save();
        config.close();
    }

    public static void loadFromFile() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            LOGGER.info("Config file not found for Distant Horizons. Creating config...");
            ConfigGui.saveToFile();
            return;
        }
        ConfigGui.loadFileWithErrorCheck(config);
        config.set("_version", (Object)1);
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            editSingleOption.loadOption(info, config);
            if (editSingleOption.getEntry((String)(info.category.isEmpty() ? "" : info.category + ".") + "_" + info.field.getName()) == null) continue;
            config.setComment((String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), String.valueOf(editSingleOption.getEntry((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_\u0001"}, (String)(info.category.isEmpty() ? "" : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001."}, (String)info.category)), (String)info.field.getName()))).defaultValue));
        }
        config.close();
    }

    public static void loadFileWithErrorCheck(CommentedFileConfig config) {
        try {
            config.load();
        }
        catch (Exception e) {
            LOGGER.info("Error loading config for Distant Horizons at the path [" + configFilePath.toString() + "].");
            LOGGER.info("Creating a new config...");
            try {
                Files.deleteIfExists(configFilePath);
                ConfigGui.saveToFile();
            }
            catch (Exception f) {
                LOGGER.info("Failed creating config file for Distant Horizons at the path [" + configFilePath.toString() + "].");
                f.printStackTrace();
            }
        }
    }

    public static class_437 getScreen(class_437 parent, String category) {
        return new ConfigScreen(parent, category);
    }

    public static class EntryInfo<T> {
        Field field;
        Object widget;
        int width = 0;
        int max;
        Map.Entry<class_342, class_2561> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        class_2561 name;
        int index;
        boolean hideOption = false;
        boolean screenButton = false;
        String gotoScreen = "";
        String category;
        Class<T> varClass;
        @Deprecated
        boolean fileComment = false;
    }

    public static class editSingleOption {
        public static EntryInfo getEntry(String name) {
            return entryMap.get(name);
        }

        public static void saveOption(String name) {
            editSingleOption.saveOption(entryMap.get(name));
        }

        public static void saveOption(EntryInfo info) {
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
            ConfigGui.loadFileWithErrorCheck(config);
            editSingleOption.saveOption(info, config);
            config.close();
        }

        public static void saveOption(EntryInfo info, CommentedFileConfig config) {
            config.set((String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), info.value);
        }

        public static void loadOption(String name) {
            editSingleOption.loadOption(entryMap.get(name));
        }

        public static void loadOption(EntryInfo info) {
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
            ConfigGui.loadFileWithErrorCheck(config);
            editSingleOption.loadOption(info, config);
            config.close();
        }

        public static void loadOption(EntryInfo info, CommentedFileConfig config) {
            String itemPath = (String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName();
            if (config.contains(itemPath)) {
                if (info.field.getType().isEnum()) {
                    try {
                        info.value = config.getEnum(itemPath, info.varClass);
                    }
                    catch (IllegalArgumentException ignored) {
                        return;
                    }
                } else {
                    info.value = config.get(itemPath);
                }
            } else {
                config.set(itemPath, info.value);
            }
            try {
                info.field.set(null, info.value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static class ConfigScreen
    extends class_437 {
        private final String translationPrefix;
        private final class_437 parent;
        private final String category;
        private ConfigListWidget list;
        private boolean reload = false;

        protected ConfigScreen(class_437 parent, String category) {
            super((class_2561)class_2561.method_43471((String)(class_1074.method_4663((String)("DistantHorizons.config" + (String)(category.isEmpty() ? "." + category : "") + ".title")) ? "DistantHorizons.config.title" : "DistantHorizons.config" + (String)(category.isEmpty() ? "" : "." + category) + ".title")));
            this.parent = parent;
            this.category = category;
            this.translationPrefix = "DistantHorizons.config.";
        }

        public void method_25393() {
            super.method_25393();
        }

        public void method_25419() {
            ConfigGui.saveToFile();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }

        private class_4185 addBtn(class_4185 button) {
            this.method_37063((class_364)button);
            return button;
        }

        protected void method_25426() {
            super.method_25426();
            if (!this.reload) {
                ConfigGui.loadFromFile();
            }
            this.addBtn(new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20, class_5244.field_24335, button -> {
                ConfigGui.loadFromFile();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            class_4185 done = this.addBtn(new class_4185(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20, class_5244.field_24334, button -> {
                ConfigGui.saveToFile();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }));
            this.list = new ConfigListWidget(this.field_22787, this.field_22789 * 2, this.field_22790, 32, this.field_22790 - 32, 25);
            if (this.field_22787 != null && this.field_22787.field_1687 != null) {
                this.list.method_31322(false);
            }
            this.method_25429((class_364)this.list);
            for (EntryInfo info : entries) {
                Predicate processor;
                Map.Entry widget;
                if (!info.category.matches(this.category) || info.hideOption) continue;
                class_2561 name = info.name == null ? class_2561.method_43471((String)(this.translationPrefix + (String)(!info.category.isEmpty() ? info.category + "." : "") + info.field.getName())) : info.name;
                class_4185 resetButton = new class_4185(this.field_22789 - 10 - info.width - 5 - 40, 0, 40, 20, (class_2561)class_2561.method_43471((String)"Reset").method_27692(class_124.field_1061), button -> {
                    info.value = info.defaultValue;
                    info.tempValue = info.defaultValue.toString();
                    info.index = 0;
                    this.reload = true;
                    Objects.requireNonNull(this.field_22787).method_1507((class_437)this);
                });
                if (info.widget instanceof Map.Entry) {
                    widget = (Map.Entry)info.widget;
                    if (info.field.getType().isEnum()) {
                        widget.setValue(value -> class_2561.method_43471((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                    }
                    this.list.addButton((class_339)new class_4185(this.field_22789 - info.width - 10, 0, info.width, 20, (class_2561)((Function)widget.getValue()).apply(info.value), (class_4185.class_4241)widget.getKey()), (class_339)resetButton, null, name);
                    continue;
                }
                if (info.field.getType() == List.class) {
                    if (!this.reload) {
                        info.index = 0;
                    }
                    widget = new class_342(this.field_22793, this.field_22789 - info.width - 10, 0, info.width, 20, null);
                    widget.method_1880(info.width);
                    if (info.index < ((List)info.value).size()) {
                        widget.method_1867(String.valueOf(((List)info.value).get(info.index)));
                    } else {
                        widget.method_1867("");
                    }
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.method_1890(processor);
                    resetButton.method_25358(20);
                    resetButton.method_25355((class_2561)class_2561.method_43471((String)"R").method_27692(class_124.field_1061));
                    class_4185 cycleButton = new class_4185(this.field_22789 - 185, 0, 20, 20, (class_2561)class_2561.method_43471((String)String.valueOf(info.index)).method_27692(class_124.field_1065), button -> {
                        ((List)info.value).remove("");
                        this.reload = true;
                        ++info.index;
                        if (info.index > ((List)info.value).size()) {
                            info.index = 0;
                        }
                        Objects.requireNonNull(this.field_22787).method_1507((class_437)this);
                    });
                    this.list.addButton((class_339)widget, (class_339)resetButton, (class_339)cycleButton, name);
                    continue;
                }
                if (info.widget != null) {
                    widget = new class_342(this.field_22793, this.field_22789 - info.width - 10 + 2, 0, info.width - 4, 20, null);
                    widget.method_1880(info.width);
                    widget.method_1867(String.valueOf(info.value));
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.method_1890(processor);
                    this.list.addButton((class_339)widget, (class_339)resetButton, null, name);
                    continue;
                }
                if (info.screenButton) {
                    widget = new class_4185(this.field_22789 / 2 - info.width, this.field_22790 - 28, info.width * 2, 20, name, button -> {
                        ConfigGui.saveToFile();
                        Objects.requireNonNull(this.field_22787).method_1507(ConfigGui.getScreen(this, info.gotoScreen));
                    });
                    this.list.addButton((class_339)widget, null, null, null);
                    continue;
                }
                if (info.fileComment) continue;
                this.list.addButton(null, null, null, name);
            }
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.method_25420(matrices);
            this.list.method_25394(matrices, mouseX, mouseY, delta);
            ConfigScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
            for (EntryInfo info : entries) {
                if (!info.category.matches(this.category) || info.hideOption || !this.list.getHoveredButton(mouseX, mouseY).isPresent()) continue;
                class_339 buttonWidget = this.list.getHoveredButton(mouseX, mouseY).get();
                class_2561 text = ButtonEntry.buttonsWithText.get(buttonWidget);
                class_5250 name = class_2561.method_43471((String)(this.translationPrefix + (String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName()));
                String key = this.translationPrefix + (String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName() + ".@tooltip";
                if (info.error != null && text.equals(name)) {
                    this.method_25424(matrices, info.error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!class_1074.method_4663((String)key) || text == null || !text.equals(name)) continue;
                ArrayList<class_5250> list = new ArrayList<class_5250>();
                for (String str : class_1074.method_4662((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add(class_2561.method_43471((String)str));
                }
                this.method_30901(matrices, list, mouseX, mouseY);
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public static class ButtonEntry
    extends class_4265.class_4266<ButtonEntry> {
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        public final class_339 button;
        private final class_339 resetButton;
        private final class_339 indexButton;
        private final class_2561 text;
        private final List<class_339> children = new ArrayList<class_339>();
        public static final Map<class_339, class_2561> buttonsWithText = new HashMap<class_339, class_2561>();

        private ButtonEntry(class_339 button, class_2561 text, class_339 resetButton, class_339 indexButton) {
            buttonsWithText.put(button, text);
            this.button = button;
            this.resetButton = resetButton;
            this.text = text;
            this.indexButton = indexButton;
            if (button != null) {
                this.children.add(button);
            }
            if (resetButton != null) {
                this.children.add(resetButton);
            }
            if (indexButton != null) {
                this.children.add(indexButton);
            }
        }

        public static ButtonEntry create(class_339 button, class_2561 text, class_339 resetButton, class_339 indexButton) {
            return new ButtonEntry(button, text, resetButton, indexButton);
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.button != null) {
                this.button.field_22761 = y;
                this.button.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.resetButton != null) {
                this.resetButton.field_22761 = y;
                this.resetButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.indexButton != null) {
                this.indexButton.field_22761 = y;
                this.indexButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
            if (!(this.text == null || this.text.getString().contains("spacer") && this.button == null)) {
                class_332.method_27535((class_4587)matrices, (class_327)textRenderer, (class_2561)this.text, (int)12, (int)(y + 5), (int)0xFFFFFF);
            }
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }
    }

    public static class ConfigListWidget
    extends class_4265<ButtonEntry> {
        class_327 textRenderer;

        public ConfigListWidget(class_310 minecraftClient, int i, int j, int k, int l, int m) {
            super(minecraftClient, i, j, k, l, m);
            this.field_22744 = false;
            this.textRenderer = minecraftClient.field_1772;
        }

        public void addButton(class_339 button, class_339 resetButton, class_339 indexButton, class_2561 text) {
            this.method_25321((class_350.class_351)ButtonEntry.create(button, text, resetButton, indexButton));
        }

        public int method_25322() {
            return 10000;
        }

        public Optional<class_339> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.method_25396()) {
                if (buttonEntry.button == null || !buttonEntry.button.method_25405(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.button);
            }
            return Optional.empty();
        }
    }

    private static class ConfigScreenConfigs {
        public static final int SpaceFromRightScreen = 10;
        public static final int ButtonWidthSpacing = 5;
        public static final int ResetButtonWidth = 40;

        private ConfigScreenConfigs() {
        }
    }
}

