/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.provider;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.provider.BlockEntityPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SEnderChestUpdateRequest;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderChestPreviewProvider
implements PreviewProvider {
    @Override
    public List<ItemStack> getInventory(PreviewContext context) {
        Player owner = context.owner();
        if (owner == null) {
            return Collections.emptyList();
        }
        PlayerEnderChestContainer inventory = owner.m_36327_();
        int size = inventory.m_6643_();
        NonNullList items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            items.set(i, inventory.m_8020_(i).m_41777_());
        }
        return items;
    }

    @Override
    public int getInventoryMaxSize(PreviewContext context) {
        Player owner = context.owner();
        return owner == null ? 0 : owner.m_36327_().m_6643_();
    }

    @Override
    public boolean shouldDisplay(PreviewContext context) {
        Player owner = context.owner();
        if (owner == null) {
            return false;
        }
        return ShulkerBoxTooltip.config.preview.serverIntegration && ShulkerBoxTooltip.config.server.clientIntegration && ShulkerBoxTooltip.config.server.enderChestSyncType != Configuration.EnderChestSyncType.NONE && !owner.m_36327_().m_7983_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ColorKey getWindowColorKey(PreviewContext context) {
        return ColorKey.ENDER_CHEST;
    }

    @Override
    public void onInventoryAccessStart(PreviewContext context) {
        if (ShulkerBoxTooltip.config.server.enderChestSyncType == Configuration.EnderChestSyncType.PASSIVE && Minecraft.m_91087_().m_91403_() != null) {
            C2SMessages.ENDER_CHEST_UPDATE_REQUEST.sendToServer(new C2SEnderChestUpdateRequest());
        }
    }

    @Override
    public boolean showTooltipHints(PreviewContext context) {
        return ShulkerBoxTooltip.config.preview.serverIntegration && ShulkerBoxTooltip.config.server.clientIntegration && ShulkerBoxTooltip.config.server.enderChestSyncType != Configuration.EnderChestSyncType.NONE;
    }

    @Override
    public List<Component> addTooltip(PreviewContext context) {
        if (ShulkerBoxTooltipApi.isFullPreviewKeyPressed()) {
            return Collections.emptyList();
        }
        return BlockEntityPreviewProvider.getItemCountTooltip(new ArrayList<Component>(), this.getInventory(context));
    }
}

