/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.tooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PositionAwareTooltipComponent;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PreviewTooltipData;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;

public class PreviewTooltipComponent
extends PositionAwareTooltipComponent {
    private final PreviewRenderer renderer;
    private final PreviewProvider provider;
    private final PreviewContext context;

    public PreviewTooltipComponent(PreviewTooltipData data) {
        PreviewRenderer renderer = data.provider().getRenderer();
        if (renderer == null) {
            renderer = PreviewRenderer.getDefaultRendererInstance();
        }
        this.renderer = renderer;
        this.provider = data.provider();
        this.context = data.context();
    }

    public int m_142103_() {
        if (ShulkerBoxTooltip.config.preview.position == Configuration.PreviewPosition.INSIDE) {
            return this.renderer.getHeight() + 2 + 4;
        }
        return 0;
    }

    public int m_142069_(Font textRenderer) {
        if (ShulkerBoxTooltip.config.preview.position == Configuration.PreviewPosition.INSIDE) {
            return this.renderer.getWidth() + 2;
        }
        return 0;
    }

    @Override
    public void drawItems(Font textRenderer, int x, int y, PoseStack matrices, ItemRenderer itemRenderer, int z, @Nullable PositionAwareTooltipComponent.TooltipPosition tooltipPos) {
        this.renderer.setPreview(this.context, this.provider);
        this.renderer.setPreviewType(ShulkerBoxTooltipApi.getCurrentPreviewType(this.provider.isFullPreviewAvailable(this.context)));
        Configuration.PreviewPosition position = ShulkerBoxTooltip.config.preview.position;
        if (tooltipPos != null && position != Configuration.PreviewPosition.INSIDE) {
            int h = this.renderer.getHeight();
            int w = this.renderer.getWidth();
            Screen screen = tooltipPos.screen();
            x = Math.min(x - 4, screen.f_96543_ - w);
            y = tooltipPos.bottomY();
            if (position == Configuration.PreviewPosition.OUTSIDE_TOP || position == Configuration.PreviewPosition.OUTSIDE && y + h > screen.f_96544_) {
                y = tooltipPos.topY() - h;
            }
        }
        this.renderer.draw(x, y, z, matrices, textRenderer, itemRenderer, Minecraft.m_91087_().m_91097_());
    }
}

