/*
 * Decompiled with CFR 0.152.
 */
package com.ncpbails.culturaldelights.block.custom;

import com.ncpbails.culturaldelights.block.ModBlocks;
import com.ncpbails.culturaldelights.block.custom.CornUpperBlock;
import com.ncpbails.culturaldelights.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class CornBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty SUPPORTING = BooleanProperty.m_61465_((String)"supporting");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public CornBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float chance;
        int age;
        super.m_213897_(state, level, pos, random);
        if (level.isAreaLoaded(pos, 1) && level.m_45524_(pos.m_7494_(), 0) >= 6 && (age = this.getAge(state)) <= this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (chance = 10.0f)) + 1) == 0 ? 1 : 0) != 0)) {
            if (age == this.getMaxAge()) {
                CornUpperBlock cornUpper = (CornUpperBlock)((Object)ModBlocks.CORN_UPPER.get());
                if (cornUpper.m_49966_().m_60710_((LevelReader)level, pos.m_7494_()) && level.m_46859_(pos.m_7494_())) {
                    level.m_46597_(pos.m_7494_(), cornUpper.m_49966_());
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            } else {
                level.m_7731_(pos, this.withAge(age + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 3;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.CORN_KERNELS.get());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, SUPPORTING});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        if (!state.m_60795_()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            if (facing == Direction.UP) {
                return (BlockState)state.m_61124_((Property)SUPPORTING, (Comparable)Boolean.valueOf(this.isSupportingCornUpper(facingState)));
            }
        }
        return state;
    }

    public boolean isSupportingCornUpper(BlockState topState) {
        return topState.m_60734_() == ModBlocks.CORN_UPPER.get();
    }

    public boolean canGrow(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState upperState = worldIn.m_8055_(pos.m_7494_());
        if (upperState.m_60734_() instanceof CornUpperBlock) {
            return !((CornUpperBlock)upperState.m_60734_()).m_52307_(upperState);
        }
        return true;
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        BlockState upperState = level.m_8055_(pos.m_7494_());
        if (upperState.m_60734_() instanceof CornUpperBlock) {
            return !((CornUpperBlock)upperState.m_60734_()).m_52307_(upperState);
        }
        return true;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.m_216271_((RandomSource)level.f_46441_, (int)1, (int)4);
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int ageGrowth = Math.min(this.getAge(state) + this.getBonemealAgeIncrease((Level)level), 7);
        if (ageGrowth <= this.getMaxAge()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(ageGrowth)));
        } else {
            BlockState top = level.m_8055_(pos.m_7494_());
            if (top.m_60734_() == vectorwing.farmersdelight.common.registry.ModBlocks.RICE_CROP_PANICLES.get()) {
                BonemealableBlock growable = (BonemealableBlock)level.m_8055_(pos.m_7494_()).m_60734_();
                if (growable.m_7370_((BlockGetter)level, pos.m_7494_(), top, false)) {
                    growable.m_214148_(level, level.f_46441_, pos.m_7494_(), top);
                }
            } else {
                CornUpperBlock cornUpper = (CornUpperBlock)((Object)ModBlocks.CORN_UPPER.get());
                int remainingGrowth = ageGrowth - this.getMaxAge() - 1;
                if (cornUpper.m_49966_().m_60710_((LevelReader)level, pos.m_7494_()) && level.m_46859_(pos.m_7494_())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(this.getMaxAge())));
                    level.m_7731_(pos.m_7494_(), (BlockState)cornUpper.m_49966_().m_61124_((Property)CornUpperBlock.CORN_AGE, (Comparable)Integer.valueOf(remainingGrowth)), 2);
                }
            }
        }
    }
}

