/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CatwalkStairBlock
extends Block
implements IWrenchable,
SimpleWaterloggedBlock {
    private static final VoxelShape BOX_NORTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape BOX_SOUTH = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape BOX_WEST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)8.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape BOX_EAST = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CatwalkStairBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!placementHelper.matchesItem(heldItem)) {
            return InteractionResult.PASS;
        }
        return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_();
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing.m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case Direction.SOUTH -> BOX_SOUTH;
            case Direction.EAST -> BOX_EAST;
            case Direction.WEST -> BOX_WEST;
            default -> BOX_NORTH;
        };
    }

    public static boolean isCatwalkStair(ItemStack test) {
        return test.m_41720_() instanceof BlockItem && CatwalkStairBlock.isCatwalkStair(((BlockItem)test.m_41720_()).m_40614_());
    }

    public static boolean isCatwalkStair(Block test) {
        return test instanceof CatwalkStairBlock;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return CatwalkStairBlock::isCatwalkStair;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> CatwalkStairBlock.isCatwalkStair(state.m_60734_());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction facing = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
            PlacementOffset offset = PlacementOffset.success((Vec3i)pos.m_121945_(facing).m_7918_(0, 1, 0));
            return offset.withTransform(s -> (BlockState)s.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))));
        }
    }
}

